// Init
UI.moduleBuilder['setting']['ChAutoScanPanel'] = function(){

    var initData = {
        ChAutoScanBg:UI.bg_overlay,
        AutoScanImg:UI.window_bg,
        ReBtnImg:UI.item_bg,
        ScanBtnImg:UI.item_bg,
        AutoScanTitle1:"[SE0584]", //"Auto Channel Scan",
        AutoScanTitle2:"[SE2632]",//"Auto Channel Scan-Air",
        DTVtext:"[SE0098]",//"DTV"
        ATVtext:"[SE0097]",//"ATV"
        ReBtntext:"[SE2700]",//"Rescan"
        ScanBtntext:"[SE1673]",//"Skip"
        ChScanMsg:"[OT0151]"//No channels were found,please check your RF cable connection.
    };
    var template = Util.readJson("module/setting/ChAutoScanPanel.json");
    var ChAutoScanPanel = SubModule.create(initData, template);
    var AutoScanPage = UI.getItem(ChAutoScanPanel, "AutoScanPage");
    var AutoScanTitle2 = UI.getItem(AutoScanPage, "AutoScanTitle2");
    var ReScanBtn = UI.getItem(AutoScanPage, "ReScanBtn");
    var AutoScanBtn = UI.getItem(AutoScanPage, "AutoScanBtn");
    var ScanBtntext = UI.getItem(AutoScanBtn,"ScanBtntext");
    var percentBar = UI.getItem(AutoScanPage, "percentBar");
    var percentComp = UI.getItem(percentBar, "percentImg");
    var percentTxt = UI.getItem(percentBar, "percentText");
    var DTVBtn = UI.getItem(AutoScanPage, "DTVBtn");
    var DTVNum = UI.getItem(DTVBtn,"DTVNum");
    var ATVBtn = UI.getItem(AutoScanPage, "ATVBtn");
    var ATVNum = UI.getItem(ATVBtn,"ATVNum");
    var ChScanMsg = UI.getItem(AutoScanPage, "ChScanMsg");
    var DTVvalueFirstNum;
    var ATVvalueFirstNum;
    var FirstHasChannel;
    var SecHasChannel;

    ChAutoScanPanel.currFocus = UI.getItem(AutoScanPage, "AutoScanBtn");
    ChAutoScanPanel.noAutoClose = true;
    ChAutoScanPanel.protected=true;
    ChAutoScanPanel.enableKeyGroup = [
        CONST.KEY.VK_UP, CONST.KEY.VK_DOWN, CONST.KEY.VK_LEFT, CONST.KEY.VK_RIGHT,
        CONST.KEY.VK_BACKSPACE, CONST.KEY.VK_ENTER, CONST.KEY.VK_EXIT,
        CONST.KEY.VK_POWER,
        CONST.KEY.VK_1, CONST.KEY.VK_2, CONST.KEY.VK_3, CONST.KEY.VK_4, CONST.KEY.VK_5,
        CONST.KEY.VK_6, CONST.KEY.VK_7, CONST.KEY.VK_8, CONST.KEY.VK_9, CONST.KEY.VK_0,
        CONST.KEY.VK_VOLUME_UP, CONST.KEY.VK_VOLUME_DOWN,
        CONST.KEY.VK_KEYPAD_VOLUME_UP,CONST.KEY.VK_KEYPAD_VOLUME_DOWN,CONST.KEY.VK_MUTE,
        CONST.KEY.VK_CHANNEL_UP, CONST.KEY.VK_CHANNEL_DOWN,CONST.KEY.VK_KEYPAD_CHANNEL_UP,
        CONST.KEY.VK_KEYPAD_CHANNEL_DOWN
    ];
    ChAutoScanPanel.onPush =  function(){
        if ((appControl.getCurrentAPPName() == APPNAME.EPOS) && checkIsAppOn()) {
            DBG_ERROR("ChAutoScanPanel.onPush:epos is on,stop it");
            appControl.stopCurrentApp();
            appStoppedFunc = function () {
            };
        }
        DBG_INFO("ChAutoScanPanel.onPush");
        UI.registerKeyCodes(ChAutoScanPanel.enableKeyGroup);
        UI.setKeyGroup(7);
        liveTV.disconnectAllChannelIterator();
        liveTV.delHisChannels();
        settingInitChSetAutoScanPage();
        settingChSetStartChScan();
        ChAutoScanPanel.currFocus = UI.getItem(AutoScanPage, "AutoScanBtn");
    };
    function settingInitChSetAutoScanPage(){
        //data init
        DTVvalueFirstNum = 0;
        ATVvalueFirstNum = 0;
        FirstHasChannel = 0;
        SecHasChannel = 0;
        ChAutoScanPanel.chScanState = 0;//0:Scanning 1:Scan complete
        ChAutoScanPanel.currTunerModeNum = 0; //if auto scan is cable+air, 1:after cable dtv  2:after cable atv  3:after air dtv  4:after air atv
        ChAutoScanPanel.currTunerMode = 15; //15:ATSC-T,16:ATSC-C,17:Analog-T,18:Analog-C
        ChAutoScanPanel.completeNum = 0; //1 or 2,indacate the scan complete number
        ChAutoScanPanel.analogChannelNum = 0;
        ChAutoScanPanel.digitChannelNum = 0;
        ChAutoScanPanel.needRefreshChannelListFlag = 1;
        //"Auto Channel Scan-Antenna-DTV","Auto Channel Scan-Cable-DTV","Auto Channel Scan-Antenna-ATV","Auto Channel Scan-Cable-ATV","Auto Channel Scan-Complete",
        ChAutoScanPanel.AutoScanInfo = ["[SE2632]","[SE2633]","[SE2632]","[SE2633]","[SE2634]"];
        // UI init
        Percent.create(percentComp, percentTxt, 0);
        //percentComp.setPercent(0);
        ReScanBtn.alpha = 0;
        ReScanBtn.disable = true;
        percentBar.alpha = 1;
        percentTxt.alpha = 0;
        ChScanMsg.alpha = 0;
        ATVBtn.alpha = 1;
        DTVBtn.alpha = 1;
        UI.setText(DTVNum,"0");
        UI.setText(ATVNum,"0");
        UI.setText(ScanBtntext,"[SE1673]");//"Skip"
    }
    function settingChSetStartChScan(){
        try{
            if(tv == false){
                DBG_INFO(".................................Start channel scan, TV == false.................................", DebugLevel.ALWAYS);
                var ProgressTest = function(){
                    percentComp.plus();
                    if(percentComp.percent >= 100){
                        ChAutoScanPanel.chScanState = 1;
                        UI.setText(ScanBtntext,"[SE0589]");//"Complete",
                        ReScanBtn.alpha = 1;
                        ReScanBtn.disable = false;
                        clearInterval(ChAutoScanPanel.searchTimer);
                        UI.updateStage();
                        showScanNoChannelMsg();
                    }else{
                        UI.setText(DTVNum,percentComp.percent+"");
                        UI.setText(ATVNum,percentComp.percent+"");
                    }
                };
                ChAutoScanPanel.searchTimer = setInterval(ProgressTest ,100);
            }else{
                if(model.channelSearch.getRunning() == 1){
                    DBG_INFO("settingChSetStartChScan:channel is searching!!");
                    model.channelSearch.Stop();
                }
                var currSource = getCurrentSourceId();
                if(currSource != 0){
                    DBG_INFO("settingChSetStartChScan:currSource="+currSource,DebugLevel.ERROR);
                    changeSourceTo(0);
                }
                var tunerMode = model.channelSearch.getSource();
                switch( tunerMode ) {
                    case 17:  //Analog-T
                        tunerMode = 15;
                        model.channelSearch.setSource(15); //ATSC-T
                        break;
                    case 18: //Analog-C
                        tunerMode = 16;
                        model.channelSearch.setSource(16); //ATSC-C
                        break;
                    default :
                        break;
                }
                ChAutoScanPanel.currTunerMode = tunerMode;
                ChAutoScanPanel.origTunerMode = tunerMode;

                DBG_ERROR("...................................Current Source:" + tunerMode + ".......................................");
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_SEARCHING_PROCESS_CHANGED, settingChScanProgressChangeCallBack);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_FOUND_DIGIT_SERVICES_CHANGED, settingChScanDigitServicesChangeCallBack);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_FOUND_ANALOG_SERVICES_CHANGED, settingChScanAnalogServicesChangeCallBack);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_SEARCH_STATE_CHANGED, settingChScanStateChangeCallBack);
                model.channelSearch.Clear();
                model.channelSearch.getSearchingProgress();
                model.channelSearch.Start(0);
            }
            UI.setText(AutoScanTitle2,ChAutoScanPanel.AutoScanInfo[ChAutoScanPanel.currTunerMode - 15]);
        }catch (ex){
            DBG_INFO("settingChSetStartChScan: "+ex.message,DebugLevel.ERROR);
        }
    }
    function settingChSetReScan(){
        try{
            if(tv == false){
                var ProgressTest = function(){
                    percentComp.plus();
                    if(percentComp.percent >= 100){
                        ChAutoScanPanel.chScanState = 1;
                        UI.setText(ScanBtntext,"[SE0589]");//"Complete",
                        ReScanBtn.alpha = 1;
                        ReScanBtn.disable = false;
                        clearInterval(ChAutoScanPanel.searchTimer);
                        UI.updateStage();
                        showScanNoChannelMsg();
                    }else{
                        UI.setText(DTVNum,percentComp.percent+"");
                        UI.setText(ATVNum,percentComp.percent+"");
                    }
                };
                ChAutoScanPanel.searchTimer = setInterval(ProgressTest ,100);
            }else{
                var tunerMode = model.channelSearch.getSource();
                ChAutoScanPanel.currTunerMode = tunerMode;
                DBG_INFO("ChAutoScanPanel.currTunerMode::"+ChAutoScanPanel.currTunerMode,DebugLevel.ALWAYS);
                model.channelSearch.Start(0);
            }
            UI.setText(AutoScanTitle2,ChAutoScanPanel.AutoScanInfo[ChAutoScanPanel.currTunerMode - 15]);
        }catch (ex){
            DBG_INFO("settingChSetReScan: "+ex.message,DebugLevel.ERROR);
        }
    }
    function settingChScanProgressChangeCallBack(value){
        DBG_INFO("settingChScanProgressChangeCallBack::"+value,DebugLevel.ALWAYS);
        if( ChAutoScanPanel.currTunerModeNum == 0){
            value = value/4;
        }else if( ChAutoScanPanel.currTunerModeNum == 1){
            value = 25 + value/4;
        }
        else if( ChAutoScanPanel.currTunerModeNum == 2){
            value = 50 + value/4;
        }
        else if( ChAutoScanPanel.currTunerModeNum == 3){
            value = 75 + value/4;
        }

        DBG_INFO("after settingChScanProgressChangeCallBack::"+value,DebugLevel.ALWAYS);
        percentComp.setPercentNoVoice(value);
    }
    function settingChScanDigitServicesChangeCallBack(value){
        DBG_INFO("settingChScanDigitServicesChangeCallBack::"+value + "currTunerModeNum:"+ChAutoScanPanel.currTunerModeNum,DebugLevel.ALWAYS);
        if( ChAutoScanPanel.currTunerModeNum == 0){
            if ((FirstHasChannel == 0) && (value > 0) ){
                DBG_INFO("the first section dtv channel is > 0");
                FirstHasChannel = 1;
            }
            DTVvalueFirstNum = value;
        }else if( ChAutoScanPanel.currTunerModeNum == 2){
            if ((SecHasChannel == 0) && (value > 0) ){
                DBG_INFO("the second section dtv channel is > 0");
                SecHasChannel = 1;
            }
            value = DTVvalueFirstNum + value;
        }

        ChAutoScanPanel.digitChannelNum = value;
        UI.setText(DTVNum,value+"");
        DBG_INFO("after settingChScanDigitServicesChangeCallBack::"+value,DebugLevel.ALWAYS);
    }
    function settingChScanAnalogServicesChangeCallBack(value){
        DBG_INFO("settingChScanAnalogServicesChangeCallBack::"+value +"currTunerModeNum:"+ChAutoScanPanel.currTunerModeNum,DebugLevel.ALWAYS);
        if(ChAutoScanPanel.currTunerModeNum == 2) return;
        if( ChAutoScanPanel.currTunerModeNum == 1){
            if ((FirstHasChannel == 0) && (value > 0) ){
                DBG_INFO("the first section atv channel is > 0");
                FirstHasChannel = 1;
            }
            ATVvalueFirstNum = value;
        }else if( ChAutoScanPanel.currTunerModeNum == 3){
            if ((SecHasChannel == 0) && (value > 0) ){
                DBG_INFO("the second section atv channel is > 0");
                SecHasChannel = 1;
            }
            value = ATVvalueFirstNum + value;
        }

        UI.setText(ATVNum,value+"");
        ChAutoScanPanel.analogChannelNum = value;
        DBG_INFO("after settingChScanAnalogServicesChangeCallBack::"+value,DebugLevel.ALWAYS);
    }
    function settingChScanStateChangeCallBack(value){
        try{
            DBG_INFO("settingChScanStateChangeCallBack:"+value,DebugLevel.ALWAYS);
            switch (value){
                case 0://complete
                    if( ChAutoScanPanel.currTunerModeNum == 0 || ChAutoScanPanel.currTunerModeNum == 2){
                        ChAutoScanPanel.currTunerModeNum++;
                        DBG_INFO("complete case 0:settingChScanStateChangeCallBack::"+ChAutoScanPanel.currTunerModeNum,DebugLevel.ALWAYS);
                        ChangeTunerMode();
                    }
                    else if ( ChAutoScanPanel.currTunerModeNum == 1){
                        ChAutoScanPanel.currTunerModeNum++;
                        DBG_INFO("complete case 1:settingChScanStateChangeCallBack::"+ChAutoScanPanel.currTunerModeNum,DebugLevel.ALWAYS);
                        ChAutoScanPanel.completeNum++;
                        ChangeTunerMode2();
                    }
                    else{
                        DBG_INFO("complete case 2:settingChScanStateChangeCallBack::"+ChAutoScanPanel.currTunerModeNum,DebugLevel.ALWAYS);
                        ChAutoScanPanel.completeNum++;
                        ChAutoScanPanel.chScanState = 1;
                        ReScanBtn.alpha = 1;
                        ReScanBtn.disable = false;
                        UI.updateStage();
                        UI.setText(AutoScanTitle2,ChAutoScanPanel.AutoScanInfo[4]);//"Auto Channel Scan-Complete",
                        UI.setText(ScanBtntext,"[SE0589]");//"Complete",
                        UI.setVoiceStr(ScanBtntext,"[SE0589]");
                        showScanNoChannelMsg();
                        if (FirstHasChannel == 0 && SecHasChannel == 1){
                            DBG_INFO("complete:the first section not has channel and the sec section has channel, no need to change tuner mode");
                        }
                        else {
                            DBG_INFO("complete:else,need to change tuner mode");
                            model.channelSearch.setSource(ChAutoScanPanel.origTunerMode);
                        }
                        model.channelSearch.Finish();
                    }
                    break;
                case 1://searching
                    break;
                case 11://cancel
                    if (ChAutoScanPanel.completeNum == 0){
                        ChAutoScanPanel.completeNum++;
                        if (ChAutoScanPanel.currTunerModeNum == 0){
                            ChAutoScanPanel.currTunerModeNum = 1;
                            DBG_INFO("cancel case 0:settingChScanStateChangeCallBack::"+ChAutoScanPanel.currTunerModeNum,DebugLevel.ALWAYS);
                            settingChScanProgressChangeCallBack(100);
                        }
                        ChAutoScanPanel.currTunerModeNum = 2;
                        DBG_INFO("cancel case 1:settingChScanStateChangeCallBack::"+ChAutoScanPanel.currTunerModeNum,DebugLevel.ALWAYS);
                        ChangeTunerMode3();
                    }
                    else if (ChAutoScanPanel.completeNum == 1){
                        ChAutoScanPanel.completeNum++;
                        if (ChAutoScanPanel.currTunerModeNum == 2){
                            ChAutoScanPanel.currTunerModeNum = 3;
                            DBG_INFO("cancel case 2:settingChScanStateChangeCallBack::"+ChAutoScanPanel.currTunerModeNum,DebugLevel.ALWAYS);
                            settingChScanProgressChangeCallBack(100);
                        }
                        ChAutoScanPanel.chScanState = 1;
                        ReScanBtn.alpha = 1;
                        ReScanBtn.disable = false;
                        UI.setText(ScanBtntext,"[SE0589]");//"Complete",
                        UI.setVoiceStr(ScanBtntext,"[SE0589]");
                        if (FirstHasChannel == 0 && SecHasChannel == 1){
                            DBG_INFO("cancel:the first section not has channel and the sec section has channel, no need to change tuner mode");
                        }
                        else {
                            DBG_INFO("cancel:else,need to change tuner mode");
                            model.channelSearch.setSource(ChAutoScanPanel.origTunerMode);
                        }
                        model.channelSearch.Finish();
                    }
                    break;
                default :
                    ChAutoScanPanel.chScanState = 1;
                    ReScanBtn.alpha = 1;
                    ReScanBtn.disable = false;
                    UI.setText(ScanBtntext,"[SE0589]");//"Complete",
                    UI.setVoiceStr(ScanBtntext,"[SE0589]");
                    showScanNoChannelMsg();
                    break;
            }
        }catch(ex){
            DBG_INFO("settingChScanStateChangeCallBack:"+ex.message,DebugLevel.ERROR);
        }
    }
    function ChangeTunerMode(){
        if(tv){
            if(ChAutoScanPanel.currTunerMode == 15){    //from ATSC-T
                model.channelSearch.setSource(17);	//to   Analog-T
                ChAutoScanPanel.currTunerMode = 17;
            }else{                                      //from ATSC-C
                model.channelSearch.setSource(18);	//to   Analog-C
                ChAutoScanPanel.currTunerMode = 18;
            }

            model.channelSearch.Start(0);
            UI.setText(AutoScanTitle2,ChAutoScanPanel.AutoScanInfo[ChAutoScanPanel.currTunerMode - 15]);
        }
    }
    function ChangeTunerMode2(){
        if(tv){
            if(ChAutoScanPanel.currTunerMode == 17){//from Analog-T
                model.channelSearch.setSource(16);//to ATSC-C
                ChAutoScanPanel.currTunerMode = 16;
            }else if(ChAutoScanPanel.currTunerMode == 18){//from Analog-C
                model.channelSearch.setSource(15);//to ATSC-T
                ChAutoScanPanel.currTunerMode = 15;
            }

            model.channelSearch.Start(0);
            UI.setText(AutoScanTitle2,ChAutoScanPanel.AutoScanInfo[ChAutoScanPanel.currTunerMode - 15]);
        }
    }
    function ChangeTunerMode3(){
        if(tv){
            if(ChAutoScanPanel.currTunerMode == 15 || ChAutoScanPanel.currTunerMode == 17){//from tuner T
                model.channelSearch.setSource(16);//to ATSC-C
                ChAutoScanPanel.currTunerMode = 16;
            }else if(ChAutoScanPanel.currTunerMode == 16 || ChAutoScanPanel.currTunerMode == 18){//from tuner C
                model.channelSearch.setSource(15);//to ATSC-T
                ChAutoScanPanel.currTunerMode = 15;
            }

            model.channelSearch.Start(0);
            UI.setText(AutoScanTitle2,ChAutoScanPanel.AutoScanInfo[ChAutoScanPanel.currTunerMode - 15]);
        }
    }
    function showScanNoChannelMsg(){
        if(ChAutoScanPanel.analogChannelNum == 0 && ChAutoScanPanel.digitChannelNum == 0){
            DBG_ERROR("showScanNoChannelMsg!!!");
            percentBar.alpha = 0;
            ATVBtn.alpha = 0;
            DTVBtn.alpha = 0;
            ChScanMsg.alpha = 1;
            UI.updateStage();
        }
    }
    ReScanBtn.onkey_ENTER = function(){
        settingInitChSetAutoScanPage();
        UI.focusTo(AutoScanBtn);
        settingChSetReScan();
    }

    AutoScanBtn.onkey_ENTER = function(){
        if(tv == false){
            if(ChAutoScanPanel.chScanState == 0){
                UI.setText(ScanBtntext,"[SE0589]");//"Complete",
                ReScanBtn.alpha = 1;
                ReScanBtn.disable = false;
                UI.updateStage();
                clearInterval(ChAutoScanPanel.searchTimer);
                ChAutoScanPanel.chScanState = 1;
            }else{
                UI.popSubModule();
                if(GLOBAL.StartSearchFromLiveTV){
                    UI.popModule();
                    openLiveTVModule();
                }
            }
        }else{
            if(ChAutoScanPanel.chScanState == 0){
		//On "Cancel" click.
                DBG_INFO("ChScanStopScan:"+ChAutoScanPanel.chScanState);
                //正在搜索,取消搜索
                model.channelSearch.Stop();
                //ChAutoScanPanel.chScanState  = 1;
                //UI.setText(ScanBtntext,"[SE0589]");
                DBG_INFO("ChScanStopScan stop!!!!!!!!!!!!!!!");
             
            }else{
                if(model.channelSearch.getRunning() == 1){
                    DBG_INFO("settingChSetStopChScan:not stoped,error!",DebugLevel.ERROR);
                    model.channelSearch.Stop();
                }
                //UI.popSubModule();
                //if(GLOBAL.StartSearchFromLiveTV){
                    UI.popAllModule();
                    openLiveTVModule();
                //}
            }
        }
    };
    ChAutoScanPanel.onPop = function(){
        clearInterval(ChAutoScanPanel.searchTimer);
        DBG_INFO("ChAutoScanPanel:onPop!",DebugLevel.ALWAYS);
        UI.registerKeyCodes(null);
        UI.setKeyGroup(7);
        if(tv){
            DBG_ERROR("state::" +model.channelSearch.getRunning());
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_SEARCHING_PROCESS_CHANGED, settingChScanProgressChangeCallBack);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_FOUND_DIGIT_SERVICES_CHANGED, settingChScanDigitServicesChangeCallBack);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_FOUND_ANALOG_SERVICES_CHANGED, settingChScanAnalogServicesChangeCallBack);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_SEARCH_STATE_CHANGED, settingChScanStateChangeCallBack);
            if(model.channelSearch.getRunning() == 1){  //is searching
                DBG_ERROR("ChAutoScanPanel.onPop:not stoped,error!");
                model.channelSearch.Stop();
            }
        }
        if(ChAutoScanPanel.needRefreshChannelListFlag){
            liveTV.initChannelList();
            liveTV.setChannelListOprtData(0, 0);
        }
    };
    ChAutoScanPanel.onkey_BACKSPACE = function(){
        if( ChAutoScanPanel.chScanState == 1)
        {
            UI.popSubModule();
            if(GLOBAL.StartSearchFromLiveTV){
                UI.popAllModule();
                openLiveTVModule();
            }
        }
    };
    ChAutoScanPanel.onkey_EXIT = function(){
        if( ChAutoScanPanel.chScanState == 1)
        {
            UI.popAllModule();
            openLiveTVModule();
        }
    };

}
