/**
 * Created by Hisense on 2016-1-5.
 */
// Init
UI.moduleBuilder['setting']['AudioModeSettingsDTS'] = function(){

    var initData = {
        audioSheetImg: UI["setting_bg"],
        audioImg1: "setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_audio_154x154.png",
        sndModeImg1: UI.btn_normal_bg,
        audiotitle1: "[SE0058]",//Sound
        SndModeTitle: "[SE0059]",//Sound Mode
        SpeakersTitle:"[SE3250]",//Speakers
        BassBoostTitle: "[SE0068]",//Bass Boost
        SurroundSoundTitle: "[OT0417]",//Surround Sound
        DialogClarityTitle: "[OT0058]",//Dialog Clarity
        equalizerTitle: "[SE0074]",//Equalizer
        wallMountTitle: "[SE2936]"//Wall Mount Setup
    };
    var template = Util.readJson("module/setting/AudioModeSettingsDTS.json");
    var setSndPanel = SubModule.create(initData, template);
    var AudioModeSettingsDTS = UI.getSubModule("AudioModeSettingsDTS");
    var audioRightGrp = UI.getItem(setSndPanel, "audioRightGrp");
    UI.addMask(audioRightGrp, 1242, 926, 50, 6);
    UI.setView(audioRightGrp, 1242, 926);
    var sndModeMenu = UI.getItem(audioRightGrp, "sndModeMenu");

    var BassBoostMenu = UI.getItem(AudioModeSettingsDTS, "BassBoostMenu");
    var SurroundSoundMenu = UI.getItem(AudioModeSettingsDTS, "SurroundSoundMenu");
    var DialogClarityMenu = UI.getItem(AudioModeSettingsDTS, "DialogClarityMenu");
    var equalizerMenu = UI.getItem(AudioModeSettingsDTS, "equalizerMenu");

    AudioModeSettingsDTS.PageData = {

        "BassBoostArr": ["[GE0003]","[GE0002]","[GE0001]","[GE0006]"],//Normal Mode,Night Mode,Off
        "DialogClarityArr":["[GE0003]","[GE0002]","[GE0001]","[GE0006]"],//Low/ Medium /High / off
        sndHelpInfo: {
            BassBoostMenu: {
                title: "Total Sonics",
                info: "[OT0422]"
            },
            SurroundSoundMenu: {
                title: "Total Surround",
                info: "[OT0423]"
            },
            DialogClarityMenu: {
                title: "Total Volume",
                info: "[OT0424]"
            },
            equalizerMenu: {
                title: "Equalizer",
                info: "[SE0564]"//"Boost the volume at different frequencies."
            },
            wallMountMenu: {
                title: "Wall Mount Setup",
                info: "[SE2937]"//"Automatically optimize the sound based on the position of the TV."
            }
        },
        ARCDeviceWorkingState: {
            Working: 1,
            RestIng: 0
        },
        DisableMenuNameARC:["BassBoostMenu","SurroundSoundMenu","DialogClarityMenu"],
        headphoneInsert: 0
    };

    /*AudioModeSettingsDTS.DisableSoundByARCOn = function () {
        try {
            var BassBoostMenu = UI.getItem(AudioModeSettingsDTS, "BassBoostMenu");
            var SurroundSoundMenu = UI.getItem(AudioModeSettingsDTS, "SurroundSoundMenu");
            var DialogClarityMenu = UI.getItem(AudioModeSettingsDTS, "DialogClarityMenu");
            var wallMountMenu = UI.getItem(AudioModeSettingsDTS, "wallMountMenu");
            var SpeakersMenu = UI.getItem(AudioModeSettingsDTS, "SpeakersMenu");
            var DisableFocusFlag = false;
            getARCStateInit();
            DBG_ERROR("ARCDeviceState: "+ARCDeviceState);

            var DTSorDBX = tv ? model.sound.getSoundEffectType() : 1;
            DBG_INFO("(getSoundEffectSupportType)DTSorDBX:AfterNeedsFix:" + DTSorDBX);
            if (DTSorDBX == 0) {
                DBG_INFO("(DTSorDBX == 0) Enter DTS modify....");
                if (ARCDeviceState == AudioModeSettingsDTS.PageData.ARCDeviceWorkingState.Working) {
                    for(var i=0;i<AudioModeSettingsDTS.PageData.DisableMenuNameARC.length;i++){
                        if(AudioModeSettingsDTS.currFocus.name == AudioModeSettingsDTS.PageData.DisableMenuNameARC[i]){
//                        if(AudioModeSettingsDTS.currFocus.name!=SpeakersMenu.name){
                            setting.onNormal(AudioModeSettingsDTS.currFocus);
//                        }
                            DisableFocusFlag=true;
                            break;
                        }
                    }
                    sndModeMenu.disable = true;
                    BassBoostMenu.disable = true;
                    SurroundSoundMenu.disable = true;
                    DialogClarityMenu.disable = true;
                    wallMountMenu.disable = true;

                    sndModeMenu.alpha = 0.3;
                    BassBoostMenu.alpha = 0.3;
                    SurroundSoundMenu.alpha = 0.3;
                    DialogClarityMenu.alpha = 0.3;
                    wallMountMenu.alpha = 0.3;
                    if(DisableFocusFlag){
//                    if(AudioModeSettingsDTS.currFocus.name!=SpeakersMenu.name){
                        setting.currFocus=AudioModeSettingsDTS.currFocus = SpeakersMenu;
                        setting.onFocus(AudioModeSettingsDTS.currFocus);
//                    }
                    }
                }
                else {
                    sndModeMenu.disable = false;
                    BassBoostMenu.disable = false;
                    SurroundSoundMenu.disable = false;
                    DialogClarityMenu.disable = false;
                    wallMountMenu.disable = false;

                    sndModeMenu.alpha = 1;
                    BassBoostMenu.alpha = 1;
                    SurroundSoundMenu.alpha = 1;
                    DialogClarityMenu.alpha = 1;
                    wallMountMenu.alpha = 1;
                }
            }

        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }

    };*/
    function initSwitchData(submodule, groupname, pic_switch) {//todo
        try {
            var switchBar = UI.getItem(submodule, groupname);
            var switchComp = UI.getItem(switchBar, pic_switch);
            switch (groupname) {
                case "BassBoostMenu":
                    var tmpData = tv?model.sound.getDTSBassBoost():1;
                    DBG_INFO("model.sound.getDTSBassBoost():" + tmpData);
                    switchComp.setSwitch(tmpData);
                    break;
                case "SurroundSoundMenu":
                    var tmpData = tv?model.sound.getDTSSurroundSound():1;
                    DBG_INFO("model.sound.getDTSSurroundSound():" + tmpData);
                    switchComp.setSwitch(tmpData);
                    break;
                case "DialogClarityMenu":
                    var tmpData = tv?model.sound.getDTSDialogClarify():1;
                    DBG_INFO("model.sound.getDTSDialogClarify():" + tmpData);
                    switchComp.setSwitch(tmpData);
                    break;
                case "wallMountMenu":
                    var tmpData = tv ? model.sound.getWallMode() : 0;
                    DBG_INFO("model.sound.getWallMode():" + tmpData);
                    switchComp.setSwitch(tmpData);
                    break;
                default:
                    break;

            }
            UI.updateStage();

        } catch (ex) {
            DBG_ERROR(ex.message)
        }
    }

    setSndPanel.onShow = function () {
        if(UI.isExistModule('launcher')){
            UI.hideModule(launcher);
        }
        UI.getItem(setting, 'mainPanel').alpha = 0;
        AudioModeSettingsDTS.alpha = 1;
        try {
            //todo init
            initSpeakerandHeadphone();
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    };

    setSndPanel.onPush = function () {
        ModelNotifyInit();
        setSndPanel.currFocus = BassBoostMenu;
        initSwitchData(audioRightGrp, "BassBoostMenu", "BassBoostSwitchImg");
        initSwitchData(audioRightGrp, "SurroundSoundMenu", "SurroundSoundSwitchImg");
        initSwitchData(audioRightGrp, "DialogClarityMenu", "DialogClaritySwitchImg");

        initSwitchData(audioRightGrp, "wallMountMenu", "wallMountSwitchImg");
        getARCStateInit();


    };



    function ModelNotifyInit() {
        try {
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_SPEAKER, SpeakerArcChaged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_BASS_BOOST, DTSBassBoostChaged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_SURROUND_SOUND, SurroundSoundChaged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_DIALOG_CLARIFY, DialogClarifyChanged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_WALL_MODE, WallModeChaged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.HEADPHONE_DEVICE_INSERT, HeadphoneChanged);

        }
        catch (ex) {
            DBG_ERROR(ex.message)
        }
    }
    function UnModelNotifyInit() {
        try {
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_SPEAKER, SpeakerArcChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_BASS_BOOST, DTSBassBoostChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_SURROUND_SOUND, SurroundSoundChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_DIALOG_CLARIFY, DialogClarifyChanged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_WALL_MODE, WallModeChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.HEADPHONE_DEVICE_INSERT, HeadphoneChanged);

        }
        catch (ex) {
            DBG_ERROR(ex.message)
        }
    }

    function initSpeakerandHeadphone() {
        try {
            DBG_INFO("initSpeakerandHeadphone");
            var speakerArc = tv ? model.sound.getSpeakerArc() : 1;
            DBG_INFO("model.sound.getSpeakerArc():" + speakerArc);
            SpeakerArcChaged(speakerArc);
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function SpeakerArcChaged(val) {
        DBG_INFO("SpeakerArcChaged");
        var headphoneInsert = tv ? model.sound.getHeadphoneInsert() : 1;
        DBG_INFO("model.sound.getHeadphoneInsert()" + headphoneInsert);
        AudioModeSettingsDTS.PageData.headphoneInsert = headphoneInsert;

        if (val != 1 && AudioModeSettingsDTS.PageData.headphoneInsert == 0) {
            DBG_INFO("val != 1 && AudioModeSettingsDTS.PageData.headphoneInsert == 0");
            UI.popSubModule();
            var caller = UI.getSubModule("AudioMainPanel");
            if (!caller) {
                UI.pushSubModule("setting", "AudioMainPanel", true);
            }
        } else if (val != 1 && AudioModeSettingsDTS.PageData.headphoneInsert == 1){
            DBG_INFO(val != 1 && AudioModeSettingsDTS.PageData.headphoneInsert == 1);
            var DisableFocusFlag = false;
            for(var i = 0; i < AudioModeSettingsDTS.PageData.DisableMenuNameARC.length; i++) {
                if (AudioModeSettingsDTS.currFocus.name == AudioModeSettingsDTS.PageData.DisableMenuNameARC[i]) {
                    setting.onNormal(AudioModeSettingsDTS.currFocus);
                    DisableFocusFlag = true;
                    break;
                }
            }
            BassBoostMenu.disable = true;
            SurroundSoundMenu.disable = true;
            DialogClarityMenu.disable = true;
            BassBoostMenu.alpha = 0.3;
            SurroundSoundMenu.alpha = 0.3;
            DialogClarityMenu.alpha = 0.3;
            if (DisableFocusFlag) {
                setting.currFocus = AudioModeSettingsDTS.currFocus = equalizerMenu;
                setting.onFocus(AudioModeSettingsDTS.currFocus);
            }
        } else {
            BassBoostMenu.disable = false;
            SurroundSoundMenu.disable = false;
            DialogClarityMenu.disable = false;
            BassBoostMenu.alpha = 1;
            SurroundSoundMenu.alpha = 1;
            DialogClarityMenu.alpha = 1;
        }
    }

    function HeadphoneChanged(val) {
        try {
            DBG_INFO("HeadphoneChanged" + val);
            var speakerArc = tv ? model.sound.getSpeakerArc() : 0;
            DBG_INFO("model.sound.getSpeakerArc():" + speakerArc);
            AudioModeSettingsDTS.PageData.headphoneInsert = val;
            if (speakerArc != 1 && AudioModeSettingsDTS.PageData.headphoneInsert == 0) {
                DBG_INFO("val != 1 && AudioModeSettingsDTS.PageData.headphoneInsert == 0");
                UI.popSubModule();
                var caller = UI.getSubModule("AudioMainPanel");
                if (!caller) {
                    UI.pushSubModule("setting", "AudioMainPanel", true);
                }
            } else if (speakerArc != 1 && AudioModeSettingsDTS.PageData.headphoneInsert == 1){
                DBG_INFO(speakerArc != 1 && AudioModeSettingsDTS.PageData.headphoneInsert == 1);
                var DisableFocusFlag = false;
                for(var i = 0; i < AudioModeSettingsDTS.PageData.DisableMenuNameARC.length; i++) {
                    if (AudioModeSettingsDTS.currFocus.name == AudioModeSettingsDTS.PageData.DisableMenuNameARC[i]) {
                        setting.onNormal(AudioModeSettingsDTS.currFocus);
                        DisableFocusFlag = true;
                        break;
                    }
                }
                BassBoostMenu.disable = true;
                SurroundSoundMenu.disable = true;
                DialogClarityMenu.disable = true;
                BassBoostMenu.alpha = 0.3;
                SurroundSoundMenu.alpha = 0.3;
                DialogClarityMenu.alpha = 0.3;
                if (DisableFocusFlag) {
                    setting.currFocus = AudioModeSettingsDTS.currFocus = equalizerMenu;
                    setting.onFocus(AudioModeSettingsDTS.currFocus);
                }
            } else {
                BassBoostMenu.disable = false;
                SurroundSoundMenu.disable = false;
                DialogClarityMenu.disable = false;
                BassBoostMenu.alpha = 1;
                SurroundSoundMenu.alpha = 1;
                DialogClarityMenu.alpha = 1;
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function DTSBassBoostChaged(val) {
        DBG_INFO("DTSBassBoostChaged:"+val);
        var BassBoostSwitchImg = UI.getItem(AudioModeSettingsDTS, "BassBoostSwitchImg");
        BassBoostSwitchImg.setSwitch(val);
    }
    function SurroundSoundChaged(val){
        try{
            DBG_INFO("SurroundSoundChaged:"+val);
            var SurroundSoundSwitchImg = UI.getItem(AudioModeSettingsDTS,"SurroundSoundSwitchImg");
            SurroundSoundSwitchImg.setSwitch(val);
        }
        catch (ex){
            DBG_ERROR(ex.message)
        }
    }
    function DialogClarifyChanged(val) {
        DBG_INFO("DialogClarifyChanged:"+val);
        var DialogClaritySwitchImg = UI.getItem(AudioModeSettingsDTS, "DialogClaritySwitchImg");
        DialogClaritySwitchImg.setSwitch(val);
    }


    function WallModeChaged(val){
        try{
            DBG_INFO("WallModeChaged:"+val);
            var wallMountSwitchImg = UI.getItem(AudioModeSettingsDTS, "wallMountSwitchImg");
            wallMountSwitchImg.setSwitch(val);
        }
        catch (ex){
            DBG_ERROR(ex.message)
        }
    }

    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CEC_DEVICE_EXIST_CHANGED, onArcDeviceExistChaged);

    var audioLeftGrp = UI.getItem(AudioModeSettingsDTS, "audioLeftGrp");
    var audioHelpInfo = UI.getItem(AudioModeSettingsDTS, "audioHelpInfo");
    var resetMenu = UI.getItem(audioRightGrp, "resetMenu");

    var audioInfoGrp = UI.getItem(AudioModeSettingsDTS, "audioLeftGrp");
    var audiotitle1 = UI.getItem(audioInfoGrp, "audiotitle1");


    switchBar_common(audioRightGrp, "BassBoostMenu",  "BassBoostSwitchImg");
    switchBar_common(audioRightGrp, "SurroundSoundMenu", "SurroundSoundSwitchImg");
    switchBar_common(audioRightGrp, "DialogClarityMenu","DialogClaritySwitchImg");

    switchBar_common(audioRightGrp, "wallMountMenu", "wallMountSwitchImg");


    function sndMainPageHelpInfo(id) {
        UI.setText(audioHelpInfo, AudioModeSettingsDTS.PageData.sndHelpInfo[id].info);
    }
    function switchBar_common(submodule, groupname, pic_switch_name) {
        try {
            var switchBar = UI.getItem(submodule, groupname);
            var switchComp = UI.getItem(switchBar, pic_switch_name);
            Switch.create(switchComp, true);
            UI.updateStage();
            switchBar.onFocus = function () {
                switchComp.onFocus();
                sndMainPageHelpInfo(groupname);
                return true;
            };
            switchBar.onkey_ENTER = function () {
                switchMove();
            };
            switchBar.onkey_LEFT = function () {
                switchMove();
            };
            switchBar.onkey_RIGHT = function () {
                switchMove();
            };
            function switchMove() {
                try {
                    switchComp.switch();
                    UI.updateStage();
                    var type = switchComp.flag == false ? 0 : 1;
                    DBG_INFO("type:" + type);
                    switch(groupname){
                        case "BassBoostMenu":
                            DBG_INFO("model.sound.setDTSBassBoost:" + type);
                            tv && model.sound.setDTSBassBoost(type);
                            break;
                        case "SurroundSoundMenu":
                            DBG_INFO("model.sound.setDTSSurroundSound:" + type);
                            tv && model.sound.setDTSSurroundSound(type);
                            break;
                        case "DialogClarityMenu":
                            DBG_INFO("model.sound.setDTSDialogClarify:" + type);
                            tv && model.sound.setDTSDialogClarify(type);
                            break;
                        case "wallMountMenu":
                            DBG_INFO("model.sound.setWallMode:" + type);
                            tv && model.sound.setWallMode(type);
                            break;
                        default:
                            break;
                    }
                }
                catch (ex) {
                    DBG_ERROR(ex.message);
                }
            }
        }
        catch (e) {
            DBG_ERROR("Switchbar_common func is error");
        }
    }

    equalizerMenu.onFocus = function () {
        sndMainPageHelpInfo("equalizerMenu");
        return true;
    };
    equalizerMenu.onkey_ENTER = function () {
        AudioModeSettingsDTS.alpha = 0;
        UI.pushSubModule("setting", "AudioEqualizer", true);
    };

    /*AudioModeSettingsDTS.onkey_BACKSPACE= function() {
        UI.popSubModule();
        var caller = UI.getSubModule("AudioMainPanel");
        if (!caller) {
            UI.pushSubModule("setting", "AudioMainPanel", true);
        }
    };*/

    AudioModeSettingsDTS.onPop = function () {
        UnModelNotifyInit();
    }
};
