/**
 * Created by Hisense on 2016-1-5.
 */
// Init
UI.moduleBuilder['setting']['AudioModeSettingsDBX'] = function(){

    var initData = {
        audioSheetImg: UI["setting_bg"],
        audioImg1: "setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_audio_154x154.png",
        sndModeImg1: UI.btn_normal_bg,
        audiotitle1: "[SE0058]",//Sound
        
        DBXSonicTitle: "setting/snd/dbx_total_sonic.png",//Total Sonics
        DBXSurrTitle: "setting/snd/dbx_total_surround.png",//Total Surround
        DBXVolumeTitle: "setting/snd/dbx_total_volume.png",//Total Volume
        equalizerTitle: "[SE0074]",//Equalizer
        wallMountTitle: "[SE2936]"//Wall Mount Setup
       
    };
    var template = Util.readJson("module/setting/AudioModeSettingsDBX.json");
    var setSndPanel = SubModule.create(initData, template);
    var AudioModeSettingsDBX = UI.getSubModule("AudioModeSettingsDBX");
    var audioRightGrp = UI.getItem(setSndPanel, "audioRightGrp");
    UI.addMask(audioRightGrp, 1242, 926, 50, 6);
    UI.setView(audioRightGrp, 1242, 926);

    var DBXSonicMenu = UI.getItem(AudioModeSettingsDBX, "DBXSonicMenu");
    var DBXSurrMenu = UI.getItem(AudioModeSettingsDBX, "DBXSurrMenu");
    var DBXVolumeMenu = UI.getItem(AudioModeSettingsDBX, "DBXVolumeMenu");
    var equalizerMenu = UI.getItem(AudioModeSettingsDBX, "equalizerMenu");

    AudioModeSettingsDBX.PageData = {
        "DBXTotalVolume": ["[SE0549]", "[SE0550]", "[GE0006]"],//Normal Mode,Night Mode,Off
        sndHelpInfo: {
            DBXSonicMenu: {
                title: "Total Sonics",
                info: "[SE2840]"//"Optimizes overall sound quality by increasing bass, making dialog clear and natural, and widening the sound field."
            },
            DBXSurrMenu: {
                title: "Total Surround",
                info: "[SE2842]" //"Provides surround sound experience with psycho-acoustic processing to place sounds beside, behind, and above the viewer. For best results use with Total Sonics."
            },
            DBXVolumeMenu: {
                title: "Total Volume",
                info: "[SE2841]"//"Maintains consistent loudness levels from wide dynamic range programs, too-loud commercials, and channel or input changes."
            },
            equalizerMenu: {
                title: "Equalizer",
                info: "[SE0564]"//"Boost the volume at different frequencies."
            },
            wallMountMenu: {
                title: "Wall Mount Setup",
                info: "[SE2937]"//"Automatically optimize the sound based on the position of the TV."
            }
        },
        ARCDeviceWorkingState: {
            Working: 1,
            RestIng: 0
        },
        DisableMenuNameARC:["sndModeMenu","BassBoostMenu","SurroundSoundMenu","DialogClarityMenu","wallMountMenu","DBXSonicMenu","DBXSurrMenu","DBXVolumeMenu"],
        DBXArray:[0, 0, 0] //DBXSonic 0 1, DBXSurr 0 1, DBXVolume 0 1 2
    };


    function initTotalVolume() {
        try {
            var DBXVec = tv ? createArray(model.sound.getTotalSonics()) : [1, 0, 1];
            DBG_INFO("model.sound.getSoundDBX()" + objToString(DBXVec));
            AudioModeSettingsDBX.PageData.DBXArray = DBXVec;
            var DBXVolume = DBXVec[2];
            DBG_INFO("DBXVec[2]:DBXVolume:" + DBXVec[2]);
            var CurrDBXVolume = UI.getItem(AudioModeSettingsDBX, "CurrDBXVolume");
            CurrDBXVolume.selectCurrent(DBXVolume);
        } catch (ex) {
            DBG_INFO(ex.message);
        }
    }
    /*AudioModeSettingsDBX.DisableSoundByARCOn = function () {
        try {
            var BassBoostMenu = UI.getItem(AudioModeSettingsDBX, "BassBoostMenu");
            var SurroundSoundMenu = UI.getItem(AudioModeSettingsDBX, "SurroundSoundMenu");
            var DialogClarityMenu = UI.getItem(AudioModeSettingsDBX, "DialogClarityMenu");
            var wallMountMenu = UI.getItem(AudioModeSettingsDBX, "wallMountMenu");
            var SpeakersMenu = UI.getItem(AudioModeSettingsDBX, "SpeakersMenu");
            var DisableFocusFlag = false;
            getARCStateInit();
            DBG_ERROR("ARCDeviceState: "+ARCDeviceState);

            var DTSorDBX = tv ? model.sound.getSoundEffectType() : 1;
            DBG_INFO("(getSoundEffectSupportType)DTSorDBX:AfterNeedsFix:" + DTSorDBX);
            if (DTSorDBX == 0) {
                DBG_INFO("(DTSorDBX == 0) Enter DTS modify....");
                if (ARCDeviceState == AudioModeSettingsDBX.PageData.ARCDeviceWorkingState.Working) {
                    for(var i=0;i<AudioModeSettingsDBX.PageData.DisableMenuNameARC.length;i++){
                        if(AudioModeSettingsDBX.currFocus.name == AudioModeSettingsDBX.PageData.DisableMenuNameARC[i]){
//                        if(AudioModeSettingsDBX.currFocus.name!=SpeakersMenu.name){
                            setting.onNormal(AudioModeSettingsDBX.currFocus);
//                        }
                            DisableFocusFlag=true;
                            break;
                        }
                    }
                    sndModeMenu.disable = true;
                    BassBoostMenu.disable = true;
                    SurroundSoundMenu.disable = true;
                    DialogClarityMenu.disable = true;
                    wallMountMenu.disable = true;

                    sndModeMenu.alpha = 0.3;
                    BassBoostMenu.alpha = 0.3;
                    SurroundSoundMenu.alpha = 0.3;
                    DialogClarityMenu.alpha = 0.3;
                    wallMountMenu.alpha = 0.3;
                    if(DisableFocusFlag){
//                    if(AudioModeSettingsDBX.currFocus.name!=SpeakersMenu.name){
                        setting.currFocus=AudioModeSettingsDBX.currFocus = SpeakersMenu;
                        setting.onFocus(AudioModeSettingsDBX.currFocus);
//                    }
                    }
                }
                else {
                    sndModeMenu.disable = false;
                    BassBoostMenu.disable = false;
                    SurroundSoundMenu.disable = false;
                    DialogClarityMenu.disable = false;
                    wallMountMenu.disable = false;

                    sndModeMenu.alpha = 1;
                    BassBoostMenu.alpha = 1;
                    SurroundSoundMenu.alpha = 1;
                    DialogClarityMenu.alpha = 1;
                    wallMountMenu.alpha = 1;
                }
            }

        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }

    };*/
    function initSwitchData(submodule, groupname, pic_switch) {//todo
        try {
            var switchBar = UI.getItem(submodule, groupname);
            var switchComp = UI.getItem(switchBar, pic_switch);
            switch (groupname) {
                case "DBXSonicMenu":
                    var DBXVec = tv ? createArray(model.sound.getTotalSonics()) : [1, 0, 1];
                    DBG_INFO("model.sound.getSoundDBX()" + objToString(DBXVec));
                    AudioModeSettingsDBX.PageData.DBXArray = DBXVec;
                    var DBXSonic = DBXVec[1];
                    DBG_INFO("DBXVec[1]:DBXSonic:" + DBXVec[1]);
                    switchComp.setSwitch(DBXSonic);
                    break;
                case "DBXSurrMenu":
                    var DBXVec = tv ? createArray(model.sound.getTotalSonics()) : [1, 0, 1];
                    DBG_INFO("model.sound.getSoundDBX()" + objToString(DBXVec));
                    AudioModeSettingsDBX.PageData.DBXArray = DBXVec;
                    var DBXSurr = DBXVec[0];
                    DBG_INFO("DBXVec[0]:DBXSurr:" + DBXVec[0]);
                    switchComp.setSwitch(DBXSurr);
                    break;
                case "wallMountMenu":
                    var tmpData = tv ? model.sound.getWallMode() : 0;
                    DBG_INFO("model.sound.getWallMode():" + tmpData);
                    switchComp.setSwitch(tmpData);
                    break;
                default:
                    break;

            }
            UI.updateStage();

        } catch (ex) {
            DBG_ERROR(ex.message)
        }
    }

    setSndPanel.onShow = function () {
        if(UI.isExistModule('launcher')){
            UI.hideModule(launcher);
        }
        UI.getItem(setting, 'mainPanel').alpha = 0;
        AudioModeSettingsDBX.alpha = 1;
        try {

            initTotalVolume();
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    };

    var DBXVolumeMenu = UI.getItem(AudioModeSettingsDBX,"DBXVolumeMenu");
    var DBXSonicMenu = UI.getItem(AudioModeSettingsDBX, "DBXSonicMenu");
    var DBXSurrMenu = UI.getItem(AudioModeSettingsDBX, "DBXSurrMenu");
    setSndPanel.onPush = function () {
        ModelNotifyInit();
        setSndPanel.currFocus = DBXSonicMenu;
        initSwitchData(audioRightGrp, "DBXSonicMenu", "DBXSoncicSwitchImg");
        initSwitchData(audioRightGrp, "DBXSurrMenu", "DBXSurrSwitchImg");
        initSwitchData(audioRightGrp, "wallMountMenu", "wallMountSwitchImg");
        getARCStateInit();
        //AudioModeSettingsDBX.DisableSoundByARCOn();

    };

    function ModelNotifyInit() {
        try {

            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_WALL_MODE, WallModeChaged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_DBX, DBXChaged);

//            model.sound.onSpeakerArcChaged = speakersChaged;
//            model.sound.onDTSBassBoostChanged = DTSBassBoostChaged;
//            model.sound.onDTSSurroundSoundChanged = SurroundSoundChaged;
//            model.sound.onDTSDialogClarifyChanged = DialogClarifyChanged;
//            model.sound.onWallModeChaged = WallModeChaged;

        }
        catch (ex) {
            DBG_ERROR(ex.message)
        }
    }
    function UnModelNotifyInit() {
        try {

            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_WALL_MODE, WallModeChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_DBX, DBXChaged);
        }
        catch (ex) {
            DBG_ERROR(ex.message)
        }
    }


    function DBXChaged(vec) {
        DBG_INFO("DBXChaged : " + vec);
        try {

            //DBXSonicMenu
            var switchBarSonic = UI.getItem(audioRightGrp, "DBXSonicMenu");
            var switchCompSonic = UI.getItem(switchBarSonic, "DBXSoncicSwitchImg");
            AudioModeSettingsDBX.PageData.DBXArray = vec;
            var DBXSonic = vec[1];
            DBG_INFO("DBXVec[1]:DBXSonic:" + vec[1]);
            switchCompSonic.setSwitch(DBXSonic);

            //DBXSurrMenu
            var switchBarSurr = UI.getItem(audioRightGrp, "DBXSurrMenu");
            var switchCompSurr = UI.getItem(switchBarSurr, "DBXSurrSwitchImg");
            var DBXSurr = vec[0];
            DBG_INFO("DBXVec[0]:DBXSurr:" + vec[0]);
            switchCompSurr.setSwitch(DBXSurr);

            //DBXVolumeMenu
            var DBXVolume = vec[2];
            DBG_INFO("DBXVec[2]:DBXVolume:" + vec[2]);
            var CurrDBXVolume = UI.getItem(AudioModeSettingsDBX, "CurrDBXVolume");
            CurrDBXVolume.selectCurrent(DBXVolume);

        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }


    function WallModeChaged(val){
        try{
            DBG_INFO("WallModeChaged:"+val);
            var wallMountSwitchImg = UI.getItem(AudioModeSettingsDBX, "wallMountSwitchImg");
            wallMountSwitchImg.setSwitch(val);
        }
        catch (ex){
            DBG_ERROR(ex.message)
        }
    }

    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CEC_DEVICE_EXIST_CHANGED, onArcDeviceExistChaged);

    var audioLeftGrp = UI.getItem(AudioModeSettingsDBX, "audioLeftGrp");
    var audioHelpInfo = UI.getItem(AudioModeSettingsDBX, "audioHelpInfo");

    var audioInfoGrp = UI.getItem(AudioModeSettingsDBX, "audioLeftGrp");
    var audiotitle1 = UI.getItem(audioInfoGrp, "audiotitle1");


    switchBar_common(audioRightGrp, "DBXSonicMenu", "DBXSoncicSwitchImg");
    switchBar_common(audioRightGrp, "DBXSurrMenu", "DBXSurrSwitchImg");
    selectBar_common(audioRightGrp, "DBXVolumeMenu","CurrDBXVolume", AudioModeSettingsDBX.PageData.DBXTotalVolume, "AudioDBXTotalVolumeList");

    switchBar_common(audioRightGrp, "wallMountMenu", "wallMountSwitchImg");


    function sndMainPageHelpInfo(id) {
        UI.setText(audioHelpInfo, AudioModeSettingsDBX.PageData.sndHelpInfo[id].info);
    }
    function switchBar_common(submodule, groupname, pic_switch_name) {
        try {
            var switchBar = UI.getItem(submodule, groupname);
            var switchComp = UI.getItem(switchBar, pic_switch_name);
            Switch.create(switchComp, true);
            UI.updateStage();
            switchBar.onFocus = function () {
                switchComp.onFocus();
                sndMainPageHelpInfo(groupname);
                return true;
            };
            switchBar.onkey_ENTER = function () {
                switchMove();
            };
            switchBar.onkey_LEFT = function () {
                switchMove();
            };
            switchBar.onkey_RIGHT = function () {
                switchMove();
            };
            function switchMove() {
                try {
                    switchComp.switch();
                    UI.updateStage();
                    var type = switchComp.flag == false ? 0 : 1;
                    DBG_INFO("type:" + type);
                    switch(groupname){
                        case "wallMountMenu":
                            DBG_INFO("model.sound.setWallMode:" + type);
                            tv && model.sound.setWallMode(type);
                            break;
                        case "DBXSonicMenu":
                            AudioModeSettingsDBX.PageData.DBXArray[1] = type;
                            DBG_INFO("model.sound.setSoundDBX : " + AudioModeSettingsDBX.PageData.DBXArray);
                            DBG_INFO("DBXSonic : " + AudioModeSettingsDBX.PageData.DBXArray[1]);
                            tv && model.sound.setTotalSonics(createIntergerVector(AudioModeSettingsDBX.PageData.DBXArray));
                            break;
                        case "DBXSurrMenu":
                            AudioModeSettingsDBX.PageData.DBXArray[0] = type;
                            DBG_INFO("model.sound.setSoundDBX : " + AudioModeSettingsDBX.PageData.DBXArray);
                            DBG_INFO("DBXSurr : " + AudioModeSettingsDBX.PageData.DBXArray[0]);
                            tv && model.sound.setTotalSonics(createIntergerVector(AudioModeSettingsDBX.PageData.DBXArray));
                            break;
                        default:
                            break;
                    }
                }
                catch (ex) {
                    DBG_ERROR(ex.message);
                }
            }
        }
        catch (e) {
            DBG_ERROR("Switchbar_common func is error");
        }
    }
    function selectBar_common(submodule, group_name, select_txt, item_value_arrary,title) {
        try {
            var selectBar = UI.getItem(submodule, group_name);
            var selectComp = UI.getItem(selectBar, select_txt);
            Select.create(selectComp, item_value_arrary);

            selectBar.onFocus = function () {
                var index = item_value_arrary.indexOf(selectComp.selected);
                if(index==1){
                    UI.setVoiceStr(selectBar, "[SE3250]"+" A:R:C");
                }else{
                    UI.setVoiceStr(selectBar, "[SE3250] "+ selectComp.selected);
                }
                UI.updateStage();
                sndMainPageHelpInfo(group_name);
                return true;
            };
            selectBar.onkey_RIGHT = function () {
                selectComp.selectNext();
                UI.updateStage();
                var index = item_value_arrary.indexOf(selectComp.selected);
                if(index==1){
                    UI.setVoiceStr(selectComp, "A:R:C");
                }
                selectBarMoveHandler(group_name, index);
            };
            selectBar.onkey_LEFT = function () {
                selectComp.selectPrev();
                UI.updateStage();
                var index = item_value_arrary.indexOf(selectComp.selected);
                if(index==1){
                    UI.setVoiceStr(selectComp, "A:R:C");
                }
                selectBarMoveHandler(group_name, index);
            };
            selectBar.onkey_ENTER = function () {
                if(group_name == "DBXVolumeMenu" ){
                    UI.pushSubModule("setting", "AudioDBXTotalVolumeList", true);
                } else if (group_name == "SpeakersMenu") {
                    var SpeakersList = [];
                    SpeakersList.push({
                        listArray: item_value_arrary,
                        index: item_value_arrary.indexOf(selectComp.selected),
                        groupName: group_name,
                        Title:initData[title]
                    });
                    UI.pushSubModule("setting", "AudioSpeakersList", true, SpeakersList);
                }

            }
        }
        catch (e) {
            DBG_ERROR("Selectbar_common func is error");
        }
    }

    function selectBarMoveHandler(group_name, index) {
        var speakers = index+1;
        switch (group_name) {
            case "SpeakersMenu":
                DBG_INFO("model.sound.setSpeakerArc:" +speakers);
                tv ? model.sound.setSpeakerArc(speakers) : true;
                AudioModeSettingsDBX.DisableSoundByARCOn();
                break;
            case "DBXVolumeMenu":
                AudioModeSettingsDBX.PageData.DBXArray[2] = index;
                DBG_INFO("model.sound.setSoundDBX : " + AudioModeSettingsDBX.PageData.DBXArray);
                DBG_INFO("DBXVolume : " + AudioModeSettingsDBX.PageData.DBXArray[2]);
                tv && model.sound.setTotalSonics(createIntergerVector(AudioModeSettingsDBX.PageData.DBXArray));
                break;
            default:
                break;


        }
    }

    equalizerMenu.onFocus = function () {
        sndMainPageHelpInfo("equalizerMenu");
        return true;
    };
    equalizerMenu.onkey_ENTER = function () {
        AudioModeSettingsDBX.alpha = 0;
        UI.pushSubModule("setting", "AudioEqualizer", true);
    };

    AudioModeSettingsDBX.onPop = function () {
        UnModelNotifyInit();
    }
};
