/**
 * Created by Hisense on 2016-4-29.
 */
UI.moduleBuilder['setting']['AudioHeadphoneModeList'] = function(){

    var initData = {
        AudioBg: UI['bg_overlay'],
        AudioListBg: UI.window_bg,
        AudioHeadphoneModeTitle:"[SE2691]"//Headphone Mode

    };
    var template = Util.readJson("module/setting/AudioHeadphoneModeList.json");
    var AudioHeadphoneModeList = SubModule.create(initData, template);
    AudioHeadphoneModeList.operateData = {
        "AudioHeadphoneModeList": [
            {
                "map": 0,
                "name": "[OT0434]",//SE2692 : "Headphone with TV Speaker"//Headphone with Speakers
                "flag": false
            },
            {
                "map": 1,
                "name": "[SE2693]",//SE2693 : "Headphone Only"
                "flag": false
            }
        ],
        "currHphoneIdx": 0
    };
    function SndgetHphoneModeIdx() {
        try {

            var HphoneModeTmp = tv ? model.sound.getHeadphoneMode() : 1;
            DBG_INFO("model.sound.getHeadphoneMode=" + HphoneModeTmp);
            for (var i = 0; i < AudioHeadphoneModeList.operateData.AudioHeadphoneModeList.length; i++) {
                if (HphoneModeTmp == AudioHeadphoneModeList.operateData.AudioHeadphoneModeList[i].map) {
                    break;
                }
            }
            return i;

        } catch (ex) {
            DBG_ERROR("SndgetHphoneModeIdx:" + ex.message);
        }
    }

    // 初始化Grid控件
    // 取得目标锚点
    var List = UI.getItem(AudioHeadphoneModeList, "List");

    // Grid的配置信息JSON
    var info = {
        // 每个图标使用的模板名
        template: "DialogListItem",
        // V表示竖向排列，H表示横向排列
        direction: CONST.GIRD_DIRECTION.H,
        // 每隔几个图标就换行
        breakNum: 1,
        // 每隔图标之间的距离
        distanceX: 0,
        distanceY: 20,
        // 要将此Grid添加到哪个锚点位置上
        container: List
    };

    // 声明一个初始化用数组，将数据配置好
    var allArray = [];
    for (var i = 0; i < AudioHeadphoneModeList.operateData.AudioHeadphoneModeList.length; i++) {
        allArray.push(
            {
                ItemName: AudioHeadphoneModeList.operateData.AudioHeadphoneModeList[i].name,
                tileBg: UI.item_bg,
                name: "item" + i,
                isFlag: "setting/ic_radiobutton_normal.png"
            }
        )
    }
    // 调用Grid.create方法生成Gird并添加到锚点位置上
    Gird.create(allArray, info);
    // 设置视野范围，当焦点超出此范围时，整个Grid会反向移动，达到滚动效果（此处配置的x，y是全局坐标）

    // 设置遮罩范围，隐藏显示不下的图标
    AudioHeadphoneModeList.operateData.currHphoneIdx = SndgetHphoneModeIdx();
    AudioHeadphoneModeList.currFocus = UI.getItem(List, "item" + AudioHeadphoneModeList.operateData.currHphoneIdx);
    AudioHeadphoneModeList.onShow = function () {
        AudioHeadphoneModeList.operateData.currHphoneIdx = SndgetHphoneModeIdx();
        DBG_INFO("setAudioHeadphoneModeList.onShow");
        for (var i = 0; i < List.initSequence.length; i++) {
            UI.setImage(List.children[i].children[2], "setting/ic_radiobutton_normal.png",List.children[i]);
        }
        AudioHeadphoneModeList.currFocus = UI.getItem(List, "item" + AudioHeadphoneModeList.operateData.currHphoneIdx);
        UI.setImage(AudioHeadphoneModeList.currFocus.children[2], OEMFunction.getInstance().getBrandSelectFocusImage(),AudioHeadphoneModeList.currFocus);
        UI.focusTo(UI.getItem(List, "item" + AudioHeadphoneModeList.operateData.currHphoneIdx));
    };

    function SndSetCurrHphoneModeIdx(idx) {
        try {
            AudioHeadphoneModeList.operateData.currHphoneIdx = idx;

            var HphoneModeList = AudioHeadphoneModeList.operateData.AudioHeadphoneModeList;
            if (idx > HphoneModeList.length - 1) {
                DBG_ERROR("SndSetCurrHphoneModeIdx:idx=" + idx);
                idx = 0;
            }
            DBG_INFO("model.sound.setHeadphoneMode:"+HphoneModeList[idx].map);
            tv? model.sound.setHeadphoneMode(HphoneModeList[idx].map) :1;

        } catch (ex) {
            DBG_ERROR("SndSetCurrHphoneModeIdx:" + ex.message);
        }

    }

    List.onkey_ENTER = function (focus) {
        var index = List.initSequence.indexOf(focus);//AudioHeadphoneModeList.currFocus.name.slice(-1);
        for (var i = 0; i < List.initSequence.length; i++) {
            UI.setImage(List.children[i].children[2], "setting/ic_radiobutton_normal.png");
        }
        UI.setImage(AudioHeadphoneModeList.currFocus.children[2], OEMFunction.getInstance().getBrandSelectFocusImage());
        SndSetCurrHphoneModeIdx(index);
        UI.popSubModule();
        return true;
    };

};