// Init
UI.moduleBuilder['setting']['AudioEqualizer'] = function(){

    var AudioEqualizerData = {
        panelBg: UI.window_bg,
        sndModeImg1: UI.item_bg,
        resetBtnImg: UI.item_bg,
        AudioBg: UI['bg_overlay'],
        title: "[SE0074]",//Equalizer
        balanceTitle1: "[SE2389]",//120HZ
        balanceTitle2: "[SE0567]",//500Hz
        balanceTitle3: "[SE0569]",//1.5KHz
        balanceTitle4: "[SE0571]",//5KHz
        balanceTitle5: "[SE0573]",//10KHz
        resetTitle: "[SE1884]"//Reset
    };
    var template = Util.readJson("module/setting/AudioEqualizer.json");
    var AudioEqualizer = SubModule.create(AudioEqualizerData, template);
    var EqualizerGrp = UI.getItem(AudioEqualizer, "EqualizerGrp");
    AudioEqualizer.currFocus = UI.getItem(EqualizerGrp, "Bar100HZ");
    AudioEqualizer.pageData = {};
    AudioEqualizer.onPush = function(){
        ModelSoundInit();
    };
    AudioEqualizer.onShow = function () {
        AudioEqualizer.initEqualizer();

    };
    AudioEqualizer.initEqualizer = function(){
        try {
            var hz100 = tv ? model.sound.getEqualizerFreq120hz() : 10;
            DBG_INFO("model.sound.getEqualizerFreq120hz():" + hz100);
            var Bar100HZ = UI.getItem(EqualizerGrp, "Bar100HZ");
            var bar = UI.getItem(Bar100HZ, "bar");
            bar.setPercent(hz100);
            //Bar100HZ.updateCache();

            var hz500 = tv ? model.sound.getEqualizerFreq500hz() : 9;
            DBG_INFO("model.sound.getEqualizerFreq500hz():" + hz500);
            var Bar500HZ = UI.getItem(EqualizerGrp, "Bar500HZ");
            var bar = UI.getItem(Bar500HZ, "bar");
            bar.setPercent(hz500);
            //Bar500HZ.updateCache();

            var khz15 = tv ? model.sound.getEqualizerFreq1k5hz() : -3;
            DBG_INFO("model.sound.getEqualizerFreq1k5hz():" + khz15);
            var Bar15HZ = UI.getItem(EqualizerGrp, "Bar15HZ");
            var bar = UI.getItem(Bar15HZ, "bar");
            bar.setPercent(khz15);
            //Bar15HZ.updateCache();

            var k5hz = tv ? model.sound.getEqualizerFreq5khz() : -2;
            DBG_INFO("model.sound.getEqualizerFreq5khz():" + k5hz);
            var Bar5KHZ = UI.getItem(EqualizerGrp, "Bar5KHZ");
            var bar = UI.getItem(Bar5KHZ, "bar");
            bar.setPercent(k5hz);

            var k10hz = tv ? model.sound.getEqualizerFreq10khz() : -5;
            DBG_INFO("model.sound.getEqualizerFreq10khz():" + k10hz);
            var Bar10KHZ = UI.getItem(EqualizerGrp, "Bar10KHZ");
            var bar = UI.getItem(Bar10KHZ, "bar");
            bar.setPercent(k10hz);


            UI.updateStage();
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    };

    var resetBtn = UI.getItem(EqualizerGrp, "resetBtn");

    AudioEqualizer.onkey_BACKSPACE = function () {
        //var DTSorDBX = tv ? model.sound.getSoundEffectType() : 0;  //0--DTS  1--DBX
        //if (DTSorDBX == 0) {
            var AudioModeSettingsDTS = UI.getSubModule("AudioModeSettingsDTS");
            AudioModeSettingsDTS.alpha = 1;
            UI.popSubModule();
        //} else {
        //    var AudioModeSettingsDBX = UI.getSubModule("AudioModeSettingsDBX");
        //    AudioModeSettingsDBX.alpha = 1;
        //    UI.popSubModule();
        //}

    };

    resetBtn.onkey_ENTER = function () {
        DBG_INFO("Reset Equalizer");
        //AudioEqualizer.initEqualizer();
        if (!!tv) {
            model.sound.ResetEqualizer();
        }
    };
    function EqualizerResult(actionId, v) {
        DBG_INFO("ResetEqualizerResult:" + v);
        try {
            if (v == 0) {
                AudioEqualizer.initEqualizer();
            }
            else{
                DBG_INFO("ResetEqualizer failed");
            }
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }


    function percentBar_common(submodule, groupname, percentImg, percentTxt, percentTitle, min, max) {
        try {
            var percentBar = UI.getItem(submodule, groupname);
            var percentComp = UI.getItem(percentBar, percentImg);
            var percentTxt = UI.getItem(percentBar, percentTxt);
            var percentTitle = UI.getItem(percentBar, percentTitle);
            Percent.create(percentComp, percentTxt, 0, min, max);
            percentBar.onFocus = function (focus) {
                percentComp.onFocus();
                UI.setTextColor(percentTitle, 0xFFFFFF);
                return true;
            };
            percentBar.onNormal = function (focus) {
                percentComp.onNormal();
                UI.setTextColor(percentTitle, "rgba(255,255,255,.6)");
                return true;
            };
            percentBar.onkey_RIGHT = function () {
//                percentComp.plus();
                //percentBar.updateCache();
                //UI.updateStage();
                setEquValue(groupname, percentComp.percent+1);
            };
            percentBar.onkey_LEFT = function () {
//                percentComp.minus();
                //percentBar.updateCache();
                //UI.updateStage();
                setEquValue(groupname, percentComp.percent-1);
            };
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    percentBar_common(AudioEqualizer, "Bar100HZ", "bar", "value", "balanceTitle1", -10, 10);
    percentBar_common(AudioEqualizer, "Bar500HZ", "bar", "value", "balanceTitle2", -10, 10);
    percentBar_common(AudioEqualizer, "Bar15HZ", "bar", "value", "balanceTitle3", -10, 10);
    percentBar_common(AudioEqualizer, "Bar5KHZ", "bar", "value", "balanceTitle4", -10, 10);
    percentBar_common(AudioEqualizer, "Bar10KHZ", "bar", "value", "balanceTitle5", -10, 10);

    function setEquValue(groupname, val) {
        switch (groupname) {
            case "Bar100HZ":
                DBG_INFO("model.sound.setEqualizerFreq120hz:" + val);
                model.sound.setEqualizerFreq120hz(val);
                break;
            case "Bar500HZ":
                DBG_INFO("model.sound.setEqualizerFreq500hz:" + val);
                model.sound.setEqualizerFreq500hz(val);
                break;
            case "Bar15HZ":
                DBG_INFO("model.sound.setEqualizerFreq1k5hz:" + val);
                model.sound.setEqualizerFreq1k5hz(val);
                break;
            case "Bar5KHZ":
                DBG_INFO("model.sound.setEqualizerFreq5khz:" + val);
                model.sound.setEqualizerFreq5khz(val);
                break;
            case "Bar10KHZ":
                DBG_INFO("model.sound.setEqualizerFreq10khz:" + val);
                model.sound.setEqualizerFreq10khz(val);
                break;

        }
    }


    var Bar120HZ = UI.getItem(AudioEqualizer,"Bar100HZ");
    var Bar500HZ = UI.getItem(AudioEqualizer,"Bar500HZ");
    var Bar15HZ  = UI.getItem(AudioEqualizer,"Bar15HZ");
    var Bar5KHZ  = UI.getItem(AudioEqualizer,"Bar5KHZ");
    var Bar10KHZ = UI.getItem(AudioEqualizer,"Bar10KHZ");

    function onEqualizerFreq120hzChaged(val){
        DBG_INFO("onEqualizerFreq120hzChaged: "+val);
        var bar=UI.getItem(Bar120HZ,"bar");
        bar.setPercentNoVoice(val);
        UI.updateStage();
    }
    function onEqualizerFreq500hzChaged(val){
        DBG_INFO("onEqualizerFreq500hzChaged: "+val);
        var bar=UI.getItem(Bar500HZ,"bar");
        bar.setPercentNoVoice(val);
        UI.updateStage();
    }
    function onEqualizerFreq1k5hzChaged(val){
        DBG_INFO("onEqualizerFreq1k5hzChaged: "+val);
        var bar=UI.getItem(Bar15HZ,"bar");
        bar.setPercentNoVoice(val);
        UI.updateStage();
    }
    function onEqualizerFreq5khzChaged(val){
        DBG_INFO("onEqualizerFreq5khzChaged: "+val);
        var bar=UI.getItem(Bar5KHZ,"bar");
        bar.setPercentNoVoice(val);
        UI.updateStage();
    }
    function onEqualizerFreq10khzChaged(val){
        DBG_INFO("onEqualizerFreq10khzChaged: "+val);
        var bar=UI.getItem(Bar10KHZ,"bar");
        bar.setPercentNoVoice(val);
        UI.updateStage();
    }

    function ModelSoundInit(){
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_EQUA_120HZ, onEqualizerFreq120hzChaged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_EQUA_500HZ, onEqualizerFreq500hzChaged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_EQUA_1500HZ, onEqualizerFreq1k5hzChaged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_EQUA_5000HZ, onEqualizerFreq5khzChaged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_EQUA_10000HZ, onEqualizerFreq10khzChaged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_EQUA_RESET, EqualizerResult);
//        model.sound.ResetEqualizerResult = EqualizerResult;
    }
    function UnModelSoundInit(){
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_EQUA_120HZ, onEqualizerFreq120hzChaged);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_EQUA_500HZ, onEqualizerFreq500hzChaged);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_EQUA_1500HZ, onEqualizerFreq1k5hzChaged);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_EQUA_5000HZ, onEqualizerFreq5khzChaged);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_EQUA_10000HZ, onEqualizerFreq10khzChaged);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_EQUA_RESET, EqualizerResult);
    }

    AudioEqualizer.onPop = function(){
        UnModelSoundInit();
    };

};
