// Init
UI.moduleBuilder['setting']['AudioDBXTotalVolumeList'] = function(){

    var initData = {
        AudioBg: UI['bg_overlay'],
        AudioTotalVolumeListBg: UI.window_bg,
        DBXTotalVolumeTitle:"[SE0547]"//Total Volume
    };
    var template = Util.readJson("module/setting/AudioDBXTotalVolumeList.json");
    var AudioDBXTotalVolumeList = SubModule.create(initData, template);

    AudioDBXTotalVolumeList.operateData = {
        "TotalVolumeList": [
            {
                "map": 2,
                "name": "[GE0006]",//"Off"
                "flag": false
            },
            {
                "map": 0,
                "name": "[SE0549]",//"Normal Mode",
                "flag": false
            },
            {
                "map": 1,
                "name": "[SE0550]",//"Night Mode",
                "flag": false
            }
        ],
        "DBXArray":[0, 0, 0], //DBXSonic 0 1, DBXSurr 0 1, DBXVolume 0 1 2
        "currTotalVolumeIdx": 0
    };
    function SndgetTotalVolumeIdx() {
        try {

            AudioDBXTotalVolumeList.operateData.DBXArray = tv ? createArray(model.getTotalSonics()) : [0, 0, 0];
            DBG_INFO("DBXArray : " + objToString(AudioDBXTotalVolumeList.operateData.DBXArray));

            var dbxVolModeTmp = AudioDBXTotalVolumeList.operateData.DBXArray[2];
            DBG_INFO("model.sound.getTotalVolume=" + dbxVolModeTmp);
            for (var i = 0; i < AudioDBXTotalVolumeList.operateData.TotalVolumeList.length; i++) {
                if (dbxVolModeTmp == AudioDBXTotalVolumeList.operateData.TotalVolumeList[i].map) {
                    break;
                }
            }
            return i;

        } catch (ex) {
            DBG_ERROR("SndgetTotalVolumeIdx:" + ex.message);
        }
    }

    // 初始化Grid控件
    // 取得目标锚点
    var List = UI.getItem(AudioDBXTotalVolumeList, "List");

    // Grid的配置信息JSON
    var info = {
        // 每个图标使用的模板名
        template: "DialogListItem",
        // V表示竖向排列，H表示横向排列
        direction: CONST.GIRD_DIRECTION.H,
        // 每隔几个图标就换行
        breakNum: 1,
        // 每隔图标之间的距离
        distanceX: 0,
        distanceY: 20,
        // 要将此Grid添加到哪个锚点位置上
        container: List
    };

    // 声明一个初始化用数组，将数据配置好
    var allArray = [];
    for (var i = 0; i < AudioDBXTotalVolumeList.operateData.TotalVolumeList.length; i++) {
        allArray.push(
            {
                ItemName: AudioDBXTotalVolumeList.operateData.TotalVolumeList[i].name,
                tileBg: UI.item_bg,
                name: "item" + i,
                isFlag: "setting/ic_radiobutton_normal.png"
            }
        )
    }
    // 调用Grid.create方法生成Gird并添加到锚点位置上
    Gird.create(allArray, info);
    // 设置视野范围，当焦点超出此范围时，整个Grid会反向移动，达到滚动效果（此处配置的x，y是全局坐标）

    // 设置遮罩范围，隐藏显示不下的图标
    AudioDBXTotalVolumeList.operateData.currTotalVolumeIdx = SndgetTotalVolumeIdx();
    AudioDBXTotalVolumeList.currFocus = UI.getItem(List, "item" + AudioDBXTotalVolumeList.operateData.currTotalVolumeIdx);
    AudioDBXTotalVolumeList.onShow = function () {
        AudioDBXTotalVolumeList.operateData.currTotalVolumeIdx = SndgetTotalVolumeIdx();
        DBG_INFO("setAudioDBXTotalVolumeList.onShow");
        for (var i = 0; i < List.initSequence.length; i++) {
            UI.setImage(List.children[i].children[2], "setting/ic_radiobutton_normal.png",List.children[i]);
        }
        UI.focusTo(UI.getItem(List, "item" + AudioDBXTotalVolumeList.operateData.currTotalVolumeIdx)) ;
        UI.setImage(AudioDBXTotalVolumeList.currFocus.children[2], OEMFunction.getInstance().getBrandSelectFocusImage(),AudioDBXTotalVolumeList.currFocus);
    };

    function SndSetCurrTotalVIdx(idx) {
        try {
            AudioDBXTotalVolumeList.operateData.currTotalVolumeIdx = idx;

            var DBXTotalVolumeMapList = AudioDBXTotalVolumeList.operateData.TotalVolumeList;
            if (idx > DBXTotalVolumeMapList.length - 1) {
                DBG_ERROR("SndSetCurrTotalVIdx:idx=" + idx);
                idx = 0;
            }
            DBG_INFO("model.sound.setTotalVolume:"+DBXTotalVolumeMapList[idx].map);
            if(tv){
                var DBXVolume = DBXTotalVolumeMapList[idx].map;
                AudioDBXTotalVolumeList.operateData.DBXArray[2] = DBXVolume;
                model.sound.setTotalSonics(createIntergerVector(AudioDBXTotalVolumeList.operateData.DBXArray));
            }

        } catch (ex) {
            DBG_ERROR("SndSetCurrTotalVIdx:" + ex.message);
        }

    }

    List.onkey_ENTER = function (focus) {
        var index = List.initSequence.indexOf(focus);//AudioDBXTotalVolumeList.currFocus.name.slice(-1);
        for (var i = 0; i < List.initSequence.length; i++) {
            UI.setImage(List.children[i].children[2], "setting/ic_radiobutton_normal.png");
        }
        UI.setImage(AudioDBXTotalVolumeList.currFocus.children[2], OEMFunction.getInstance().getBrandSelectFocusImage());
        SndSetCurrTotalVIdx(index);
        UI.popSubModule();
        return true;
    };

};