/**
 * Created by jiangbo1 on 2016/3/1.
 */
UI.moduleBuilder['liveTV']['numKeyboard'] = function () {

    var numKBDData = {
        num_pad_bg: GLOBAL.IMAGE_LIST.NUM_KEYBOARD_BG,
        inputGrpImg: "liveTV/numkeyboard/input_line.png",
        num_bg: GLOBAL.IMAGE_LIST.NONE,
        channel_bg: GLOBAL.IMAGE_LIST.NONE,
        noItemIcon: GLOBAL.IMAGE_LIST.NUM_KEYBOARD_NO_ITEM,
        optTipIcon: GLOBAL.IMAGE_LIST.NUM_KEYBOARD_SEARCH,
        numFocusImg: GLOBAL.IMAGE_LIST.NUM_KEYBOARD_FOCUS,
        optTipText: "[SE3113]", //"You can press digital keys on the left, to get the relevant channels.",
        noItemText: "[SE3114]"  //"No relevant channels."
    };

    var template = Util.readJson("module/liveTV/numKeyboard.json");
    var numKBD = SubModule.create(numKBDData, template);
    var noItemPanel = UI.getItem(numKBD, "noItemPanel");
    var optTipPanel = UI.getItem(numKBD, "optTipPanel");
    var channelItem = UI.getItem(numKBD, "channelItem");
    var inputGrpText = UI.getItem(numKBD, "inputGrpText");
    var optTipText = UI.getItem(numKBD, "optTipText");

    //var numPanel = UI.getItem(numKBD, "numPanel");
    var numItem = UI.getItem(numKBD, "numItem");
    var numFocusImg = UI.getItem(numKBD, "numFocusImg");

    var channelPanel = UI.getItem(numKBD, "channelPanel")
    var channelItem = UI.getItem(channelPanel, "channelItem");

    //var numFocusIndex = 0;
    var baseX = 100, baseY = 244, itemWH = 110, allChannels = [], filterdChannels = [], filterStr = "", channelIndex;

    var imgList = [
        "liveTV/numkeyboard/key_1.png",
        "liveTV/numkeyboard/key_2.png",
        "liveTV/numkeyboard/key_3.png",
        "liveTV/numkeyboard/key_4.png",
        "liveTV/numkeyboard/key_5.png",
        "liveTV/numkeyboard/key_6.png",
        "liveTV/numkeyboard/key_7.png",
        "liveTV/numkeyboard/key_8.png",
        "liveTV/numkeyboard/key_9.png",
        "liveTV/numkeyboard/key_line.png",
        "liveTV/numkeyboard/key_0.png",
        "liveTV/numkeyboard/key_delete.png"
    ];
    var ttsStrMap = [];
    var SpeedMap = [1, 1, 1, 2, 2, 2, 4], rptTimes = 0, maxItem = 8;

    function initNumKeyboard() {
        noItemPanel.alpha = 0;
        noItemPanel.children[1].alpha = 0.7;
        optTipPanel.children[1].alpha = 0.7;
        var gridInfo = {
            template: "iconTile",
            direction: CONST.GIRD_DIRECTION.H,
            breakNum: 3,
            distanceY: 10,
            distanceX: 10,
            container: numItem
        };

        var allArray = [];
        ttsStrMap = [];
        for (var i = 0; i < imgList.length; i++) {
            allArray.push({
                icon: imgList[i],
                name: "BTN" + i
            });
            ttsStrMap.push((i + 1) + "");
        }
        ttsStrMap[9] = "-";
        ttsStrMap[10] = "0";
        ttsStrMap[11] = "Delete";
        numItem.removeAllChildren();
        numItem.initSequence = [];
        Gird.create(allArray, gridInfo);

        numKBD.currFocus = UI.getItem(numItem, "BTN4");
    }

    function createFilteredChannelGrid(chnls) {
        var gridInfo = {
            template: "filterChannelTile",
            direction: CONST.GIRD_DIRECTION.H,
            breakNum: 1,
            distanceY: 6,
            distanceX: 0,
            container: channelItem,
            initNum : maxItem + 3
        };

        var allArray = [];
        for (var i = 0; i < chnls.length; i++) {
            allArray.push({
                tileBg: UI.chlist_bg,//GLOBAL.IMAGE_LIST.CHANNEL_ITEM_BG,
                chNumMatch: chnls[i].number.substring(0, filterStr.length),
                chNumRemain: !!chnls[i].number.substring(filterStr.length)? chnls[i].number.substring(filterStr.length): " ",
                chName: chnls[i].name,
                isFav: chnls[i].favType ? GLOBAL.IMAGE_LIST.FAV48 : GLOBAL.IMAGE_LIST.NONE,
                isLock: (1 == GLOBAL.PARENTAL_LOCK_SWITCH && chnls[i].isLock) ? GLOBAL.IMAGE_LIST.LOCK48 : GLOBAL.IMAGE_LIST.NONE,
                name: "CHANNEL" + i
            });
        }


        channelItem.removeAllChildren();
        channelItem.initSequence = [];
        channelItem.mask = null;
        channelItem.viewRect = null;
        channelItem.scrollbar = null;
        while (channelPanel.children.length > 2) channelPanel.children.pop();
        if (allArray.length > 0) {
            Gird.create(allArray, gridInfo);
            UI.addMask(channelItem, 620, 730, 50, 0);
            UI.setView(channelItem, 620, 730);
            UI.addScrollbar(channelItem, -10);
            noItemPanel.alpha = 0;
        }
        else {
            noItemPanel.alpha = 1;
            filterStr = "";
        }
    }

    function resetNumTextPositionAndAlpha(items) {
        if (!items || 0 == items.length) return;
        items.forEach(function (v) {
            //v.children[1]._bounds = null;
            var bnds = v.children[1].getBounds();
            v.children[2].x = parseInt(v.children[2].x + bnds.width - 23);
            v.alpha = 0.7;
            //v.updateCache();
        });
    }

    function moveKeboardFocus(focus) {
        var index = numItem.initSequence.indexOf(focus);
        var row = Math.floor(index / 3), col = index % 3;
        UI.getTween(numFocusImg).to({x: baseX + col * itemWH, y: baseY + row * itemWH}, 500, UI.ease.quartOut);
        focus.voiceStr = ttsStrMap[index];
        liveTVTimeoutCallTTS(focus);
    }

    numItem.onkey_ENTER = function (focus) {
        var notShowNoItemPannel = false;
        var str = "", idx = numItem.initSequence.indexOf(focus);
        if (idx >= 0 && idx <= 8) {
            str = (idx + 1) + "";
        }
        else if (10 == idx) {
            str = "0";
        }
        else if (9 == idx) {
            str = "-";
        }
        else {
            filterStr = "";
            notShowNoItemPannel = true;
        }
        filterStr += str;
        setLiveTVText(inputGrpText, filterStr);
        if ("" != filterStr) {
            optTipPanel.alpha = 0;
            filterdChannels = allChannels.filter(function (v) {
                return (v.number.substring(0, filterStr.length) == filterStr);
            });
        }
        else {
            filterdChannels = [];
            optTipPanel.alpha = 1;
        }
        noItemPanel.alpha = 0;
        channelIndex = 0;
        createFilteredChannelGrid(filterdChannels);
        resetNumTextPositionAndAlpha(channelItem.initSequence);
        setCurrentPageData(0);
        if (notShowNoItemPannel) {
            noItemPanel.alpha = 0;
        }
        UI.updateStage();
    }

    numItem.onkey_RIGHT = function (focus) {
        var index = numItem.initSequence.indexOf(focus);
        var col = index % 3;
        if (2 == col) {
            if (1 == noItemPanel.alpha || 1 == optTipPanel.alpha) return false;
            numFocusImg.alpha = 0;
            //numFocusImg.x = baseX + itemWH;
            //numFocusImg.y = baseY + itemWH;
            var target = channelItem.initSequence[channelIndex];
            UI.focusTo(target);
            return false;
        }
        return true;
    }
    channelItem.onkey_LEFT = function () {
        numFocusImg.alpha = 1;
        var target = UI.getItem(numItem, "BTN4");
        UI.focusTo(target);
    }
    channelItem.onkey_ENTER = function (focus) {
        var idx = channelItem.initSequence.indexOf(focus);
        var chnl = filterdChannels[idx];

        UI.popSubModule();
        openLiveTVModule([Msg.INFO, 0, Msg.PASSWORD, 0, Msg.AUDIO, 0]);

        if (!compareChannel(chnl, liveTV.getCurrentChannelInfo())) {
            if(liveTV.setStateBefChangeChannel(ChangeType.CH_OBJ, chnl)){
                if(GLOBAL.CURRENT_CHLIST_INDEX != CHLISTINDEX.ALL && chnl.favType != true) {
                    setPlayedChListIndex(CHLISTINDEX.ALL);
                }
                liveTV.changeChannel(chnl);
            }
        }
    }

    function getNumPadGain(t, x) {
        if (t < 14) return 1;
        if (x >= SpeedMap.length) x = SpeedMap.length - 1;
        return SpeedMap[x];
    }

    function clearNumPadRepeat() {
        rptTimes = 0;
    }

    function setCurrentPageData(chIdx){
        var minI = Math.max(0, chIdx - maxItem),
            maxI = Math.min(channelItem.initSequence.length, chIdx + maxItem);
        channelItem.initSequence.forEach(function (v) {
            //v.alpha = 0;
            if (v.parent) {
                v.parent.removeChild(v);
            }
        });
        for (var i = minI; i < maxI; i++) {
            channelItem.initSequence[i].alpha = 0.6;
            channelItem.addChild(channelItem.initSequence[i]);
            channelItem.addChild(UI.base.cursor);
        }
        channelIndex = Math.min(channelItem.initSequence.length - 1, chIdx);
    }

    function flipChannelList(flag, focus) {
        if (1 == channelItem.initSequence.length) return false;
        var index = channelItem.initSequence.indexOf(UI.getCurrSubModule().currFocus);
        var presetIndex = index + flag * getNumPadGain(channelItem.initSequence.length, rptTimes++);
        if (1 == flag && presetIndex > channelItem.initSequence.length - 1) {
            presetIndex = 0;
        }
        else if (-1 == flag && presetIndex < 0) {
            presetIndex = channelItem.initSequence.length - 1;
        }
        setCurrentPageData(presetIndex);
        UI.focusTo(channelItem.initSequence[presetIndex]);
        return false;
    }

    channelItem.onkey_DOWN = flipChannelList.bind(this, 1);
    channelItem.onkey_UP = flipChannelList.bind(this, -1);

    channelItem.onFocus = function (focus) {
        DBG_ONXX("channelItem", "onFocus");
        focus.alpha = 1;
        onFocusLiveTVTarget(focus, 1.05, 500);
    }

    channelItem.onNormal = function (focus) {
        DBG_ONXX("channelItem", "onNormal");
        onNormalLiveTVTarget(focus, 0.7, 500);
    }

    numItem.onFocus = function (focus) {
        moveKeboardFocus(focus);
        UI.getTween(focus).to({scaleX: 1.05, scaleY: 1.05}, 500, UI.ease.quartOut);
    }

    numItem.onNormal = function (focus) {
        UI.getTween(focus).to({scaleX: 1, scaleY: 1}, 500, UI.ease.quartOut);
    }

    numKBD.onPush = function () {
        setLiveTVText(optTipText, " ");   //temporary measure for MSD6586US-1610
        setTimeout(function() {
            UI.setText(optTipText, "[SE3113]");
        }, 800);

        //UI.setImage(numFocusImg, GLOBAL.HICONTRAST ? GLOBAL.IMAGE_LIST.NUM_KEYBOARD_FOCUS_CONTRAST : GLOBAL.IMAGE_LIST.NUM_KEYBOARD_FOCUS);
        setLiveTVImage(numFocusImg, GLOBAL.HICONTRAST ? GLOBAL.IMAGE_LIST.NUM_KEYBOARD_FOCUS_CONTRAST : GLOBAL.IMAGE_LIST.NUM_KEYBOARD_FOCUS);
        allChannels = liveTV.getRefChannels();
        filterdChannels = [];
        filterStr = "";
        setLiveTVText(inputGrpText, filterStr);
        createFilteredChannelGrid(filterdChannels);
        noItemPanel.alpha = 0;
        optTipPanel.alpha = 1;
        numFocusImg.alpha = 1;
        numFocusImg.x = baseX + itemWH;
        numFocusImg.y = baseY + itemWH;
        numKBD.currFocus = UI.getItem(numItem, "BTN4");
        UI.base.cursor.alpha = 0;

        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.KEY_RELEASE, clearNumPadRepeat);
    }

    numKBD.onShow = function() {
        UI.setLiveTVMenuTimeout(autoExitLiveTVSubModel, 15 * 1000);
    };

    numKBD.afterPush = function() {
        UI.updateStage();
    };

    numKBD.onPop = function () {
        allChannels = [];
        filterdChannels = [];
        UI.clearLiveTVMenuTimeout();
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.KEY_RELEASE, clearNumPadRepeat);
    }

    numKBD.onkey_CHDOWN = function() {
        //todo 翻页
    };
    numKBD.onkey_CHUP = function() {
        //todo 翻页
    };

    numKBD.onkey_BACKSPACE = function() {
        UI.popSubModule();
        UI.pushSubModule("setting",  "menuChip", true,{origin:"liveTV"},null,"CHIP"+ CHIPS.KEYBOARD);
    };

    initNumKeyboard();
};