//init
UI.moduleBuilder['liveTV']['infoDetailPage'] = (function () {
    var infoDetailPageData = {
        bgImgBig: "setting/dialog_bg.png",
        bgImg: UI.list_bg,
        footerIcon: "EPG/epgMain/hotkey_epg_blue.png",
        footerText: "[BR0010]"  //"Exit"
    };
    var template = Util.readJson("module/liveTV/infoDetailPage.json");
    var infoDetailPage = SubModule.create(infoDetailPageData, template);

    var headerText = UI.getItem(infoDetailPage, "headerText");
    var bodyText = UI.getItem(infoDetailPage, "bodyText");
    var footerIcon = UI.getItem(infoDetailPage, "footerIcon");
    var footerText = UI.getItem(infoDetailPage, "footerText");

    var originY = bodyText.y;
    var bodyTextHeight;

    UI.addMask(bodyText, 820, 560);

    infoDetailPage.currFocus = bodyText;

/*--------------------------Action---------------------------*/

    infoDetailPage.onPush = function() {
        footerIcon.x = footerText.children[0].x - footerText.getBounds().width;
        bodyText.y = originY;
        var pageData = liveTV.getLiveTVCtrlDataObj();
        UI.setText(headerText, pageData.crntName);
        UI.setText(bodyText, pageData.detailInfo);
        UI.callTTS(pageData.crntName + " " + pageData.detailInfo + " " + "[BR0010]");
        bodyTextHeight = bodyText.children[0].getBounds().height;
    };

    infoDetailPage.onShow = function() {
        infoDetailPage.visibel = true;
        UI.setLiveTVMenuTimeout(autoExitLiveTVSubModel, 30*1000);
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.alpha = 0;
        UI.updateStage();
    };

    infoDetailPage.afterPush = function() {
        infoDetailPage.visibel = true;
        UI.updateStage();
    };

    infoDetailPage.onPop = function () {
        UI.clearLiveTVMenuTimeout();
    };

    infoDetailPage.onkey_BACKSPACE = infoDetailPage.onkey_BLUE = function() {
        UI.popAllModule();
        openLiveTVModule();
    };
    infoDetailPage.onkey_EXIT = infoDetailPage.onkey_BACKSPACE;

    infoDetailPage.onkey_UP = function() {
        if (bodyText.y >= originY) return;
        bodyText.y += 180;
        UI.updateStage();
    };
    infoDetailPage.onkey_DOWN = function() {
        if (bodyText.y <= originY - bodyTextHeight + 300) return;
        bodyText.y -= 180;
        UI.updateStage();
    };

});