UI.templateManager["module/launcher/statusBar.json"] = {
    "statusBar" : {
        "type" : 0,
        "position" : {"x" :0, "y" :0},
        "items" : {
            "overlay" : {
                "type" : 7,
                "bound" : {"w" :1920, "h" :660},
                "position" : {"x" :0, "y" :0}
            },
            "timeBar" : {
                "type" : 0,
                "position" : {"x" :48, "y" :0},
                "items" : {
                    "time" : {
                        "type" : 6,
                        "bound" : {"w":300, "h":84},
                        "innerPos" : {"x" :0, "y" :10},
                        "value" :"12:00",
                        "font" :"84px SourceSansPro-Light",
                        "color" :"0xFFFFFF",
                        "align" :"left",
                        "column" :"middle",
                        "position" : {"x" :0, "y" :10},
                        "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
                    },
                    "am" : {
                        "type" : 6,
                        "bound" : {"w":60, "h":40},
                        "innerPos" : {"x" :0, "y" :0},
                        "value" :"AM",
                        "font" :"30px SourceSansPro-Light",
                        "color" :"0xFFFFFF",
                        "align" :"left",
                        "position" : {"x" :222, "y" :14},
                        "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
                    },
                    "pm" : {
                        "type" : 6,
                        "bound" : {"w":60, "h":40},
                        "innerPos" : {"x" :0, "y" :0},
                        "value" :"PM",
                        "font" :"30px SourceSansPro-Regular",
                        "color" :"0xFFFFFF",
                        "align" :"left",
                        "position" : {"x" :222, "y" :50},
                        "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
                    }
                }
            },
            "dataBar" : {
                "type" : 0,
                "position" : {"x" :200, "y" :0},
                "items" : {
                    "date" : {
                        "type" : 6,
                        "bound" : {"w":180, "h":40},
                        "innerPos" : {"x" :90, "y" :5},
                        "value" :"12 26, 2015",
                        "font" :"28px SourceSansPro-Regular",
                        "color" :"0xFFFFFF",
                        "align" :"left",
                        "position" : {"x" :275, "y" :14},
                        "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
                    },
                    "weekday" : {
                        "type" : 6,
                        "bound" : {"w":200, "h":40},
                        "innerPos" : {"x" :0, "y" :0},
                        "value" :"[GE0021]",
                        "font" :"28px SourceSansPro-Regular",
                        "color" :"0xFFFFFF",
                        "align" :"left",
                        "position" : {"x" :275, "y" :50},
                        "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
                    }
                }
            },
            "temperature" : {
                "type" : 6,
                "bound" : {"w":600, "h":84},
                "innerPos" : {"x" :102, "y" :0},
                "value" :"28'C",
                "font" :"84px SourceSansPro-Light",
                "color" :"0xFFFFFF",
                "align" :"right",
                "position" : {"x" :390, "y" :10},
                "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
            },
            "city" : {
                "type" : 6,
                "bound" : {"w":205, "h":40},
                "innerPos" : {"x" :0, "y" :0},
                "value" :"NewYork",
                "font" :"28px SourceSansPro-Regular",
                "color" :"0xFFFFFF",
                "align" :"left",
                "position" : {"x" :1000, "y" :14},
                "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
            },
            "weatherState" : {
                "type" : 6,
                "bound" : {"w":205, "h":40},
                "innerPos" : {"x" :0, "y" :0},
                "value" :"Rainy",
                "font" :"28px SourceSansPro-Regular",
                "color" :"0xF8f8f8",
                "align" :"left",
                "position" : {"x" :998, "y" :50},
                "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
            },
            "networkType" : {
                "type" : 6,
                "bound" : {"w":600, "h":84},
                "innerPos" : {"x" :102, "y" :0},
                "value" :"[SE0159]",
                "font" :"48px SourceSansPro-Light",
                "color" :"0xFFFFFF",
                "align" :"right",
                "position" : {"x" :1170, "y" :10},
                "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
            },
            "weatherIcon" : {
                "type" : 7,
                "bound" : {"w" :96, "h" :96},
                "position" : {"x" :740, "y" :6},
                "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
            },
            "weatherIcon2" : {
                "type" : 7,
                "bound" : {"w" :360, "h" :72},
                "position" : {"x" :760, "y" :6},
                "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
            },
            "loadState" : {
                "type" : 7,
                "bound" : {"w" :72, "h" :72},
                "position" : {"x" :1450, "y" :15},
                "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
            },
            "loadState2" : {
                "type" : 7,
                "bound" : {"w" :72, "h" :72},
                "position" : {"x" :1450, "y" :15},
                "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
            },
            "networkState" : {
                "type" : 7,
                "bound" : {"w" :72, "h" :72},
                "position" : {"x" :1800, "y" :15},
                "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
            },
            "jumpTxt1" : {
                "type" : 6,
                "bound" : {"w":300, "h":72},
                "innerPos" : {"x" :0, "y" :36},
                "value" :"[OT0397]",
                "font" :"24px SourceSansPro-Light",
                "color" :"0xFFFFFF",
                "align" :"left",
                "column" :"middle",
                "position" : {"x" :180, "y" :2595},
                "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
            },
            "jumpTxt2" : {
                "type" : 6,
                "bound" : {"w":300, "h":72},
                "innerPos" : {"x" :0, "y" :36},
                "value" :"[LA0113]",
                "font" :"24px SourceSansPro-Light",
                "color" :"0xFFFFFF",
                "align" :"left",
                "column" :"middle",
                "position" : {"x" :440, "y" :2595},
                "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
            },
            "channelTxt" : {
                "type" : 6,
                "bound" : {"w":1920, "h":72},
                "innerPos" : {"x" :0, "y" :0},
                "value" :"[SE3149]",
                "font" :"72px SourceSansPro-Light",
                "color" :"0xFFFFFF",
                "align" :"left",
                "column" :"middle",
                "position" : {"x" :180, "y" :2550},
                "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
            },
            "appTxt" : {
                "type" : 6,
                "bound" : {"w":1920, "h":72},
                "innerPos" : {"x" :0, "y" :0},
                "value" :"[SE3150]",
                "font" :"72px SourceSansPro-Light",
                "color" :"0xFFFFFF",
                "align" :"left",
                "column" :"middle",
                "position" : {"x" :180, "y" :1990},
                "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
            },
            "inputTxt" : {
                "type" : 6,
                "bound" : {"w":1920, "h":72},
                "innerPos" : {"x" :0, "y" :0},
                "value" :"[SE3151]",
                "font" :"72px SourceSansPro-Light",
                "color" :"0xFFFFFF",
                "align" :"left",
                "column" :"middle",
                "position" : {"x" :180, "y" :1320},
                "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
            },
            "secondaryImg" : {
                "type" : 7,
                "bound" : {"w" :96, "h" :96},
                "position" : {"x" :914, "y" :936},
                "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
            },
            "secondaryImg2" : {
                "type" : 7,
                "bound" : {"w" :240, "h" :120},
                "position" : {"x" :842, "y" :924},
                "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
            },
            "secondaryTxt" : {
                "type" : 6,
                "bound" : {"w":1920, "h":60},
                "innerPos" : {"x" :960, "y" :0},
                "value" :"[SE3146]",
                "font" :"60px SourceSansPro-Light",
                "color" :"0xFFFFFF",
                "align" :"center",
                "column" :"middle",
                "position" : {"x" :0, "y" :864},
                "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
            },
            "editAddTxt" : {
                "type" : 6,
                "bound" : {"w":1220, "h":60},
                "innerPos" : {"x" :610, "y" :0},
                "value" :"[SE3146]",
                "font" :"75px SourceSansPro-Light",
                "color" :"0xFFFFFF",
                "align" :"left",
                "column" :"middle",
                "position" : {"x" :180, "y" :1110},
                "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
            },
            "arrangeImg1" : {
                "type" : 7,
                "bound" : {"w" :96, "h" :96},
                "position" : {"x" :392, "y" :218},
                "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
            },
            "arrangeImg2" : {
                "type" : 7,
                "bound" : {"w" :240, "h" :120},
                "position" : {"x" :320, "y" :170},
                "navigation" : {"leftTo" : null, "rightTo" : null, "upTo" : null, "downTo" : null}
            },
            "msgPanel":{
                "type" : 0,
                "position" : {"x" :471, "y" :776},
                "navigation" : {"leftTo" : "", "rightTo" : "", "upTo" : "", "downTo" : ""},
                "items" : {
                    "bgImg" : {
                        "type" : 7,
                        "bound" : {"w" :930, "h" :264},
                        "position" : {"x" :0, "y" :0}
                    },
                    "toastImg" : {
                        "type" : 7,
                        "bound" : {"w" :128, "h" :128},
                        "position" : {"x" :66, "y" :66}
                    },
                    "msgTxt" : {
                        "type" : 6,
                        "bound" : {"w":630, "h":264},
                        "innerPos" : {"x" :0, "y" :0},
                        "value" :"msg",
                        "font" :"36px SourceSansPro-Light",
                        "color" :"0x363E4D",
                        "align" :"center",
                        "column" :"middle",
                        "position" : {"x" :232, "y" :0},
                        "warp" : true
                    }
                }
            }
        }
    }
};
UI.moduleBuilder['launcher']['statusBar'] = function(){

	var statusBarData = {
		overlay : {url : "launcher/bg_overlay_status_bar.png", cache : "statusBar"},
		//msgImg : "launcher/panelMsg.png",
		bgImg : "toast/Toast_bg2.png",
		toastImg:"launcher/ic_warn.png",
		weatherIcon: "launcher/weather/weather_unknown.png",
		weatherIcon2: "launcher/weather/ic_statusbar_accweather.png",
		secondaryImg : "launcher/la_ic_hint_add.png",
        secondaryImg2 : "launcher/la_ic_hint_arrow_down.png",
        arrangeImg1 : "launcher/la_ic_hint_arrange.png",
        arrangeImg2 : "launcher/la_ic_hint_arrow_up.png",
		loadState : "launcher/ic_stat_ota_updating_circle.png",
		loadState2 : "launcher/ic_stat_ota_updating_arrow.png"
	};
	var template = Util.readJson("module/launcher/statusBar.json");
	var statusBar = SubModule.create(statusBarData, template, "launcher");
	var msgPanel = UI.getItem(statusBar, "msgPanel");
	msgPanel.alpha = 0;
	var overlay = UI.getItem(statusBar, "overlay");
	overlay.alpha = 0;

	var dataBar = UI.getItem(statusBar, "dataBar");
	var timeBar = UI.getItem(statusBar, "timeBar");
	var time = UI.getItem(timeBar, "time");
	var am = UI.getItem(timeBar, "am");
	var pm = UI.getItem(timeBar, "pm");
	var date = UI.getItem(dataBar, "date");
	var weekday = UI.getItem(dataBar, "weekday");
	var networkTypeText = UI.getItem(statusBar, "networkType");
	var networkState = UI.getItem(statusBar, "networkState");

	var temperature = UI.getItem(statusBar, "temperature");
	var city = UI.getItem(statusBar, "city");
	var weatherState = UI.getItem(statusBar, "weatherState");
	var loadState = UI.getItem(statusBar, "loadState");
	var loadState2 = UI.getItem(statusBar, "loadState2");
	var weatherIcon = UI.getItem(statusBar, "weatherIcon");
	var weatherIcon2 = UI.getItem(statusBar, "weatherIcon2");
	loadState.alpha = 0;
	loadState2.alpha = 0;
	timeBar.noRTL = true;
    function getWifiSignalLevel(signal){
        var level = 1;
        if(signal <= 25){
            level = '1';
        }else if(signal > 25 && signal <= 50){
            level = '2';
        }else if(signal > 50 && signal <= 75){
            level =  '3';
        }else{
            level = '4';
        }
        return level;
    }

    function showNetworkStatus(){
        var NetStatus = tv ? model.network.getEnumNetworkAvailable() : 1; //1 success  0 fail
       DBG_INFO("launcher statusBar networkStates is:" + NetStatus);
        var networkType = tv?model.network.getEnumNetworking():1;
        DBG_INFO("launcher statusBar networkType is:" + networkType);
        if(networkType == NetWorkType.ETHER){
            if(NetStatus == NetWorkConnect.CONNECT){
                UI.setImage(networkState,"launcher/network/ic_stat_ethernet.png");
                UI.setText(networkTypeText,"[SE0159]");
            }else{
                UI.setImage(networkState,"launcher/network/ic_stat_offline.png");
                UI.setText(networkTypeText," ");
            }
        }else if(networkType == NetWorkType.WIRELESS){
            if(NetStatus == NetWorkConnect.CONNECT){
                var wifiName = tv?model.network.getSsid():"wifiname";
                var wifiSignal = tv? model.network.getlink_signal_1():100;
                DBG_ERROR("launcher statusBar networkType isOOOOOOOO:" + wifiSignal);
                var level = getWifiSignalLevel(wifiSignal);
                var img = "launcher/network/ic_stat_wifi_signal_"+level+".png";
                DBG_INFO("immg:"+img);
                UI.setImage(networkState,img);
                UI.setText(networkTypeText,wifiName);
            }else{
                UI.setImage(networkState,"launcher/network/ic_stat_wifi_not_connected.png");
                UI.setText(networkTypeText," ");
            }
        }else{
            UI.setImage(networkState,"launcher/network/ic_stat_offline.png");
            UI.setText(networkTypeText," ");
        }
    }

    function onNetworkStatusChanged(val){
        showNetworkStatus();
    }
    function onNetworkStatusChanged2(val){
        weatherIcon2.alpha = 1;
        temperature.alpha = 0;
        city.alpha = 0;
        weatherState.alpha = 0;
        weatherIcon.alpha = 0;
        UI.setImage(networkState,"launcher/network/ic_stat_offline.png");
        UI.setText(networkTypeText," ");
    }
    function refreshWeather(weatherData) {
        launcher.weatherData=weatherData;
        DBG_INFO("launcher.weatherData: "+ objToString(launcher.weatherData));
        if (launcher.weatherData == "noLocation") {
            DBG_INFO("launcher.weatherData == noLocation");
            weatherIcon2.alpha = 1;
            temperature.alpha = 0;
            city.alpha = 0;
            weatherState.alpha = 0;
            weatherIcon.alpha = 0;
        } else {
            DBG_INFO("!! launcher.weatherData");
            weatherIcon2.alpha = 0;
            temperature.alpha = 1;
            city.alpha = 1;
            weatherState.alpha = 1;
            weatherIcon.alpha = 1;
            if (launcher.weatherData.name == null || launcher.weatherData.name == undefined) {
                DBG_INFO( "launcher.weatherData.name is error " );
                UI.setImage(weatherIcon, "launcher/weather/weather_unknown.png");
            } else {
                DBG_INFO( "launcher.weatherData.name: "+ launcher.weatherData.name );
                UI.setImage(weatherIcon, "launcher/weather/" + launcher.weatherData.icon + ".png");
                UI.setText(temperature, launcher.weatherData.degree);
                UI.setText(city ,launcher.weatherData.name);
                UI.setText(weatherState, launcher.weatherData.weather);
            }
            var point1 = temperature.children[0].parent.toGlobal(temperature.children[0].position);
            var point2 = statusBar.parent.toGlobal(statusBar.position);
            weatherIcon.x = point1.x - point2.x - weatherIcon.pivot.x - temperature.children[0].pivot.x - 5;
            //var textX = temperature.toLocal(temperature.children[0].position, statusBar).x;
            //weatherIcon.x = textX - TextMeasurer.measure(temperature.children[0].text, temperature.children[0]) - weatherIcon.pivot.x - 5;
        }
    }

    statusBar.onPush = function () {
        if(!!GLOBAL.LAUNCHER_FIRSTTIME){
            onNetworkStatusChanged2();
            getCurrentDate();
            setTimeout(function() {
                statusBar.onPush();
            }, 2000);
        }else{
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, onNetworkStatusChanged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_STYLE_CHANGED, onNetworkStatusChanged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.TIME_FORMAT_CHANGED, getCurrentDate);
            showNetworkStatus();
            getCurrentDate();
            getCurrentWeatherData(refreshWeather);
            loadStatefunction();
        }
    };
    function loadStatefunction() {
    if(GLOBAL.LAUNCHER_OTA_UPDATE){
            loadState.alpha = 1;
            loadState2.alpha = 1;
            UI.getTween(loadState, true, true).to({rotation: loadState.rotation + 360}, 150000);
        }
        else{
            loadState.alpha = 0;
            loadState2.alpha = 0;
        }
    }
    statusBar.onPop = function(){
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, onNetworkStatusChanged);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_STYLE_CHANGED, onNetworkStatusChanged);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.TIME_FORMAT_CHANGED, getCurrentDate);
        clearTimeout(launcher.clockTimer);
        //launcher.removeChild(launcher.overlayMain);
        //launcher.removeChild(launcher.netflixOverlayMain);
    };
    function getCurrentDate() {
        DBG_ALWAYS("refresh Time");
        var t = getSystemTime();
        var longtime = getSystemLongTime();
        var utcdate = new Date(getLocalTimeByUTC(longtime) * GLOBAL.MILLIBASE);
       try{
        UI.setText(time, t.time.hour + ":" + t.time.min);
        if(t.time.hour <= 9){dataBar.x = 210;}
        else{dataBar.x = 236;}
        var temp = tv?model.datetime.getTimeFormat():0;
        if(!temp){
            if (t.time.flag == 0) {
                am.alpha = 1;
                pm.alpha = 0;
            }  else if (t.time.flag == 1) {
                am.alpha = 0;
                pm.alpha = 1;
            }else {
                am.alpha = 0;
                pm.alpha = 0;
            }
        }else{
            am.alpha = 0;
            pm.alpha = 0;
        }
       // UI.setText(amPm, timeNum[1] ? timeNum[1] : "");
        UI.setText(weekday, CONST.LONG_WEEK[utcdate.getUTCDay()]);
           if (GLOBAL.DATE_FORMAT == "dmy") {
               UI.setText(date, t.day + "/" + t.month + "/" + t.year);
           }  else if (GLOBAL.DATE_FORMAT == "ymd") {
               UI.setText(date, t.year + "/" + t.month + "/" + t.day);
           } else{
               UI.setText(date, t.month + "/" + t.day + "/" + t.year);
           }

        clearTimeout(launcher.clockTimer);
        launcher.clockTimer = setTimeout(getCurrentDate, 20000);
        UI.updateStage();
    }catch (ex){
           DBG_ERROR("statusBar refresh time failed" + ex.message)
       }
    }
    
};