// Init
UI.moduleBuilder['launcher']['fvpApps'] = function(){
    var fvpAppsData = {
        bgImg : UI.back_bg,
        addBtnImg : UI.btn_normal_bg,
        manageBtnImg : UI.btn_normal_bg,
        toastBgImg : "toast/Toast_bg2.png",
        toastImg:"launcher/ic_warn.png",
        iconImg : " ",
        iconBg : "launcher/title/ic_luancher_fvp.png",
        nameTxt : " "
    };
    var template = Util.readJson("module/launcher/fvpApps.json");
    var fvpApps = SubModule.create(fvpAppsData, template, "launcher");
    var allAppIcon = UI.getItem(fvpApps, "allAppIcon");
    var allAppPanel = UI.getItem(fvpApps, "allAppPanel");
    var titleTxt = UI.getItem(fvpApps, "titleTxt");
    var appAnchor = UI.getItem(allAppPanel, "appAnchor");

    var iconImg = UI.getItem(fvpApps, "iconImg");
    var nameTxt = UI.getItem(fvpApps, "nameTxt");

    var msgPanel = UI.getItem(fvpApps, "msgPanel");
    var msgTxt = UI.getItem(msgPanel, "msgTxt");
    var toastBgImg = UI.getItem(msgPanel, "toastBgImg");

    msgPanel.alpha = 0;
    toastBgImg.doFlip = true;

    refreshTiles();
    UI.addMask(appAnchor, 1200, 920, 45, 45);
    UI.setView(appAnchor, 1200, 920);

    appAnchor.lastFocus = appAnchor.children[0];



    fvpApps.onShow = function(from) {
        var mainTiles = UI.getItem(launcher, "mainTiles");
        var launcherTiles = UI.getItem(mainTiles, "launcherTiles");
        var appsTile = UI.getItem(launcherTiles, "fvpApps");

        launcherTiles.alpha = 0;

        launcher.currFocus = fvpApps.currFocus;
    };

    appAnchor.onkey_ENTER = function(focus) {
        //todo start app
        UI.popModule(true);
        if (!getNetworkSatus()) {
            UI.pushSubModule(COMMON.MAIN, COMMON.NETWORK_TIP, true, {caller: "allApps"});
            launcher.lastfocus = focus;
        } else {
            DBG_ERROR("startThirdPartyApp:"+focus.data.url);
            DBG_ERROR("startThirdPartyApp:"+focus.data.storeType);
            startThirdPartyApp(null, focus.data.url, focus.data.urlType, CMDMethod.MENU, false, 0xFFFFFF,focus.data.name, focus.data.storeType);
        }
    };

    fvpApps.onkey_EXIT=function(){
//        launcherPanelCloseReport();
        return true;
    }

    fvpApps.afterPush = function() {
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.alpha = 1;
        UI.base.cursor.visible = true;
        UI.updateStage();
        DBG_INFO("fvpApps After Pushed!!");
    };

    appAnchor.onFocus = function(focus) {
        appAnchor.lastFocus = focus;
        UI.getItem(focus, "txtBg").alpha = 1;
        UI.getItem(focus, "nameTxt").alpha = 1;
        return true;
    };

    appAnchor.onNormal = function(focus) {
        UI.getItem(focus, "txtBg").alpha = 0;
        UI.getItem(focus, "nameTxt").alpha = 0;
        return true;
    };


    function exitModule(para) {
//        launcherPanelCloseReport(para);
        UI.getTween(UI.base.cursor).set({alpha:0});
        UI.inactiveKey();
        if (GLOBAL.LAUNCHER_INFO_EVENT == "APP") {
            launcher.popSelf(true);
        } else {
            UI.popSubModule();
        }

        //UI.getTween(allAppPanel)
        //    .to({x:1920 + allAppPanel.pivot.x}, 500)
        //    .call(UI.popSubModule, [null]);
    }

    function refreshTiles() {
        appAnchor.removeAllChildren();
        //launcher.refreshLauncherData();

        var fvpAppData = getFreeviewAppList();
        UI.setText(titleTxt, fvpAppData.length + " [OT0043]");

        var array = [];
        for (var i = 0; i < fvpAppData.length; i++) {
            var data = {
                //bgImg : UI.item_bg,
                name : fvpAppData[i].title,
                bgImg : fvpAppData[i].icon,
                txtBg : UI.btn_normal_bg,
                nameTxt : fvpAppData[i].title,
                url : fvpAppData[i].url,
                storeType : fvpAppData[i].storeType,
                urlType:fvpAppData[i].urlType
            };
            array.push(data);
        }

        var info = {
            template : "launcher_tile_panel_1",
            direction : CONST.GIRD_DIRECTION.H,
            breakNum : 3,
            distanceX : 10,
            distanceY : -40,
            container : appAnchor
        };
        Gird.create(array, info);

        for (var i = 0; i < appAnchor.initSequence.length; i++) {
            var item = appAnchor.initSequence[i];
            UI.getItem(item, "txtBg").alpha = 0;
            UI.getItem(item, "nameTxt").alpha = 0;
            //if(i%3 == 0){
            //    appAnchor.initSequence[i].onkey_LEFT = exitModule;
            //}
        }
        fvpApps.currFocus = appAnchor.initSequence[0];

        appAnchor.onkey_LEFT = function(focus) {
            if (!focus.leftTo) {
                exitModule();
            } else {
                return true;
            }
        };

        appAnchor.onkey_DOWN = function(focus) {
            if (!focus.downTo) {
                var index = appAnchor.initSequence.indexOf(focus);
                var index2 = Math.floor(index / appAnchor.info.breakNum);
                var index3 = Math.floor(appAnchor.initSequence.length / appAnchor.info.breakNum);
                if (index2 == index3 -1) {
                    UI.focusTo(appAnchor.initSequence[appAnchor.initSequence.length - 1]);
                }
            } else {
                return true;
            }
        }
    }

    function getfvpAppData() {
        //todo

        var appData = [
            {
                imgs: UI.item_bg,
                txts: "app name",
                urls: "app url"
            },
            {
                imgs: UI.item_bg,
                txts: "app name",
                urls: "app url"
            },
            {
                imgs: UI.item_bg,
                txts: "app name",
                urls: "app url"
            },
            {
                imgs: UI.item_bg,
                txts: "app name",
                urls: "app url"
            },
            {
                imgs: UI.item_bg,
                txts: "app name",
                urls: "app url"
            },
            {
                imgs: UI.item_bg,
                txts: "app name",
                urls: "app url"
            },
            {
                imgs: UI.item_bg,
                txts: "app name",
                urls: "app url"
            },
            {
                imgs: UI.item_bg,
                txts: "app name",
                urls: "app url"
            }
        ];

        return appData;
    }
};