// Init
UI.moduleBuilder['hiMedia']['fileBrowser'] = function () {

    var initData = {
        fileBrowserBG: "hiMedia/bg_all.png",
        filterIcon: "hiMedia/icon_filter.png",
        filterLableBg: "hiMedia/fileList_bak.png",
        filterIndicator: "hiMedia/triangle_indicator.png",
        sortIcon: "hiMedia/icon_arrange.png",
        sortLableBg: "hiMedia/fileList_bak.png",
        sortIndicator: "hiMedia/triangle_indicator.png",
        createListForAllTypeBak: UI.window_bg,
        fileBrowserGreen: "hiMedia/icon-green.png",
        fileBrowserBlue: "hiMedia/icon-blue.png",
        FBSearchInputImg: "hiMedia/input_line_N.png",
        FBSearchInputIcon: "hiMedia/icon-search-input.png",
        file_bottom_line: {"color": "0xFFFFFF", "alpha": "0.2"},
        fileSortContainerBg: "hiMedia/top_btn_3list.png",
        filterLableContainerBg: "hiMedia/top_btn_4list.png"


    };

    var template = Util.readJson("module/hiMedia/fileBrowser.json");
    var fileBrowser = SubModule.create(initData, template);
    //用于记录当前路径 leftover2:还未添加这部分返回优化
    fileBrowser.pathStack = [];
    //用于记录当前显示的文件内容，主要功能是实现返回时不需要查表数据了。
    fileBrowser.fileStack = [];
    //用于记录音频，视频，图片的栈
    fileBrowser.videoFileStack = [];
    fileBrowser.musicFileStack = [];
    fileBrowser.picFileStack = [];
    //用于记录焦点
    fileBrowser.focusStack = [];
    //用于记录当前排序类型
    //hiMedia.currentSortType = "time";
    //用于区分当前分类
    fileBrowser.currClassify = hiMedia.fileType.all;
    //用于记录当前焦点位置
    fileBrowser.currIndex = 0;
    //用于记录颜色键功能的是否可用的函数
    fileBrowser.greenEnable = true;
    fileBrowser.yellowEnable = false;
    fileBrowser.blueEnable = 1;
    //用于区分列表和非列表模式
    fileBrowser.listMode = false;
    //用于储存选择的内容
    fileBrowser.selectContent = [];
    //用于记录当前USB的ID
    fileBrowser.currentUsbId = "";
    //用于记录切换时的LIST的位置
    fileBrowser.storeIndex = 0;
    //thumbnail标志位
    fileBrowser.startPicThumbnail = false;
    fileBrowser.startMusicThumbnail = false;
    fileBrowser.startVideoThumbnail = false;
    //search 退出后标志
    fileBrowser.exitSearch = false;
    // file type filter widge
    var filterLableContainer = UI.getItem(fileBrowser, "filterLableContainer");
    var filterLable = UI.getItem(fileBrowser, "filterLable");
    var filterList = UI.getItem(fileBrowser, "filterList");
    filterList.visible = false;
    var filterLableBg = UI.getItem(fileBrowser, "filterLableBg");
    // sort type widge
    var sortLableContainer = UI.getItem(fileBrowser, "sortLableContainer");
    var sortLable = UI.getItem(fileBrowser, "sortLable");
    var sortTypeList = UI.getItem(fileBrowser, "sortTypeList");
    sortTypeList.visible = false;
    var sortLableBg = UI.getItem(fileBrowser, "sortLableBg");
    // choose list for creating list in all type
    var createListForAllType = UI.getItem(fileBrowser, "createListForAllType");
    var createListContainer = UI.getItem(fileBrowser, "createListContainer");
    var thumbNailCount = 0;//一次获取的计数器
    var deleteThumbNailCount = 0;//总共获取的计数器
    var thumbNailArray = [];//一次获取的容器
    var totalThumbNailArray = [];//总共获取的容器
    createListForAllType.visible = false;
    // record the search mode;
    fileBrowser.searchMode = false;

    var fileBrowserBG = UI.getItem(fileBrowser, "fileBrowserBG");
    var fileBrowserListContainer = UI.getItem(fileBrowser, "fileBrowserListContainer");
    var fileBrowserList = UI.getItem(fileBrowser, "fileBrowserList");
    var filePath = UI.getItem(fileBrowser, "filePath");
    var deviceName = UI.getItem(fileBrowser, "deviceName");
    var classifyName = ["all", "photo", "video", "music"];
    var fileBrowserData = [];
    var noNeedDelete = false;
    var fromKeyboard = false;
    if (!Config.tv) {
        fileBrowserData = [
            {deviceId: "id", filePath: "usbid", fileName: "VideoForder", fileType: "file", fileSelect: 1},
            {deviceId: "id", filePath: "usbid", fileName: "DMS.mp3", fileType: "music", fileSelect: 1},
            {deviceId: "id", filePath: "usbid", fileName: "DLNA_DEVICES.jpg", fileType: "pic", fileSelect: 1},
            {deviceId: "id", filePath: "usbid", fileName: "Dropbox.mp4", fileType: "video", fileSelect: 1},
            {deviceId: "id", filePath: "usbid", fileName: "someone else.mp3", fileType: "music", fileSelect: 1},
            {deviceId: "id", filePath: "usbid", fileName: "photo_p.png", fileType: "pic", fileSelect: 1},
            {deviceId: "id", filePath: "usbid", fileName: "photo_p.png", fileType: "pic", fileSelect: 1},
            {deviceId: "id", filePath: "usbid", fileName: "Dropbox.mp4", fileType: "video", fileSelect: 1},
            {deviceId: "id", filePath: "usbid", fileName: "someone else.mp3", fileType: "music", fileSelect: 1},
            {deviceId: "id", filePath: "usbid", fileName: "photo_p.png", fileType: "pic", fileSelect: 1},
            {deviceId: "id", filePath: "usbid", fileName: "photo_p.png", fileType: "pic", fileSelect: 1}

        ];
    } else {
        //调用搜索USB设备接口
        fileBrowserData = hiMedia.fileBrowserAllData;

    }


    //定义一个公用的创建list的函数,方便切换时使用。
    fileBrowser.createFileList = function (fData, needReset, focusIndex, viewHight) {
        var h = 700;
        if (!!viewHight) {
            h = viewHight;
        }
        //把初始化的数据挂在fileBrowser下
        fileBrowser.fileBrowserData = fData;
        var array = [];
        DBG_INFO("[createFileList] fData.length=" + fData.length);

        fileBrowser.resetWidges();

        if (fData.length > 0) {
            for (var i = 0; i < fData.length; i++) {
                var data = {
                    fileBrowserListItemName: fData[i].fileName,
                    //fileBrowserListItemBack: "hiMedia/fileList_bak.png",
                    fileBrowserListItemSelect: "setting/" + GLOBAL.LAUNCHER_BRAND + "/checkbox01.png",
                    fileBrowserListItemIcon: "hiMedia/file_type_icon_" + fData[i].fileType + ".png",
                    filePath: fData[i].filePath,
                    fileType: fData[i].fileType

                };
                if (data.fileType == "file") {
                    data.fileBrowserListItemSelect = null;
                    switch (fileBrowser.currClassify) {
                        case hiMedia.fileType.all:
                            data.fileBrowserListItemIcon = "hiMedia/ic_card_folder_all.png"
                            break;
                        case hiMedia.fileType.pic:
                            data.fileBrowserListItemIcon = "hiMedia/ic_card_folder_pic.png"
                            break;
                        case hiMedia.fileType.music:
                            data.fileBrowserListItemIcon = "hiMedia/ic_card_folder_music.png"
                            break;
                        case hiMedia.fileType.video:
                            data.fileBrowserListItemIcon = "hiMedia/ic_card_folder_video.png"
                            break;
                        default:
                            data.fileBrowserListItemIcon = "hiMedia/ic_card_folder_all.png"
                            break;
                    }
                } else {
                    if (fileBrowser.listMode) {
                        if (fData[i].fileSelect) {
                            data.fileBrowserListItemSelect = "setting/" + GLOBAL.LAUNCHER_BRAND + "/checkbox01.png";
                        } else {
                            data.fileBrowserListItemSelect = "setting/" + GLOBAL.LAUNCHER_BRAND + "/checkbox02.png";
                        }
                    } else {
                        data.fileBrowserListItemSelect = null;
                    }
                    var tmpPath = hasThumbNail(data.filePath);
                    if (!!tmpPath && (tmpPath != "fail")) {
                        data.fileBrowserListItemIcon = tmpPath;
                    } else {
                        data.fileBrowserListItemIcon = "hiMedia/file_type_icon_" + fData[i].fileType + ".png"
                    }
                }
                array.push(data);
            }
            var info = {
                template: "hiMedia_fileBrowser_ListItem",
                direction: CONST.GIRD_DIRECTION.H,
                breakNum: 6,
                distanceX: 60,
                distanceY: 84,
                container: fileBrowserList
            };

            UI.resetViewPos(fileBrowserList);
            SavingGrid.create(array, info);

            //leftover : 这里需要计算一次焦点位置


//            DBG_INFO(fileBrowserList.children[0].id);
            if (!!focusIndex && focusIndex > 0 && focusIndex < fileBrowserList.children.length) {
                fileBrowser.currFocus = fileBrowserList.children[focusIndex];
            } else {
                fileBrowser.currFocus = fileBrowserList.children[0];
            }


            //UI.refreshView(fileBrowserList, UI.getCurrFocus());

            if (!needReset) {

                UI.setView(fileBrowserList, 1740, 636);
                UI.addMask(fileBrowserList, 1740, 636, 68, 40);
                UI.addScrollbar(fileBrowserList, 35);
            } else {
                try {
                    UI.removeView(fileBrowserList);
                    UI.removeMask(fileBrowserList);
                    UI.removeScrollbar(fileBrowserList);
                }
                catch (ex) {
                    DBG_ERROR(ex.message);
                }
                //UI.resetViewPos(fileBrowserList);
                UI.setView(fileBrowserList, 1740, 636);
                UI.addMask(fileBrowserList, 1740, 636, 68, 40);
                UI.addScrollbar(fileBrowserList, 35);

            }
//            UI.refreshView(fileBrowserList, UI.getCurrFocus());
            if(!!fileBrowser.exitSearch){
                UI.focusTo(FBSearchInput);
            }else{
                UI.focusTo(UI.getCurrFocus());
            }
        } else {
            DBG_INFO("[createFileList] fileData is null,show noFile tips");
            fileBrowser.setFBPage(0);

            fileBrowser.currFocus = fileBrowserList;
            try {
                UI.removeView(fileBrowserList);
                UI.removeMask(fileBrowserList);
                UI.removeScrollbar(fileBrowserList);
            }
            catch (ex) {
                DBG_ERROR(ex.message);
            }
            // set the default focus if no file
            UI.focusTo(filterLableContainer);

            //leftover:写提示文字。此文件夹内无指定内容
        }
//        if (!!setThumbnailTimer) {
//            clearTimeout(setThumbnailTimer);
//        }
        beginThumb();
        fileBrowser.changeDeviceName();


    };

    fileBrowser.changeDeviceName = function () {
        if (!!hiMedia.searchMode) {
            UI.setText(deviceName, "[SS0017]" + "\"" + hiMedia.deviceName + "\"");
        } else {
            UI.setText(deviceName, hiMedia.deviceName);
        }
    }
    // reset the widges in the FB
    fileBrowser.resetWidges = function () {
        DBG_INFO("fileBrowser.resetWidges");
        FBSearchInput.onNormal();
        filterLableContainer.onNormal();
        sortLableContainer.onNormal();
        if (filterList.visible) {
            filterList.visible = false;
            filterList.onNormal();
        }
        if (sortTypeList.visible) {
            sortTypeList.visible = false;
            sortTypeList.onNormal()
        }

    };

    //创建初始化list
    fileBrowser.initFileBrowser = function () {
        DBG_INFO("[initFileBrowser]" + hiMedia.needRefreshFB);
        if (hiMedia.needRefreshFB) {
            fileBrowserList.removeAllChildren(true);

            //重置fileBrowser的标志位
            fileBrowser.pathStack = [];
            fileBrowser.focusStack = [];
            fileBrowser.fileStack = [];
            fileBrowser.folderFileStack = [];
            fileBrowser.videoFileStack = [];
            fileBrowser.musicFileStack = [];
            fileBrowser.picFileStack = [];

            fileBrowser.changeClassify(0);
            //UI.setImage(UI.getItem(fileBrowser, "fileBrowserBG"), "hiMedia/bg_all.png");

            fileBrowser.currIndex = 0;
            fileBrowser.currentUsbId = hiMedia.curFilePath;

            if (Config.tv) {
                fileBrowserData = hiMedia.fileBrowserAllData;
            }
            fileBrowser.createFileList(fileBrowserData, true);
            fileBrowser.pathStack.push(hiMedia.curFilePath);

            fileBrowser.fileStack[hiMedia.curFilePath] = fileBrowser.fileBrowserData;
            fileBrowser.folderFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserFileData;
            fileBrowser.videoFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserVideoData;
            fileBrowser.musicFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserMusicData;
            fileBrowser.picFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserPicData;
            fileBrowser.setFBPath(hiMedia.curFilePath);

            //增加排序标志位用来判断上一级排序规则
            fileBrowser.needResort = false;


        }
        else {
            //返回时刷新机制
            beginThumb();
        }

    }

//    var fileThumbnail = UI.getItem(fileBrowser, "fileThumbnail");
    var deviceBrowser = UI.getSubModule("deviceBrowser");

    var FBSearchInput = UI.getItem(fileBrowser, "FBSearchInput");
    var FBSearchInputImg = UI.getItem(fileBrowser, "FBSearchInputImg");
    var FBSearchInputIcon = UI.getItem(fileBrowser, "FBSearchInputIcon");
    var FBSearchInputPlaceholder = UI.getItem(fileBrowser, "FBSearchInputPlaceholder");
    var FBSearch = UI.getItem(fileBrowser, "FBSearch");
    var FBSearchInputTip = UI.getItem(fileBrowser, "FBSearchInputTip");

    var fileBrowserGreen = UI.getItem(fileBrowser, "fileBrowserGreen");
    var fileBrowserBlue = UI.getItem(fileBrowser, "fileBrowserBlue");
    var fileBrowserTop = UI.getItem(fileBrowser, "fileBrowserTop");
    var fileBrowserListB = UI.getItem(fileBrowser, "fileBrowserListB");
    var filterLableContainerBg = UI.getItem(fileBrowser, "filterLableContainerBg");
    var fileSortContainerBg = UI.getItem(fileBrowser, "fileSortContainerBg");
    var tmpThumb = "";
    var textInfo = {
        initVal: "",
        maxLength: 18,
        maxWidth: 540,
        fontSize: 36,
        isPwd: false,
        color: 0xFFFFFF
    };
    TextBox.create(FBSearchInput, textInfo, onEditTextChanged);
    function onEditTextChanged(txt) {
        DBG_INFO("!!!!!!!!!!!!!!!!!!!" + txt.text + "!!!!!!");
        if (txt.text != "") {
            FBSearchInputPlaceholder.visible = false;
            var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
            if (currentSubModel == "fileBrowser") {
                FBSearchInput.inactive();
                fileBrowser.enableColorButton(false);
                fileBrowser.searchMode = true;
                hiMedia.searchMode = fileBrowser.searchMode;
                //UI.focusTo(FBSearchInput);
                FBSearchInput.onNormal();
                hiMedia.startLoading("showUsbDetail", 15);
                hiMedia.showUsbDetail(hiMedia.devicePath, hiMedia.devicePath + "/", txt.text);
            }
        } else {
        }
    }

    //退出搜索模式的后续处理代码
    function exitSearchMode() {
        DBG_INFO("exitSearchMode");
        FBSearchInputTip.alpha = 0;
        UI.setText(deviceName, hiMedia.deviceName);
        //fileBrowser.currClassify = hiMedia.fileType.all;
        fileBrowser.searchMode = false;
        hiMedia.searchMode = fileBrowser.searchMode;
        fileBrowser.enableColorButton(true, false, true);

        //createjs.Tween.removeTweens(fileBrowserList);
        //fileBrowserList.removeAllChildren(true);
        //fileBrowser.fileStack[hiMedia.curFilePath] = fileBrowser.fileBrowserData = hiMedia.fileBrowserAllData;
        //FBSearch.alpha = 0;
//        UI.setImage(UI.getItem(fileBrowser, "fileBrowserTypeImg" + fileBrowser.currClassify), "hiMedia/" + classifyName + "_focus.png");
//        UI.setImage(UI.getItem(fileBrowser, "fileBrowserTypeImg5"), "hiMedia/icon-search.png");
//        UI.setImage(UI.getItem(fileBrowser, "fileBrowserBG"), "hiMedia/bg_" + classifyName + ".png");
        //fileBrowser.changeClassify(fileBrowser.currClassify);
        //fileBrowser.initFileBrowser();

    }


    fileBrowser.onShow = function (from) {
        DBG_INFO("[fileBrowser onShow!]");
        //try {
        if (fileBrowser.searchMode) {
            return;
        }
        if (!fileBrowserList) {
            fileBrowserList = hiMedia.fileBrowserList;
        }
        fileBrowser.initFileBrowser();

        if (!!fileBrowser.listMode) {
            fileBrowser.existListMode();
        }
        else {
            //hiMedia.hideListData(fileBrowserList, 0, 8, "hide");
        }
//        }
//        catch (ex) {
//            DBG_ERROR("initFileBrowser error!!" + ex.message);
//        }

    }
    fileBrowser.onPush = function () {
        //处理图片缩略图的问题
        DBG_INFO("fileBrowser.onPush,hiMedia.currentDevice = " + hiMedia.currentDevice);
        UI.setText(deviceName, hiMedia.deviceName);
        FBSearchInputTip.alpha = 0;
        if (hiMedia.searchMode) {
            FBSearchInputPlaceholder.visible = false;
        } else {
            FBSearchInputPlaceholder.visible = true;
            FBSearchInput.setText("");
        }
        if (hiMedia.currentDevice == hiMedia.device.usb) {
            FBSearch.alpha = 1;
        } else {
            FBSearch.alpha = 0;
        }
        //sort and filter背景
        filterLableContainerBg.visible = false;
        fileSortContainerBg.visible = false;
        try {
            //      UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_STATE_CHANGED, fileBrowser.onFStateChanged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_DLNA_METADATA_CHANGED, fileBrowser.onMDChanged);

        } catch (ex) {
            DBG_ERROR("init thumbnail pic model error!!" + ex.message);
        }
        noNeedDelete = false;
        //if (hiMedia.currentSortType == "time") {
        //} else {
        //}

    }
    fileBrowser.afterPush = function () {
        DBG_INFO("[FileBrowser afterPush] hide deviceBrowser!");
        deviceBrowser.visible = false;
        hiMedia.devceBrowserEnable = false;
        if(fileBrowser.currClassify == hiMedia.fileType.all){
            UI.setImage(fileBrowserBG, "hiMedia/bg_all.png");
        }
    }
    fileBrowser.onPop = function () {
        DBG_ALWAYS("fileBrowser.onPop");
        try {
            if (!!setThumbnailTimer) {
                clearTimeout(setThumbnailTimer);
                setThumbnailTimer = null;
            }
            model.mpctrl.MpCtrl(3);
//            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_STATE_CHANGED, fileBrowser.onFStateChanged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_DLNA_METADATA_CHANGED, fileBrowser.onMDChanged);
            if(!!noNeedDelete){
                noNeedDelete=false;
            }else{
                deleteThumbNail(true);
            }
        } catch (ex) {
            DBG_ERROR("deInit thumbnail pic model error!!" + ex.message);
        }
        hiMedia.endLoading("onPopFileBowser");
        if (fileBrowser.searchMode) {
            FBSearchInput.onNormal();
            return;
            //exitSearchMode();
            /*
             if (!hiMedia.playerToSearch) {
             fileBrowser.currClassify = hiMedia.fileType.all;
             //fileBrowserListContainer.y = 204;
             //fileBrowser.changeClassify(0);
             //UI.setImage(UI.getItem(fileBrowser, "fileBrowserTypeImg5"), "hiMedia/icon-search.png");
             } else {
             hiMedia.playerToSearch = false;
             }
             */
        }
        if (fileBrowser.listMode) {
            fileBrowser.existListMode();
        }
//        try {
//            if (!!setThumbnailTimer) {
//                clearTimeout(setThumbnailTimer);
//                setThumbnailTimer = null;
//            }
//            model.picture.stopThumbnail();
//            //退出文件浏览器时重置一下缩略图
//            UI.setImage(fileThumbnail, "hiMedia/preImg_file.png");
//        } catch (ex) {
//            DBG_ERROR("deInit thumbnail pic model error!!" + ex.message);
//        }
    }
    fileBrowser.onkey_BACKSPACE = function () {
        fileBrowser.startPicThumbnail = false;
        fileBrowser.startMusicThumbnail = false;
        fileBrowser.startVideoThumbnail = false;
        if (fileBrowser.listMode) {
            fileBrowser.allPic[0].fileSelect = 1;
            fileBrowser.allMusic[0].fileSelect = 1;
            fileBrowser.allVideo[0].fileSelect = 1;
            if (fileBrowser.pathStack.length <= 1) {
                fileBrowser.existListMode();
            } else {
                // change path
                try {
                    hiMedia.startLoading("list mode, FB back", 15);
                    fileBrowser.pathStack.pop();

                    hiMedia.curFilePath = fileBrowser.pathStack[fileBrowser.pathStack.length - 1];

                    hiMedia.fileBrowserPicData = fileBrowser.picFileStack[hiMedia.curFilePath] ?
                        fileBrowser.picFileStack[hiMedia.curFilePath] : [];
                    hiMedia.fileBrowserVideoData = fileBrowser.videoFileStack[hiMedia.curFilePath] ?
                        fileBrowser.videoFileStack[hiMedia.curFilePath] : [];
                    hiMedia.fileBrowserMusicData = fileBrowser.musicFileStack[hiMedia.curFilePath] ?
                        fileBrowser.musicFileStack[hiMedia.curFilePath] : [];
                    hiMedia.fileBrowserFileData = fileBrowser.folderFileStack[hiMedia.curFilePath] ?
                        fileBrowser.folderFileStack[hiMedia.curFilePath] : [];
                    fileBrowser.setFBPath(hiMedia.curFilePath);

                    // when sort type change, look for the re-sorted item focus.
                    var focus = fileBrowser.focusStack[fileBrowser.focusStack.length - 1];
                    var focusItem = hiMedia.fileBrowserFileData[focus];
                    fileBrowser.focusStack.pop();
                    DBG_INFO("List mode, Current Path is :" + hiMedia.curFilePath + "   current focus is :" + focus);
                    if (hiMedia.currentSortType == "name") {
                        try {
                            hiMedia.fileBrowserFileData = sortContent(hiMedia.fileBrowserFileData, "name");
                            hiMedia.fileBrowserPicData = sortContent(hiMedia.fileBrowserPicData, "name");
                            hiMedia.fileBrowserMusicData = sortContent(hiMedia.fileBrowserMusicData, "name");
                            hiMedia.fileBrowserVideoData = sortContent(hiMedia.fileBrowserVideoData, "name");
                        }
                        catch (ex) {
                            DBG_ERROR(ex.message);
                        }

                    } else if (hiMedia.currentSortType == "time") {
                        try {
                            hiMedia.fileBrowserFileData = sortContent(hiMedia.fileBrowserFileData, "time");
                            hiMedia.fileBrowserPicData = sortContent(hiMedia.fileBrowserPicData, "time");
                            hiMedia.fileBrowserMusicData = sortContent(hiMedia.fileBrowserMusicData, "time");
                            hiMedia.fileBrowserVideoData = sortContent(hiMedia.fileBrowserVideoData, "time");
                        }
                        catch (ex) {
                            DBG_ERROR(ex.message);
                        }
                    } else if (hiMedia.currentSortType == "size") {
                        try {
                            //file类型的size 大小无法获取，所以返回时默认按照name排序。
                            hiMedia.fileBrowserFileData = sortContent(hiMedia.fileBrowserFileData, "name");
                            hiMedia.fileBrowserPicData = sortContent(hiMedia.fileBrowserPicData, "size");
                            hiMedia.fileBrowserMusicData = sortContent(hiMedia.fileBrowserMusicData, "size");
                            hiMedia.fileBrowserVideoData = sortContent(hiMedia.fileBrowserVideoData, "size");
                        }
                        catch (ex) {
                            DBG_ERROR(ex.message);
                        }
                    }
                    focus = hiMedia.fileBrowserFileData.indexOf(focusItem);

                    hiMedia.fileBrowserAllData = hiMedia.fileBrowserFileData.
                        concat(hiMedia.fileBrowserVideoData).
                        concat(hiMedia.fileBrowserMusicData).
                        concat(hiMedia.fileBrowserPicData);
                    switch (fileBrowser.currClassify) {
                        case hiMedia.fileType.all:
                            // not support in list mode.
                            break;
                        case hiMedia.fileType.pic:
                            for (var i = 0; i < hiMedia.fileBrowserPicData.length; i++) {
                                if (hiMedia.fileBrowserPicData[i].fileSelect == 0) {
                                    fileBrowser.allPic[0].fileSelect = 0;
                                }
                            }
                            if (hiMedia.fileBrowserPicData.length == 0) {
                                fileBrowser.allPic[0].fileSelect = 1;
                            }
                            fileBrowser.fileBrowserData = fileBrowser.allPic
                                .concat(hiMedia.fileBrowserFileData)
                                .concat(hiMedia.fileBrowserPicData);
                            break;
                        case hiMedia.fileType.music:
                            for (var i = 0; i < hiMedia.fileBrowserMusicData.length; i++) {
                                if (hiMedia.fileBrowserMusicData[i].fileSelect == 0) {
                                    fileBrowser.allMusic[0].fileSelect = 0;
                                }
                            }
                            if (hiMedia.fileBrowserMusicData.length == 0) {
                                fileBrowser.allMusic[0].fileSelect = 1;
                            }
                            fileBrowser.fileBrowserData = fileBrowser.allMusic
                                .concat(hiMedia.fileBrowserFileData)
                                .concat(hiMedia.fileBrowserMusicData);
                            break;
                        case hiMedia.fileType.video:
                            for (var i = 0; i < hiMedia.fileBrowserVideoData.length; i++) {
                                if (hiMedia.fileBrowserVideoData[i].fileSelect == 0) {
                                    fileBrowser.allVideo[0].fileSelect = 0;
                                }
                            }
                            if (hiMedia.fileBrowserVideoData.length == 0) {
                                fileBrowser.allVideo[0].fileSelect = 1;
                            }
                            fileBrowser.fileBrowserData = fileBrowser.allVideo
                                .concat(hiMedia.fileBrowserFileData)
                                .concat(hiMedia.fileBrowserVideoData);
                            break;
                        default :
                            break;
                    }
                    // fileBrowser.fileBrowserData = fileBrowser.fileStack[hiMedia.curFilePath];

                    createjs.Tween.removeTweens(fileBrowserList);
                    fileBrowserList.removeAllChildren(true);

                    // because the first item is a all selected item, so focus plus 1.
                    fileBrowser.createFileList(fileBrowser.fileBrowserData, true, focus + 1);


                    hiMedia.endLoading("FB back");
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            }
        } else {
            if (fileBrowser.searchMode) {
                exitSearchMode();
                DBG_INFO("exit search mode, Current Path is :" + hiMedia.curFilePath);
                if (hiMedia.currentSortType == "name") {
                    try {
                        hiMedia.fileBrowserFileData = sortContent(hiMedia.fileBrowserFileData, "name");
                        hiMedia.fileBrowserPicData = sortContent(hiMedia.fileBrowserPicData, "name");
                        hiMedia.fileBrowserMusicData = sortContent(hiMedia.fileBrowserMusicData, "name");
                        hiMedia.fileBrowserVideoData = sortContent(hiMedia.fileBrowserVideoData, "name");
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                } else if (hiMedia.currentSortType == "time") {
                    try {
                        hiMedia.fileBrowserFileData = sortContent(hiMedia.fileBrowserFileData, "time");
                        hiMedia.fileBrowserPicData = sortContent(hiMedia.fileBrowserPicData, "time");
                        hiMedia.fileBrowserMusicData = sortContent(hiMedia.fileBrowserMusicData, "time");
                        hiMedia.fileBrowserVideoData = sortContent(hiMedia.fileBrowserVideoData, "time");
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                } else if (hiMedia.currentSortType == "size") {
                    try {
                        //file类型的size 大小无法获取，所以返回时默认按照name排序。
                        hiMedia.fileBrowserFileData = sortContent(hiMedia.fileBrowserFileData, "name");
                        hiMedia.fileBrowserPicData = sortContent(hiMedia.fileBrowserPicData, "size");
                        hiMedia.fileBrowserMusicData = sortContent(hiMedia.fileBrowserMusicData, "size");
                        hiMedia.fileBrowserVideoData = sortContent(hiMedia.fileBrowserVideoData, "size");
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                }
                hiMedia.fileBrowserAllData = hiMedia.fileBrowserFileData
                    .concat(hiMedia.fileBrowserVideoData)
                    .concat(hiMedia.fileBrowserMusicData)
                    .concat(hiMedia.fileBrowserPicData);
                switch (fileBrowser.currClassify) {
                    case hiMedia.fileType.all:
                        fileBrowser.fileBrowserData = hiMedia.fileBrowserAllData;
                        break;
                    case hiMedia.fileType.pic:
                        fileBrowser.fileBrowserData = hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserPicData);
                        break;
                    case hiMedia.fileType.music:
                        fileBrowser.fileBrowserData = hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserMusicData);
                        break;
                    case hiMedia.fileType.video:
                        fileBrowser.fileBrowserData = hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserVideoData);
                        break;
                    default :
                        break;
                }
                createjs.Tween.removeTweens(fileBrowserList);
                fileBrowserList.removeAllChildren(true);
                fileBrowser.createFileList(fileBrowser.fileBrowserData, true, focus);
                if (fileBrowser.fileBrowserData == 0) {
                    UI.focusTo(FBSearchInput);
                } else {
                    FBSearchInput.onNormal();
                }
                hiMedia.endLoading("search mode, FB back");
            } else {
                if (fileBrowser.pathStack.length <= 1) {
                    deviceBrowser.visible = true;
                    hiMedia.devceBrowserEnable = true;

                    // reset the related value of file filter.
                    UI.setImage(filterLableBg, "hiMedia/fileList_bak.png");
                    UI.setText(filterLable, fileTypeArray[0]);
                    fileBrowser.currClassify = hiMedia.fileType.all;
                    if (filterList.visible) {
                        filterList.visible = false;
                    }

                    // reset the related value of sort type.
                    UI.setImage(sortLableBg, "hiMedia/fileList_bak.png");
                    UI.setText(sortLable, sortTypeArray[0]);
                    hiMedia.currentSortType = "name";
                    if (sortTypeList.visible) {
                        sortTypeList.visible = false;
                    }

                    UI.popSubModule();
                    //leftover1：在文件浏览时拔出非当前U盘时，需要特殊处理：加标志位，推到设备页面后再刷新？
                    fileBrowser.currFocus = deviceBrowser.lastFocus;
                    UI.focusTo(UI.getCurrFocus());
                } else {
                    //更换一次当前路径和内容
                    try {
                        hiMedia.startLoading("FB back", 15);
                        fileBrowser.pathStack.pop();


                        hiMedia.curFilePath = fileBrowser.pathStack[fileBrowser.pathStack.length - 1];

                        hiMedia.fileBrowserPicData = fileBrowser.picFileStack[hiMedia.curFilePath] ? fileBrowser.picFileStack[hiMedia.curFilePath] : [];
                        hiMedia.fileBrowserVideoData = fileBrowser.videoFileStack[hiMedia.curFilePath] ? fileBrowser.videoFileStack[hiMedia.curFilePath] : [];
                        hiMedia.fileBrowserMusicData = fileBrowser.musicFileStack[hiMedia.curFilePath] ? fileBrowser.musicFileStack[hiMedia.curFilePath] : [];
                        hiMedia.fileBrowserFileData = fileBrowser.folderFileStack[hiMedia.curFilePath] ? fileBrowser.folderFileStack[hiMedia.curFilePath] : [];
                        fileBrowser.setFBPath(hiMedia.curFilePath);
                        //返回时的焦点计算方法，因为进入时记录焦点统一都是按照时间排序后记录，
                        //所以每次返回算焦点时先把文件夹按时间排序，然后获取到具体的焦点元素，再做一次当前排序
                        var focus = fileBrowser.focusStack[fileBrowser.focusStack.length - 1];
                        fileBrowser.focusStack.pop();
                        DBG_INFO("Current Path is :" + hiMedia.curFilePath + "   current focus is :" + focus);
                        if (hiMedia.currentSortType == "name") {
                            try {
                                hiMedia.fileBrowserFileData = sortContent(hiMedia.fileBrowserFileData, "name");
                                hiMedia.fileBrowserPicData = sortContent(hiMedia.fileBrowserPicData, "name");
                                hiMedia.fileBrowserMusicData = sortContent(hiMedia.fileBrowserMusicData, "name");
                                hiMedia.fileBrowserVideoData = sortContent(hiMedia.fileBrowserVideoData, "name");
                            }
                            catch (ex) {
                                DBG_ERROR(ex.message);
                            }

                        } else if (hiMedia.currentSortType == "time") {
                            //重算一次焦点
                            if (focus >= 0 && focus < hiMedia.fileBrowserFileData.length) {
                                hiMedia.fileBrowserFileData = sortContent(hiMedia.fileBrowserFileData, "name");
                                var focusItem = hiMedia.fileBrowserFileData[focus];
                                hiMedia.fileBrowserFileData = sortContent(hiMedia.fileBrowserFileData, "time");
                                focus = hiMedia.fileBrowserFileData.indexOf(focusItem);
                                DBG_INFO("   current refocus is :" + focus);
                            }
                            try {
                                hiMedia.fileBrowserPicData = sortContent(hiMedia.fileBrowserPicData, "time");
                                hiMedia.fileBrowserMusicData = sortContent(hiMedia.fileBrowserMusicData, "time");
                                hiMedia.fileBrowserVideoData = sortContent(hiMedia.fileBrowserVideoData, "time");
                            }
                            catch (ex) {
                                DBG_ERROR(ex.message);
                            }
                        } else if (hiMedia.currentSortType == "size") {
                            //重算一次焦点
                            if (focus >= 0 && focus < hiMedia.fileBrowserFileData.length) {
                                //file类型的size 大小无法获取，所以返回时默认按照name排序。
                                hiMedia.fileBrowserFileData = sortContent(hiMedia.fileBrowserFileData, "name");
                                var focusItem = hiMedia.fileBrowserFileData[focus];
                                focus = hiMedia.fileBrowserFileData.indexOf(focusItem);
                                DBG_INFO("   current refocus is :" + focus);
                            }
                            try {
                                hiMedia.fileBrowserPicData = sortContent(hiMedia.fileBrowserPicData, "size");
                                hiMedia.fileBrowserMusicData = sortContent(hiMedia.fileBrowserMusicData, "size");
                                hiMedia.fileBrowserVideoData = sortContent(hiMedia.fileBrowserVideoData, "size");
                            }
                            catch (ex) {
                                DBG_ERROR(ex.message);
                            }
                        }
                        hiMedia.fileBrowserAllData = hiMedia.fileBrowserFileData.
                            concat(hiMedia.fileBrowserVideoData).
                            concat(hiMedia.fileBrowserMusicData).
                            concat(hiMedia.fileBrowserPicData);
                        switch (fileBrowser.currClassify) {
                            case hiMedia.fileType.all:
                                fileBrowser.fileBrowserData = fileBrowser.fileStack[hiMedia.curFilePath] = hiMedia.fileBrowserAllData;
                                break;
                            case hiMedia.fileType.pic:
                                fileBrowser.fileBrowserData = fileBrowser.fileStack[hiMedia.curFilePath] = hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserPicData);
                                break;
                            case hiMedia.fileType.music:
                                fileBrowser.fileBrowserData = fileBrowser.fileStack[hiMedia.curFilePath] = hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserMusicData);
                                break;
                            case hiMedia.fileType.video:
                                fileBrowser.fileBrowserData = fileBrowser.fileStack[hiMedia.curFilePath] = hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserVideoData);
                                break;
                            default :
                                break;
                        }
                        // fileBrowser.fileBrowserData = fileBrowser.fileStack[hiMedia.curFilePath];

                        createjs.Tween.removeTweens(fileBrowserList);
                        fileBrowserList.removeAllChildren(true);


                        fileBrowser.createFileList(fileBrowser.fileBrowserData, true, focus);


                        hiMedia.endLoading("FB back");
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                }
            }
        }

    };
    fileBrowser.onkey_ENTER = function () {
        if (fileBrowser.fileBrowserData.length < 1) {
            DBG_ERROR("No file now,return!");
            return false;
        }
        var currentIndex = fileBrowserList.initSequence.indexOf(UI.getCurrFocus());
        //DBG_INFO("currentIndex:" + currentIndex);
        hiMedia.fileBrowserList = fileBrowserList;
        DBG_INFO("data = " + objToString(fileBrowser.fileBrowserData[currentIndex]));
        var currentType = fileBrowser.fileBrowserData[currentIndex].fileType;
        var currentPath = fileBrowser.fileBrowserData[currentIndex].filePath;
        var currentId = fileBrowser.fileBrowserData[currentIndex].deviceId;

        DBG_INFO("currentId:" + currentId + "    currentPath:" + currentPath);
        if (!fileBrowser.listMode) {
            if (!fileBrowser.searchMode) {
                switch (currentType) {
                    case "pic":
                        try {
                            noNeedDelete = true;
                            UI.popSubModule();
                            //初始化时清空一下公共变量
                            hiMedia.initPicList = [];
                            hiMedia.initPicIndex = 0;
                            for (var j = 0; j < fileBrowser.picFileStack[hiMedia.curFilePath].length; j++) {
                                //pic不需要加前缀

                                hiMedia.initPicList.push({
                                    "picUrl": fileBrowser.picFileStack[hiMedia.curFilePath][j].filePath,
                                    "picName": fileBrowser.picFileStack[hiMedia.curFilePath][j].fileName,
                                    "picTime": fileBrowser.picFileStack[hiMedia.curFilePath][j].fileTime,
                                    "picExifRotate": 3
                                });

                                if (fileBrowser.picFileStack[hiMedia.curFilePath][j].filePath == fileBrowser.fileBrowserData[fileBrowser.currIndex].filePath) {
                                    hiMedia.initPicIndex = j;
                                }
                            }
                            UI.lockAllKeys("playPic");
                            UI.pushSubModule("hiMedia", "picPlayer", true);
                        }
                        catch (ex) {
                            DBG_ERROR("playPic Error:" + ex.message);
                        }
                        break;
                    case "music":
                        try {
                            noNeedDelete = true;
                            UI.popSubModule();
                            //初始化时清空一下公共变量
                            hiMedia.initMusicList = [];
                            hiMedia.initMusicIndex = 0;
                            for (var j = 0; j < fileBrowser.musicFileStack[hiMedia.curFilePath].length; j++) {
                                //需要区分本地视频和网络视频
                                if (hiMedia.currentDevice == hiMedia.device.usb || hiMedia.currentDevice == hiMedia.device.pvr) {
                                    hiMedia.initMusicList.push({
                                        "musicUrl": fileBrowser.musicFileStack[hiMedia.curFilePath][j].filePath,
                                        "musicName": fileBrowser.musicFileStack[hiMedia.curFilePath][j].fileName
                                    });
                                }
                                else {
                                    hiMedia.initMusicList.push({
                                        "musicUrl": fileBrowser.musicFileStack[hiMedia.curFilePath][j].filePath,
                                        "musicName": fileBrowser.musicFileStack[hiMedia.curFilePath][j].fileName
                                    });
                                }
                                if (fileBrowser.musicFileStack[hiMedia.curFilePath][j].filePath == fileBrowser.fileBrowserData[fileBrowser.currIndex].filePath) {
                                    hiMedia.initMusicIndex = j;
                                }
                            }

                            UI.lockAllKeys("playMusic");
                            UI.pushSubModule("hiMedia", "musicPlayer", true);
                        }
                        catch (ex) {
                            DBG_ERROR("playMusic Error:" + ex.message);
                        }
                        break;
                    case "video":
                        try {
                            noNeedDelete = true;
                            UI.popSubModule();
                            //初始化时清空一下公共变量
                            hiMedia.initVideoList = [];
                            hiMedia.initVideoIndex = 0;
                            DBG_INFO("fileBrowser.videoFileStack   :  " + fileBrowser.videoFileStack.length + " hiMedia.curFilePath: " + hiMedia.curFilePath);
                            for (var j = 0; j < fileBrowser.videoFileStack[hiMedia.curFilePath].length; j++) {
                                //需要区分本地视频和网络视频(需要改为stack的形式)
                                if (hiMedia.currentDevice == hiMedia.device.usb || hiMedia.currentDevice == hiMedia.device.pvr) {
                                    hiMedia.initVideoList.push({
                                        "videoUrl": fileBrowser.videoFileStack[hiMedia.curFilePath][j].filePath,
                                        "videoName": fileBrowser.videoFileStack[hiMedia.curFilePath][j].fileName
                                    });
                                }
                                else {
                                    hiMedia.initVideoList.push({
                                        "videoUrl": fileBrowser.videoFileStack[hiMedia.curFilePath][j].filePath,
                                        "videoName": fileBrowser.videoFileStack[hiMedia.curFilePath][j].fileName
                                    });
                                }
                                if (fileBrowser.videoFileStack[hiMedia.curFilePath][j].filePath == fileBrowser.fileBrowserData[fileBrowser.currIndex].filePath) {
                                    hiMedia.initVideoIndex = j;
                                }
                            }
                            UI.lockAllKeys("playVideo");
                            UI.pushSubModule("hiMedia", "videoPlayer", true);
                        }
                        catch (ex) {
                            DBG_ERROR("playVideo Error:" + ex.message);
                        }
                        break;

                    case "file":
                        if (hiMedia.currentSortType == "time") {
                            try {
                                var tempFdata = sortContent(hiMedia.fileBrowserFileData, "name");
                                var tmpFocus = tempFdata.indexOf(fileBrowser.fileBrowserData[currentIndex]);
                                if (tmpFocus != -1) {
                                    currentIndex = tmpFocus;
                                }
                                DBG_INFO("need resort data and currentIndex = " + currentIndex);
                                fileBrowser.needResort = true;
                            } catch (ex) {
                                DBG_ERROR(ex.message);
                            }
                        } else if (hiMedia.currentSortType == "size") {
                            try {
                                var tempFdata = sortContent(hiMedia.fileBrowserFileData, "name");
                                var tmpFocus = tempFdata.indexOf(fileBrowser.fileBrowserData[currentIndex]);
                                if (tmpFocus != -1) {
                                    currentIndex = tmpFocus;
                                }
                                DBG_INFO("need resort data and currentIndex = " + currentIndex);
                                fileBrowser.needResort = true;
                            } catch (ex) {
                                DBG_ERROR(ex.message);
                            }
                        } else {
                            fileBrowser.needResort = false;
                        }
                        DBG_INFO("store focus is :" + currentIndex);
                        fileBrowser.focusStack.push(currentIndex);
                        if (!Config.tv) {
                            createjs.Tween.removeTweens(fileBrowserList);

                            fileBrowserList.removeAllChildren(true);
                            fileBrowser.createFileList([
                                {filePath: "usbid", fileName: "TEST_BACK", fileType: "file"},
                                {filePath: "usbid", fileName: "TEST_ENTER.mp3", fileType: "music"}
                            ], true);
                            //DBG_INFO("pathStack.push"+hiMedia.curFilePath+"Current is "+fileBrowser.pathStack);
                            fileBrowser.pathStack.push(hiMedia.curFilePath);

                            fileBrowser.fileStack[hiMedia.curFilePath] = fileBrowser.fileBrowserData;
                            fileBrowser.folderFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserFileData;
                            fileBrowser.videoFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserVideoData;
                            fileBrowser.musicFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserMusicData;
                            fileBrowser.picFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserPicData;

                        } else {

                            try {
                                if (hiMedia.currentDevice == hiMedia.device.usb) {

                                    hiMedia.showUsbDetail(currentId, currentPath, null);
                                } else if (hiMedia.currentDevice == hiMedia.device.dms) {
                                    hiMedia.showDmpDetail(currentId, currentPath, 92, false);
                                }
//                                hiMedia.currentSortType = "time";
//                                UI.setText(fileBrowserSortType, "[DMP0154]");
                                //转移到showdmp之后处理
//                        DBG_INFO("pathStack.push" + hiMedia.curFilePath + "Current is " + fileBrowser.pathStack);
//                        fileBrowser.pathStack.push(hiMedia.curFilePath);
//                        fileBrowser.fileStack[hiMedia.curFilePath] = fileBrowser.fileBrowserData;

                            } catch (ex) {
                                DBG_ERROR("Open Usb error:" + ex.message);
                            }
                        }
                        break;

                    default :
                        break;
                }
            } else {
                //搜索时的播放更改标志位
                //hiMedia.playerToSearch = true;
                switch (currentType) {
                    case "pic":
                        try {
                            UI.popSubModule();
                            //初始化时清空一下公共变量
                            hiMedia.initPicList = [];
                            hiMedia.initPicIndex = 0;
                            //pic不需要加前缀
                            hiMedia.initPicList.push({
                                "picUrl": fileBrowser.fileBrowserData[fileBrowser.currIndex].filePath,
                                "picName": fileBrowser.fileBrowserData[fileBrowser.currIndex].fileName,
                                "picTime": fileBrowser.fileBrowserData[fileBrowser.currIndex].fileTime,
                                "picExifRotate": 3
                            });
                            UI.pushSubModule("hiMedia", "picPlayer", true);
                        }
                        catch (ex) {
                            DBG_ERROR("playPic Error:" + ex.message);
                        }
                        break;
                    case "music":
                        try {
                            UI.popSubModule();
                            //初始化时清空一下公共变量
                            hiMedia.initMusicList = [];
                            hiMedia.initMusicIndex = 0;
                            hiMedia.initMusicList.push({
                                "musicUrl": fileBrowser.fileBrowserData[fileBrowser.currIndex].filePath,
                                "musicName": fileBrowser.fileBrowserData[fileBrowser.currIndex].fileName
                            });
                            UI.pushSubModule("hiMedia", "musicPlayer", true);
                        }
                        catch (ex) {
                            DBG_ERROR("playMusic Error:" + ex.message);
                        }
                        break;
                    case "video":
                        try {
                            UI.popSubModule();
                            //初始化时清空一下公共变量
                            hiMedia.initVideoList = [];
                            hiMedia.initVideoIndex = 0;
                            hiMedia.initVideoList.push({
                                "videoUrl": fileBrowser.fileBrowserData[fileBrowser.currIndex].filePath,
                                "videoName": fileBrowser.fileBrowserData[fileBrowser.currIndex].fileName
                            });
                            UI.pushSubModule("hiMedia", "videoPlayer", true);
                        }
                        catch (ex) {
                            DBG_ERROR("playVideo Error:" + ex.message);
                        }
                        break;
                    default :
                        break;
                }
            }
        } else {
            switch (currentType) {
                case "allPic":
                case "allMusic":
                case "allVideo":
                    DBG_INFO("fileBrowser.onkey_ENTER, fileBrowserData[0].fileSelect:" + fileBrowser.fileBrowserData[0].fileSelect);
                    if (fileBrowser.fileBrowserData[0].fileSelect == 1) {
                        fileBrowser.fileBrowserData[0].fileSelect = 0;
                        UI.setImage(fileBrowserList.initSequence[0].children[3], "setting/" + GLOBAL.LAUNCHER_BRAND + "/checkbox02.png");
                    } else {
                        fileBrowser.fileBrowserData[0].fileSelect = 1;
                        UI.setImage(fileBrowserList.initSequence[0].children[3], "setting/" + GLOBAL.LAUNCHER_BRAND + "/checkbox01.png");
                    }
                    var mediaData = [];
                    if (currentType == "allPic") {
                        mediaData = fileBrowser.picFileStack[hiMedia.curFilePath];
                    } else if (currentType == "allMusic") {
                        mediaData = fileBrowser.musicFileStack[hiMedia.curFilePath];
                    } else if (currentType == "allVideo") {
                        mediaData = fileBrowser.videoFileStack[hiMedia.curFilePath];
                    } else {
                        mediaData = [];
                        DBG_ERROR("list mode, fileBrowser.onkey_ENTER, error type: " + currentType);
                        return;
                    }
                    if (!!mediaData) {
                        if (fileBrowser.fileBrowserData[0].fileSelect == 1) {
                            for (var i = 0; i < mediaData.length; i++) {
                                mediaData[i].fileSelect = 1;
                                //selectedMedia[hiMedia.curFilePath][i] = 1;
                                UI.setImage(fileBrowserList
                                    .initSequence[1 + hiMedia.fileBrowserFileData.length + i]
                                    .children[3], "setting/" + GLOBAL.LAUNCHER_BRAND + "/checkbox01.png");
                            }
                        } else {
                            for (var i = 0; i < mediaData.length; i++) {
                                mediaData[i].fileSelect = 0;
                                //selectedMedia[hiMedia.curFilePath][i] = 0;
                                UI.setImage(fileBrowserList
                                    .initSequence[1 + hiMedia.fileBrowserFileData.length + i]
                                    .children[3], "setting/" + GLOBAL.LAUNCHER_BRAND + "/checkbox02.png");
                            }
                        }
                    } else {
                        DBG_ERROR("list mode, fileBrowser.onkey_ENTER, no media file");
                    }
                    break;
                case "pic":
                case "music":
                case "video":
                    var mediaData = [];
                    var headerItem = [];
                    if (currentType == "pic") {
                        mediaData = fileBrowser.picFileStack[hiMedia.curFilePath]
                        headerItem = fileBrowser.allPic;
                    } else if (currentType == "music") {
                        mediaData = fileBrowser.musicFileStack[hiMedia.curFilePath];
                        headerItem = fileBrowser.allMusic;
                    } else if (currentType == "video") {
                        mediaData = fileBrowser.videoFileStack[hiMedia.curFilePath];
                        headerItem = fileBrowser.allVideo;
                    }
                    if (!!mediaData) {
                        if (fileBrowser.fileBrowserData[currentIndex].fileSelect == 1) {
                            mediaData[currentIndex - 1 - hiMedia.fileBrowserFileData.length].fileSelect = 0;
                            UI.setImage(fileBrowserList.initSequence[currentIndex].children[3], "setting/" + GLOBAL.LAUNCHER_BRAND + "/checkbox02.png");
                        } else {
                            mediaData[currentIndex - 1 - hiMedia.fileBrowserFileData.length].fileSelect = 1;
                            UI.setImage(fileBrowserList.initSequence[currentIndex].children[3], "setting/" + GLOBAL.LAUNCHER_BRAND + "/checkbox01.png");
                        }

                        var allSelected = true;
                        for (var i = 0; i < mediaData.length; i++) {
                            if (mediaData[i].fileSelect == 0) {
                                allSelected = false;
                            }
                        }

                        if (allSelected) {
                            headerItem[0].fileSelect = 1;
                            UI.setImage(fileBrowserList.initSequence[0].children[3], "setting/" + GLOBAL.LAUNCHER_BRAND + "/checkbox01.png");
                        } else {
                            headerItem[0].fileSelect = 0;
                            UI.setImage(fileBrowserList.initSequence[0].children[3], "setting/" + GLOBAL.LAUNCHER_BRAND + "/checkbox02.png");
                        }
                    } else {
                        DBG_ERROR("list mode, fileBrowser.onkey_ENTER, no media");
                    }

                    break;
                case "file":
                    DBG_INFO("In listMode, store focus is :" + currentIndex);
                    if (Config.tv) {
                        hiMedia.startLoading("list mode, FB enter", 15);
                        fileBrowser.allPic[0].fileSelect = 1;
                        fileBrowser.allMusic[0].fileSelect = 1;
                        fileBrowser.allVideo[0].fileSelect = 1;

                        hiMedia.curFilePath = currentPath;
                        hiMedia.fileBrowserPicData = fileBrowser.picFileStack[hiMedia.curFilePath] ?
                            fileBrowser.picFileStack[hiMedia.curFilePath] : [];
                        hiMedia.fileBrowserVideoData = fileBrowser.videoFileStack[hiMedia.curFilePath] ?
                            fileBrowser.videoFileStack[hiMedia.curFilePath] : [];
                        hiMedia.fileBrowserMusicData = fileBrowser.musicFileStack[hiMedia.curFilePath] ?
                            fileBrowser.musicFileStack[hiMedia.curFilePath] : [];
                        hiMedia.fileBrowserFileData = fileBrowser.folderFileStack[hiMedia.curFilePath] ?
                            fileBrowser.folderFileStack[hiMedia.curFilePath] : [];
                        fileBrowser.setFBPath(hiMedia.curFilePath);
                        // because there is a all selected item, so subtract "1".
                        fileBrowser.focusStack.push(currentIndex - 1);
                        DBG_INFO("List mode, enter folder, Current Path is :" + hiMedia.curFilePath + "   current focus is :" + focus);

                        if (hiMedia.currentSortType == "name") {
                            try {
                                hiMedia.fileBrowserFileData = sortContent(hiMedia.fileBrowserFileData, "name");
                                hiMedia.fileBrowserPicData = sortContent(hiMedia.fileBrowserPicData, "name");
                                hiMedia.fileBrowserMusicData = sortContent(hiMedia.fileBrowserMusicData, "name");
                                hiMedia.fileBrowserVideoData = sortContent(hiMedia.fileBrowserVideoData, "name");
                            } catch (ex) {
                                DBG_ERROR(ex.message);
                            }

                        } else if (hiMedia.currentSortType == "time") {
                            try {
                                hiMedia.fileBrowserFileData = sortContent(hiMedia.fileBrowserFileData, "time");
                                hiMedia.fileBrowserPicData = sortContent(hiMedia.fileBrowserPicData, "time");
                                hiMedia.fileBrowserMusicData = sortContent(hiMedia.fileBrowserMusicData, "time");
                                hiMedia.fileBrowserVideoData = sortContent(hiMedia.fileBrowserVideoData, "time");
                            } catch (ex) {
                                DBG_ERROR(ex.message);
                            }
                        } else if (hiMedia.currentSortType == "size") {
                            try {
                                //file类型的size 大小无法获取，所以返回时默认按照name排序。
                                hiMedia.fileBrowserFileData = sortContent(hiMedia.fileBrowserFileData, "name");
                                hiMedia.fileBrowserPicData = sortContent(hiMedia.fileBrowserPicData, "size");
                                hiMedia.fileBrowserMusicData = sortContent(hiMedia.fileBrowserMusicData, "size");
                                hiMedia.fileBrowserVideoData = sortContent(hiMedia.fileBrowserVideoData, "size");
                            } catch (ex) {
                                DBG_ERROR(ex.message);
                            }
                        } else {
                            // default order by file name.
                            try {
                                hiMedia.fileBrowserFileData = sortContent(hiMedia.fileBrowserFileData, "name");
                                hiMedia.fileBrowserPicData = sortContent(hiMedia.fileBrowserPicData, "name");
                                hiMedia.fileBrowserMusicData = sortContent(hiMedia.fileBrowserMusicData, "name");
                                hiMedia.fileBrowserVideoData = sortContent(hiMedia.fileBrowserVideoData, "name");
                            } catch (ex) {
                                DBG_ERROR(ex.message);
                            }
                        }
                        var mediaItems = [];
                        var headerItem = [];
                        switch (fileBrowser.currClassify) {
                            case hiMedia.fileType.pic:
                                mediaItems = fileBrowser.picFileStack[currentPath];
                                headerItem = fileBrowser.allPic;
                                break;
                            case hiMedia.fileType.music:
                                mediaItems = fileBrowser.musicFileStack[currentPath];
                                headerItem = fileBrowser.allMusic;
                                break;
                            case hiMedia.fileType.video:
                                mediaItems = fileBrowser.videoFileStack[currentPath];
                                headerItem = fileBrowser.allVideo;
                                break;
                            default:
                                DBG_ERROR("fileBrowser.onkey_ENTER, list mode, in error classify");
                                break;
                        }
                        if (!!mediaItems) {
                            fileBrowser.pathStack.push(currentPath);
                            for (var i = 0; i < mediaItems.length; i++) {
                                if (mediaItems[i].fileSelect == 0) {
                                    headerItem[0].fileSelect = 0;
                                }
                            }
                            if (mediaItems.length == 0) {
                                headerItem[0].fileSelect = 1;
                            }
                            fileBrowserList.removeAllChildren(true);
                            fileBrowser.createFileList(headerItem
                                .concat(hiMedia.fileBrowserFileData)
                                .concat(mediaItems), true);
                            hiMedia.endLoading("list mode, FB enter");
                        } else {
                            try {
                                if (hiMedia.currentDevice == hiMedia.device.usb) {
                                    hiMedia.showUsbDetail(currentId, currentPath, null);
                                } else if (hiMedia.currentDevice == hiMedia.device.dms) {
                                    hiMedia.showDmpDetail(currentId, currentPath, 28, false);
                                }
                            } catch (ex) {
                                DBG_ERROR("Open Usb error:" + ex.message);
                            }
                        }
                    }
                    break;
                default:
                    DBG_ERROR("fileBrowser.onkey_ENTER, default, error type: " + currentType);
                    break;
            }


            UI.updateStage();
        }

    };

    fileBrowser.createPlaylist = function () {
        DBG_ALWAYS("fileBrowser.createPlaylist");
        var selectFiles = [];
        //TODO: create List for stack.
        switch (fileBrowser.currClassify) {
            case hiMedia.fileType.pic:
                for (key in fileBrowser.picFileStack) {
                    if (!!fileBrowser.picFileStack[key]) {
                        for (var i = 0; i < fileBrowser.picFileStack[key].length; i++) {
                            if (!!(fileBrowser.picFileStack[key][i])
                                && !!(fileBrowser.picFileStack[key][i].fileSelect)
                                && fileBrowser.picFileStack[key][i].fileSelect == 1) {
                                selectFiles.push(fileBrowser.picFileStack[key][i]);
                            }
                        }
                    }
                }
                break;
            case hiMedia.fileType.music:
                for (key in fileBrowser.musicFileStack) {
                    if (!!fileBrowser.musicFileStack[key]) {
                        for (var i = 0; i < fileBrowser.musicFileStack[key].length; i++) {
                            if (!!(fileBrowser.musicFileStack[key][i])
                                && !!(fileBrowser.musicFileStack[key][i].fileSelect)
                                && fileBrowser.musicFileStack[key][i].fileSelect == 1) {
                                selectFiles.push(fileBrowser.musicFileStack[key][i]);
                            }
                        }
                    }
                }
                break;
            case hiMedia.fileType.video:
                for (key in fileBrowser.videoFileStack) {
                    if (!!fileBrowser.videoFileStack[key]) {
                        for (var i = 0; i < fileBrowser.videoFileStack[key].length; i++) {
                            if (!!(fileBrowser.videoFileStack[key][i])
                                && !!(fileBrowser.videoFileStack[key][i].fileSelect)
                                && fileBrowser.videoFileStack[key][i].fileSelect == 1) {
                                selectFiles.push(fileBrowser.videoFileStack[key][i]);
                            }
                        }
                    }
                }
                break;
            default:
                // error type, do nothing
                break;
        }
        if (selectFiles.length > 0) {
            fileBrowser.existListMode();
            playContent(selectFiles);
        } else {
            hiMedia.toastMsg("[SE3919]");
        }
    };

    FBSearchInput.onkey_RIGHT = function () {
        FBSearchInput.inactive();
        UI.focusTo(sortLableContainer);
    }
    FBSearchInput.onkey_DOWN = function () {
        DBG_ALWAYS("FBSearchInput.onkey_DOWN, fileBrowserList.initSequence.length: " + fileBrowserList.children.length);
        if (fileBrowserList.children.length > 0) {
            FBSearchInput.inactive();
            UI.focusTo(fileBrowserList.initSequence[0]);
            UI.moveCursor(UI.adjustView());
            UI.base.cursor.visible = true;
            //UI.base.cursor.scale.x = UI.base.cursor.scale.y = 1.05;
            UI.updateStage();
        } else {
            return false;
        }

    }
    FBSearchInput.onFocus = function () {
        DBG_INFO("FBSearchInput.onFocus");
        if (!fileBrowser.searchMode) {
            FBSearchInput.setText("");
            FBSearchInputPlaceholder.visible = true;
            UI.setImage(FBSearchInputImg, "setting/" + GLOBAL.LAUNCHER_BRAND + "/input_line_F.png");
            UI.setText(FBSearchInputPlaceholder, "[SE3732]");
        } else {
            UI.setImage(FBSearchInputImg, "setting/" + GLOBAL.LAUNCHER_BRAND + "/input_line_F.png");
        }
        UI.updateStage();
        return true;
    }
    FBSearchInput.onNormal = function () {
        DBG_INFO("FBSearchInput.onNormal");
        FBSearchInput.inactive();
        if (!fileBrowser.searchMode) {
            FBSearchInput.setText("");
            FBSearchInputPlaceholder.visible = true;
            UI.setText(FBSearchInputPlaceholder, "[SE0185]");
            UI.setImage(FBSearchInputImg, "hiMedia/input_line_N.png");
        } else {
            UI.setImage(FBSearchInputImg, "hiMedia/input_line_N.png");
        }
        return true;
    }
    FBSearchInput.onkey_ENTER = function () {
        DBG_INFO("!!!!!!!!!!!!!!!!!!!");
        FBSearchInput.showKeyBoard();
        if (fileBrowser.listMode) {
            fileBrowser.exitSearch = true;
            fileBrowser.existListMode();
        }

    }

    fileBrowserList.onkey_DOWN = function (focus) {
        DBG_ALWAYS("fileBrowserList.onkey_DOWN");
        if (!focus.downTo) {
            var index = fileBrowserList.initSequence.indexOf(focus);
            if (index % 6 != 0) {
                UI.focusTo(fileBrowserList.initSequence[fileBrowserList.initSequence.length - 1]);
            }
        } else {
            return true;
        }
    }
    fileBrowserList.onkey_UP = function () {
        DBG_ALWAYS("fileBrowserList.onkey_UP");
        if (fileBrowserList.children.length > 0) {
            var idx = fileBrowserList.initSequence.indexOf(UI.getCurrFocus());
            if (idx < 0) {
                idx = 0;
            }
            if (idx == 0 || idx == 1) {
                // focus to search widge.
                if (hiMedia.currentDevice == hiMedia.device.usb) {
                    UI.base.cursor.visible = false;
                    UI.focusTo(FBSearchInput);
                    UI.setImage(FBSearchInputImg, "setting/" + GLOBAL.LAUNCHER_BRAND + "/input_line_F.png");
                } else {
                    UI.focusTo(sortLableContainer);
                }
            } else if (idx == 2 || idx == 3) {
                UI.focusTo(sortLableContainer);
            } else if (idx == 4 || idx == 5) {
                UI.focusTo(filterLableContainer);
            }
            /*
             if (fileBrowserList.initSequence.indexOf(UI.getCurrFocus()) == 0 &&
             FBSearch.alpha == 1) {
             UI.focusTo(FBSearchInput);
             FBSearchInput.active();
             UI.base.cursor.alpha = 0;
             UI.base.cursor.visible = false;
             FBSearchInputBtn.alpha = 0.3;
             FBSearchInputBtn.disable = true;
             UI.setImage(FBSearchInputImg, "hiMedia/input_line_F.png");
             UI.updateStage();
             }
             */
        }
        return true;
    }

    fileBrowser.existListMode = function () {
        DBG_ALWAYS("existListMode");
        fileBrowserList.removeAllChildren(true);
        fileBrowser.fileBrowserData.shift();
        fileBrowser.fileBrowserData = fileBrowser.fileBrowserData;
        fileBrowser.listFilesSwitch(false);
        fileBrowser.createFileList(fileBrowser.fileBrowserData, true);
        fileBrowser.setColorButton(true, false, 1);
        fileBrowserBlue.visible = true;
        fileBrowserTop.visible = true;
        fileBrowser.selectContent = [];
        fileBrowser.allPic[0].fileSelect = 1;
        fileBrowser.allMusic[0].fileSelect = 1;
        fileBrowser.allVideo[0].fileSelect = 1;
        fileBrowser.resetListCheckedStatus(hiMedia.fileBrowserPicData);
        fileBrowser.resetListCheckedStatus(hiMedia.fileBrowserMusicData);
        fileBrowser.resetListCheckedStatus(hiMedia.fileBrowserVideoData);
        fileBrowser.exitSearch = false;
    }
    var classifyName = "all";
    var setThumbnailTimer = null;
    fileBrowser.onFocus = function (focus) {
        if (!!createListForAllType.visible) {
            createjs.Tween.removeTweens(UI.base.cursor);
            UI.moveCursor(UI.adjustView());
            focus.scale.x = 1.05;
            focus.scale.y = 1.05;
            //UI.getTween(focus.scale).to({x: 1.05, y: 1.05}, 120, UI.ease.quartOut);
            UI.getTween(UI.base.cursor).to({alpha: 1, visible: 1}, 500, UI.ease.quartOut);
        } else {
            var currentIndex = 0;
            try {
                currentIndex = fileBrowserList.initSequence.indexOf(UI.getCurrFocus());
            }
            catch (ex) {
                DBG_ERROR("fileBrowser.onFocus error!!!" + ex.message);
                currentIndex = -1;
            }
            //DBG_INFO("[fileBrowser.onFocus]" + currentIndex);
            if (currentIndex >= 0) {

                try {
                    if (!fileBrowser.listMode) {
                        hiMedia.hideListData(fileBrowserList, currentIndex, 12, "hide");
                    } else {
                        hiMedia.hideListData(fileBrowserList, currentIndex, 12);
                    }
                    UI.moveCursor(UI.adjustView());
                }
                catch (ex) {
                    DBG_ERROR(ex.message);
                }
                //UI.getTween(focus.scale).to({x: 1.10, y: 1.10}, 500, UI.ease.quartOut);
                UI.base.runText(focus);
                // UI.getTween(UI.base.cursor).to({scaleX: 1.05, scaleY: 1.05}, 500, UI.ease.quartOut);
                //UI.getTween(UI.base.cursor, false).wait(300).to({alpha: 1}, 500, UI.ease.quartOut);
                // UI.moveTop(focus);

                fileBrowser.setFBPage(currentIndex + 1);
                fileBrowser.currIndex = currentIndex;
                DBG_INFO("File_browser_on_focus!!!");
                createjs.Tween.removeTweens(UI.base.cursor);
                //UI.getTween(focus.scale).to({x: 1.10, y: 1.10}, 120, UI.ease.quartOut);
                focus.scale.x = 1.10;
                focus.scale.y = 1.10;
                UI.base.cursor.alpha = 1;
                UI.base.cursor.visible = 1;
                //UI.getTween(UI.base.cursor).to({alpha: 1, visible: 1}, 500, UI.ease.quartOut);
                UI.updateStage();
            } else {
                DBG_ERROR("currentIndex is  :   " + currentIndex);
                if (fileBrowser.listMode) {
                    UI.moveCursor(UI.adjustView());
                    UI.base.cursor.alpha = 1;
                }
            }
            return true;
        }
    };

    fileBrowser.onNormal = function (focus) {
        createjs.Tween.removeTweens(focus.scale);
        focus.scale.x = 1;
        focus.scale.y = 1;
        UI.base.stopText(focus);
        var currentIndex = 0;

        return true;
//        hiMedia.currFocus.scale.x = 1;
//        hiMedia.currFocus.scale.y = 1;
    };

    fileBrowser.setFBPath = function (path) {
        var tmpPath = "";
        if (path.toString().indexOf(hiMedia.devicePath) != -1) {
            tmpPath = path.split(hiMedia.devicePath)[1];
            DBG_INFO(tmpPath);
        } else {
            tmpPath = path;
        }

        UI.setText(filePath, tmpPath);
        //LEFTOVER 默认是返回第一个，之后应该改为Last focus  每次切换页面时都要刷新页码页
        var currentIndex = 0;
        try {
            currentIndex = fileBrowserList.initSequence.indexOf(UI.getCurrFocus());
        }
        catch (ex) {
            DBG_ERROR("fileBrowser.onFocus error!!!" + ex.message);
            currentIndex = -1;
        }
        if (currentIndex > 0) {
            fileBrowser.setFBPage(currentIndex + 1);
        } else {
            fileBrowser.setFBPage(1);
        }

    }
    fileBrowser.setFBPage = function (index) {
        /*
         var tmpPage = index + "/" + fileBrowser.fileBrowserData.length;
         if (fileBrowser.fileBrowserData.length == 0) {
         tmpPage = "0/0";
         fileBrowser.setColorButton(false, false, false);
         } else {
         if (fileBrowser.currClassify > 0) {
         if (!fileBrowser.listMode) {
         fileBrowser.setColorButton(true, true, true);
         }
         } else {
         fileBrowserSortType.alpha = 1;
         fileBrowserPage.alpha = 1;
         fileBrowser.setColorButton(true, true, false);
         }

         }
         */

    }
    var currentThumbUrl = "";
    fileBrowser.onMDChanged = function (value) {
        DBG_INFO("[onMDChanged] state changed : " + value);
        if (value[1] == 2) {
            return;
        }
        if (value[3] != tmpUrl) {
            DBG_INFO("not current path." + tmpUrl);
            return;
        }
        if (!getThumbnailFlag()) {
            DBG_INFO("thumbNailCount is 0,just return;");//应对异步获取时突然返回上一页时清空thumbNailArray的情况。
            return;
        }
        var thumbUrl = value[5];
        if (!thumbUrl) {
            DBG_INFO("thumbUrl is null.");
            return;
        }
        currentThumbUrl = thumbUrl;
        var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
        if (currentSubModel == "fileBrowser") {
            try {
                if (thumbUrl == "fail") {
                    setThumbNail("fail");

                }
                else {
                    setThumbNail("file://" + encodeURI(thumbUrl));
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        } else {
            DBG_ERROR("current subModel is " + currentSubModel + ",not fileBrowser!!");
        }
    };
    fileBrowser.resetListCheckedStatus = function (data) {
        if (data.length == 0) {
            return
        }
        for (var i = 0; i < data.length; i++) {
            data[i].fileSelect = 0;
        }
    }

    fileBrowser.allPic = [
        {deviceId: "all Pic", filePath: null, fileName: "[OT0413]", fileTime: 0, fileType: "allPic", fileSelect: 1}
    ];
    fileBrowser.allMusic = [
        {deviceId: "all Music", filePath: null, fileName: "[OT0414]", fileTime: 0, fileType: "allMusic", fileSelect: 1}
    ];
    fileBrowser.allVideo = [
        {deviceId: "all Video", filePath: null, fileName: "[OT0415]", fileTime: 0, fileType: "allVideo", fileSelect: 1}
    ];

    //LIST
    var isCreateListForAll = false;
    fileBrowser.onkey_GREEN = function () {
        fileSortContainerBg.visible = false;
        filterLableContainerBg.visible = false;
        if (fileBrowser.searchMode) {
            return false;
        }
        fileBrowser.resetWidges();
        if (fileBrowser.greenEnable) {
            // reset all data checked status to "1".
            fileBrowser.allPic[0].fileSelect = 1;
            fileBrowser.allMusic[0].fileSelect = 1;
            fileBrowser.allVideo[0].fileSelect = 1;

            // open the list mode swtich to "true"
            switch (fileBrowser.currClassify) {

                case hiMedia.fileType.pic:
                    fileBrowser.listFilesSwitch(true);
                    fileBrowserList.removeAllChildren(true);
                    changeFileSelect(hiMedia.fileBrowserPicData);
                    fileBrowser.createFileList(fileBrowser.allPic
                        .concat(hiMedia.fileBrowserFileData)
                        .concat(hiMedia.fileBrowserPicData), true);
                    fileBrowser.setColorButton(false, false, 2);
                    break;
                case hiMedia.fileType.music:
                    fileBrowser.listFilesSwitch(true);
                    fileBrowserList.removeAllChildren(true);
                    changeFileSelect(hiMedia.fileBrowserMusicData);
                    fileBrowser.createFileList(fileBrowser.allMusic
                        .concat(hiMedia.fileBrowserFileData)
                        .concat(hiMedia.fileBrowserMusicData), true);
                    fileBrowser.setColorButton(false, false, 0);
                    break;
                case hiMedia.fileType.video:
                    fileBrowser.listFilesSwitch(true);
                    fileBrowserList.removeAllChildren(true);
                    changeFileSelect(hiMedia.fileBrowserVideoData);
                    fileBrowser.createFileList(fileBrowser.allVideo
                        .concat(hiMedia.fileBrowserFileData)
                        .concat(hiMedia.fileBrowserVideoData), true);
                    fileBrowser.setColorButton(false, false, 2);
                    break;
                case hiMedia.fileType.all:
                    if (createListForAllType.visible) {
                        DBG_INFO("onkey_GREEN, createListForAllType already show, do nothing");
                    } else {
                        createListForAllType.visible = true;
                        if (!isCreateListForAll) {
                            isCreateListForAll = fileBrowser.createListForAll();
                            UI.addMask(createListContainer, 760, 520, 40, 20);
                            UI.resetViewPos(createListContainer);
                            UI.setView(createListContainer, 760, 520);
                            UI.addScrollbar(createListContainer, 5);
                        }
                    }
                    UI.focusTo(createListContainer.initSequence[0]);

                    UI.updateStage();
                default :
                    break;
            }

        } else {
            fileBrowser.createPlaylist();
        }
    }
    var changeFileSelect = function (file) {
        for (var i = 0; i < file.length; i++) {
            file[i].fileSelect = 1;
        }
    }

    createListForAllType.onkey_BACKSPACE = function () {
        createListForAllType.visible = false;
        DBG_INFO("createListForAllType.onkey_BACKSPACE");
        if (fileBrowserList.initSequence.length > 0) {
            UI.focusTo(fileBrowserList.initSequence[0]);
        } else {
            UI.focusTo(filterLableContainer);
        }
    }

    //createListForAllType.onFocus = function () {
    //    UI.base.cursor.alpha = 0;
    //    var idx = createListForAllType.initSequence.indexOf(UI.getCurrFocus());
    //    DBG_ALWAYS("createListForAllType.onFocus, idx: " + idx);
    //    if (idx == -1) {
    //        idx = 0;
    //    }
    //    var itemBg = UI.getItem(createListForAllType.initSequence[idx], "itemBg");
    //    UI.setImage(itemBg, "hiMedia/filter_list_bg.png");
    //};
    //createListForAllType.onNormal = function () {
    //    DBG_ALWAYS("createListForAllType.onNormal");
    //    //reset last item background.
    //    for (var i = 0; i < createListForAllType.initSequence.length; i++) {
    //        var itemBg = UI.getItem(createListForAllType.initSequence[i], "itemBg");
    //        UI.setImage(itemBg, "hiMedia/fileList_bak.png");
    //    }
    //};

    createListForAllType.onkey_ENTER = function () {
        var idx = createListContainer.initSequence.indexOf(UI.getCurrFocus());
        DBG_ALWAYS("filterList.onkey_ENTER, idx: " + idx);
        if (idx == -1) {
            idx = 0;
        }
        //createListForAllType.onNormal();
        createListForAllType.visible = false;
        if (fileBrowserList.initSequence.length > 0) {
            UI.focusTo(fileBrowserList.initSequence[0]);
        } else {
            UI.focusTo(filterLableContainer);
        }
        // enter list mode.
        fileBrowser.listFilesSwitch(true);
        switch (idx) {
            case 0:
                // Pic
                fileBrowser.setFilterType(1);
                fileBrowser.setColorButton(false, false, 2);
                UI.setText(filterLable, fileTypeArray[1]);
                break;
            case 1:
                // Music
                fileBrowser.setFilterType(2);
                fileBrowser.setColorButton(false, false, 0);
                UI.setText(filterLable, fileTypeArray[2]);
                break;
            case 2:
                // Video
                fileBrowser.setFilterType(3);
                fileBrowser.setColorButton(false, false, 2);
                UI.setText(filterLable, fileTypeArray[3]);
                break;
            default:
                break;
        }
    };
    var typeArray = ["[LA0031]", "[SE0060]", "[LA0032]"];
    fileBrowser.createListForAll = function () {
        DBG_INFO("createListForAll: " + createListForAllType.name);
        var array = [];
        if (typeArray.length > 0) {
            for (var i = 0; i < typeArray.length; i++) {
                var data = {
                    chip_bg: UI.item_bg,
                    chipText: typeArray[i],
                    name: createListForAllType.name + i
                };
                array.push(data);
            }
            var info = {
                template: "hiMedia_fileBrowser_CreatList_Item_For_All",
                direction: CONST.GIRD_DIRECTION.H,
                breakNum: 1,
                distanceX: 0,
                distanceY: 10,
                container: createListContainer
            };
            Gird.create(array, info);
            return true;
        }
        return false;
    };
    //TOP
    fileBrowser.onkey_BLUE = function () {
        DBG_ALWAYS("fileBrowser.onkey_BLUE, blueEnable: " + fileBrowser.blueEnable + ", searchMode: " + fileBrowser.searchMode);
        filterLableContainerBg.visible = false;
        fileSortContainerBg.visible = false;
        createListForAllType.visible = false;
        if (fileBrowser.searchMode) {
            return false;
        }
        if (fileBrowser.blueEnable == 1) {
            fileBrowser.goToTop();
        } else if (fileBrowser.blueEnable == 0) {
            //TODO: save playlist.
            hiMedia.BGMList = [];
            for (key in fileBrowser.musicFileStack) {
                if (!!fileBrowser.musicFileStack[key]) {
                    for (var i = 0; i < fileBrowser.musicFileStack[key].length; i++) {
                        if (!!(fileBrowser.musicFileStack[key][i])
                            && !!(fileBrowser.musicFileStack[key][i].fileSelect)
                            && fileBrowser.musicFileStack[key][i].fileSelect == 1) {

                            if (hiMedia.currentDevice == hiMedia.device.usb || hiMedia.currentDevice == hiMedia.device.pvr) {
                                hiMedia.BGMList.push(fileBrowser.musicFileStack[key][i].filePath);
                            } else {
                                hiMedia.BGMList.push(fileBrowser.musicFileStack[key][i].filePath);
                            }
                        }
                    }
                }
            }
            if (hiMedia.BGMList.length > 0) {
                hiMedia.noSaveList = false;
                hiMedia.toastMsg("music list is saved.");
            } else {
                hiMedia.noSaveList = true;
                hiMedia.toastMsg("[SE3920]");
            }
        }
    }
    //go to top
    fileBrowser.goToTop = function () {
        DBG_INFO("fileBrowser.goToTop, data length = " + fileBrowser.fileBrowserData.length);
        if (fileBrowser.fileBrowserData.length > 0) {
            fileBrowser.resetWidges();
            UI.focusTo(fileBrowserList.initSequence[0]);
            fileBrowser.currFocus = fileBrowserList.initSequence[0];
        }
    }

    //LIST
    fileBrowser.listFilesSwitch = function (flag) {
        fileBrowser.listMode = flag;
    }
    fileBrowser.enableColorButton = function (greenVisible, yellowVisible, blueVisible) {
        DBG_INFO("fileBrowser.enableColorButton");
        if (greenVisible) {
            fileBrowserGreen.visible = true;
            fileBrowserListB.visible = true;
        } else {
            fileBrowserGreen.visible = false;
            fileBrowserListB.visible = false;
        }
        if (blueVisible) {
            fileBrowserBlue.visible = true;
            fileBrowserTop.visible = true;
        } else {
            fileBrowserBlue.visible = false;
            fileBrowserTop.visible = false;
        }
    };
    fileBrowser.setColorButton = function (greenEnable, yellowEnable, blueEnable) {
        DBG_INFO("fileBrowser.setColorButton");

        fileBrowser.greenEnable = greenEnable;
        fileBrowser.yellowEnable = yellowEnable;
        fileBrowser.blueEnable = blueEnable;
        if (!!greenEnable) {
            UI.setText(fileBrowserListB, "[DMP0157]");//Create playlist
        } else {
            UI.setText(fileBrowserListB, "[PI0010]");//Play
        }

        if (blueEnable == 1) {
            UI.setText(fileBrowserTop, "[DMP0141]");//Top
        } else if (blueEnable == 0) {
            UI.setText(fileBrowserTop, "[SE0261]");//Save
        } else {
            fileBrowserBlue.visible = false;
            fileBrowserTop.visible = false;
        }
        UI.updateStage();
    }

    function playContent(content) {
        var type = content[0].fileType;

        switch (type) {
            case "pic":
                try {
                    noNeedDelete = true;
                    UI.popSubModule();
                    //初始化时清空一下公共变量
                    hiMedia.initPicList = [];
                    hiMedia.initPicIndex = 0;
                    for (var j = 0; j < content.length; j++) {
                        //pic不需要加前缀
                        hiMedia.initPicList.push({
                            "picUrl": content[j].filePath,
                            "picName": content[j].fileName,
                            "picTime": content[j].fileTime,
                            "picExifRotate": 3
                        });
                    }

                    UI.pushSubModule("hiMedia", "picPlayer", true);
                }
                catch (ex) {
                    DBG_ERROR("playPic Error:" + ex.message);
                }
                break;
            case "music":
                try {
                    noNeedDelete = true;
                    UI.popSubModule();
                    //初始化时清空一下公共变量
                    hiMedia.initMusicList = [];
                    hiMedia.initMusicIndex = 0;
                    for (var j = 0; j < content.length; j++) {
                        //需要区分本地视频和网络视频
                        if (hiMedia.currentDevice == hiMedia.device.usb || hiMedia.currentDevice == hiMedia.device.pvr) {
                            hiMedia.initMusicList.push({
                                "musicUrl": content[j].filePath,
                                "musicName": content[j].fileName
                            });
                        }
                        else {
                            hiMedia.initMusicList.push({
                                "musicUrl": content[j].filePath,
                                "musicName": content[j].fileName
                            });
                        }

                    }
                    UI.lockAllKeys("playMusic");
                    UI.pushSubModule("hiMedia", "musicPlayer", true);
                }
                catch (ex) {
                    DBG_ERROR("playMusic Error:" + ex.message);
                }
                break;
            case "video":
                try {
                    noNeedDelete = true;
                    UI.popSubModule();
                    //初始化时清空一下公共变量
                    hiMedia.initVideoList = [];
                    hiMedia.initVideoIndex = 0;
                    for (var j = 0; j < content.length; j++) {
                        //需要区分本地视频和网络视频(需要改为stack的形式)
                        if (hiMedia.currentDevice == hiMedia.device.usb || hiMedia.currentDevice == hiMedia.device.pvr) {
                            hiMedia.initVideoList.push({
                                "videoUrl": content[j].filePath,
                                "videoName": content[j].fileName
                            });
                        }
                        else {
                            hiMedia.initVideoList.push({
                                "videoUrl": content[j].filePath,
                                "videoName": content[j].fileName
                            });
                        }

                    }
                    UI.lockAllKeys("playVideo");
                    UI.pushSubModule("hiMedia", "videoPlayer", true);
                }
                catch (ex) {
                    DBG_ERROR("playVideo Error:" + ex.message);
                }
                break;
        }
    }

    function sortContent(content, type) {
        DBG_ALWAYS("sort type is : " + type);
        switch (type) {
            case "name":
                if (content.length > 1) {
                    content.sort(hiMedia.sortBy("fileName", false, "localeCompare"));
                }
                return content;
                break;
            case "time":
                if (content.length > 1) {
                    if (!content[0].fileTime) {
                        return content;
                    }
                    else if (content[0].fileTime == "unsupported") {
                        return content;
                    }
                    content.sort(hiMedia.sortBy("fileTime", true, String));
                }
                return content;
                break;
            case "size":
                if (content.length > 1) {
                    if (!content[0].fileSize) {
                        return content;
                    }
                    else if (content[0].fileSize == "unsupported") {
                        return content;
                    }
                    content.sort(hiMedia.sortBy("fileSize", true, Number));
                }
                return content;
                break;
            default :
                return content;
                break;
        }

    }

    fileBrowser.changeClassify = function (index) {
        if (index == -1) {
            index = 5;
        }
        UI.updateStage();
    }

    function checkAllSelect(list) {
        if (!!list[0]) {
            for (var i = 1; i < list.length; i++) {
                if (!list[i].fileSelect) {
                    return false;
                }
            }
            return true;
        } else {
            return false;
        }
    }

    /*
     * handle event of the file type filter.
     * include: onFocus, onkey_DOWN, onkey_RIGHT,
     * onkey_BACKSPACE, onkey_ENTER
     */
    var fileTypeArray = ["[SE0085]", "[LA0031]", "[SE0060]", "[LA0032]"];

    filterLableContainer.onFocus = function () {
        DBG_ALWAYS("filterLableContainer.onFocus");
        UI.setImage(filterLableBg, "hiMedia/filter_list_bg.png");
        UI.base.cursor.alpha = 0;
        UI.base.runText(fileBrowser.currFocus);
    };

    filterLableContainer.onNormal = function () {
        DBG_ALWAYS("filterLableContainer.onNormal");
        UI.setImage(filterLableBg, "hiMedia/fileList_bak.png");
        UI.base.stopText(fileBrowser.currFocus);
    };

    filterLableContainer.onkey_DOWN = function () {
        DBG_ALWAYS("filterLableContainer.onkey_DOWN, visible = " + filterList.visible);
        if (filterList.visible) {
            UI.focusTo(filterList.initSequence[0]);
        } else {
            if (fileBrowserList.children.length > 0) {
                UI.focusTo(fileBrowserList.initSequence[0]);
                UI.moveCursor(UI.adjustView());
                UI.base.cursor.alpha = 1;
                UI.base.cursor.visible = true;
            }
        }
    };

    filterLableContainer.onkey_LEFT = function () {
        DBG_ALWAYS("filterLableContainer.onkey_LEFT, filterList.visible: " + filterList.visible);
        UI.focusTo(sortLableContainer);
        if (filterList.visible) {
            filterList.visible = false;
            filterLableContainerBg.visible = false;
        }
    };

    filterLableContainer.onkey_BACKSPACE = function () {
        DBG_ALWAYS("filterLableContainer.onkey_BACKSPACE");
        if (filterList.visible) {
            filterList.visible = false;
            filterLableContainerBg.visible = false;
        }
        return true;
    };
    var filterListCreated = false;
    filterLableContainer.onkey_ENTER = function () {
        DBG_ALWAYS("filterLableContainer.onkey_ENTER, visible = " + filterList.visible
            + ", filterListCreated = " + filterListCreated);
        if (filterList.visible) {
            filterList.visible = false;
            filterLableContainerBg.visible = false;
        } else {
            filterList.visible = true;
            filterLableContainerBg.visible = true;
            if (!filterListCreated) {
                filterListCreated = fileBrowser.createFilterList(fileTypeArray, filterList);
            }
        }
        UI.updateStage();
    };
    fileBrowser.createFilterList = function (menuData, filterList) {
        DBG_INFO("createFilterList: " + filterList.name);
        var array = [];
        if (menuData.length > 0) {
            for (var i = 0; i < menuData.length; i++) {
                var data = {
                    itemBg: "hiMedia/fileList_bak.png",
                    itemText: menuData[i],
                    name: filterList.name + i
                };
                array.push(data);
            }
            var info = {
                template: "hiMedia_fileBrowser_FilterItem",
                direction: CONST.GIRD_DIRECTION.H,
                breakNum: 1,
                distanceX: 0,
                distanceY: 0,
                container: filterList
            };
            Gird.create(array, info);
            return true;
        }
        return false;
    };

    filterList.onFocus = function () {
        var idx = filterList.initSequence.indexOf(UI.getCurrFocus());
        DBG_ALWAYS("filterList.onFocus, idx: " + idx);
        if (idx == -1) {
            idx = 0;
        }
        var itemBg = UI.getItem(filterList.initSequence[idx], "itemBg");
        if (GLOBAL.HICONTRAST) {
            UI.setImage(itemBg, "hiMedia/filter_list_bg_black.png");
        }
        else {
            UI.setImage(itemBg, "hiMedia/filter_list_bg.png");
        }
        UI.base.runText(fileBrowser.currFocus);
        return true;
    };

    filterList.onNormal = function () {
        DBG_ALWAYS("filterList.onNormal");
        //reset last item background.
        for (var i = 0; i < filterList.initSequence.length; i++) {
            var itemBg = UI.getItem(filterList.initSequence[i], "itemBg");
            UI.setImage(itemBg, "hiMedia/fileList_bak.png");
            UI.base.stopText(fileBrowser.currFocus);
        }
        return true;
    };

    filterList.onkey_ENTER = function () {
        var idx = filterList.initSequence.indexOf(UI.getCurrFocus());
        DBG_ALWAYS("filterList.onkey_ENTER, idx: " + idx);
        if (idx == -1) {
            idx = 0;
        }
        filterList.onNormal();
        filterList.visible = false;
        filterLableContainerBg.visible = false;
        if (fileBrowser.currClassify == idx) {
            // do nothing if file type filter not change.
            DBG_INFO("filterList.onkey_ENTER, not change the filter");
            UI.focusTo(filterLableContainer);
            return false;
        }
        fileBrowser.setFilterType(idx);
        UI.setText(filterLable, fileTypeArray[idx]);
    };

    fileBrowser.setFilterType = function (type) {
        DBG_INFO("setFilterType, listMode: " + fileBrowser.listMode + ", type:" + type);
        if (fileBrowser.listMode) {
            DBG_INFO(UI.getCurrFocus().name);

            fileBrowser.allPic[0].fileSelect = 1;
            fileBrowser.allMusic[0].fileSelect = 1;
            fileBrowser.allVideo[0].fileSelect = 1;
            try {
                switch (type) {
                    case hiMedia.fileType.all:
                        fileBrowser.enableColorButton(true, false, true);
                        fileBrowser.setColorButton(true, false, 1);
                        fileBrowser.currClassify = hiMedia.fileType.all;
                        UI.setImage(fileBrowserBG, "hiMedia/bg_all.png");
                        createjs.Tween.removeTweens(fileBrowserList);
                        fileBrowserList.removeAllChildren(true);
                        fileBrowser.fileStack[hiMedia.curFilePath] = fileBrowser.fileBrowserData = hiMedia.fileBrowserAllData;
                        fileBrowser.listFilesSwitch(false);
                        fileBrowser.createFileList(fileBrowser.fileBrowserData, true);
                        // temp to quit the create list mode.
                        if (fileBrowser.fileBrowserData.length == 0) {
                            DBG_INFO("setFilterType, list mode no data, type:" + type);
                            UI.focusTo(filterLableContainer);
                        }
                        break;
                    case hiMedia.fileType.pic:
                        fileBrowser.enableColorButton(true, false, false);
                        fileBrowser.setColorButton(false, false, 2);
                        fileBrowser.currClassify = hiMedia.fileType.pic;
                        UI.setImage(fileBrowserBG, "hiMedia/bg_photo.png");
                        for (var i = 0; i < hiMedia.fileBrowserPicData.length; i++) {
                            hiMedia.fileBrowserPicData[i].fileSelect = 1;
                        }
                        createjs.Tween.removeTweens(fileBrowserList);
                        fileBrowserList.removeAllChildren(true);
                        fileBrowser.fileStack[hiMedia.curFilePath]
                            = hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserPicData);
                        fileBrowser.createFileList(fileBrowser.allPic
                            .concat(hiMedia.fileBrowserFileData)
                            .concat(hiMedia.fileBrowserPicData), true);
                        if (fileBrowser.fileBrowserData.length == 0) {
                            DBG_INFO("setFilterType, list mode no data, type:" + type);
                            UI.focusTo(filterLableContainer);
                        }
                        break;
                    case hiMedia.fileType.music:
                        fileBrowser.enableColorButton(true, false, true);
                        fileBrowser.setColorButton(false, false, 0);
                        fileBrowser.currClassify = hiMedia.fileType.music;
                        UI.setImage(fileBrowserBG, "hiMedia/bg_music.png");
                        for (var i = 0; i < hiMedia.fileBrowserMusicData.length; i++) {
                            hiMedia.fileBrowserMusicData[i].fileSelect = 1;
                        }
                        createjs.Tween.removeTweens(fileBrowserList);
                        fileBrowserList.removeAllChildren(true);
                        fileBrowser.fileStack[hiMedia.curFilePath]
                            = hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserMusicData);
                        //fileBrowser.selectedMusicStack[hiMedia.curFilePath] = [].concat(hiMedia.fileBrowserMusicData);
                        fileBrowser.createFileList(fileBrowser.allMusic
                            .concat(hiMedia.fileBrowserFileData)
                            .concat(hiMedia.fileBrowserMusicData), true);
                        if (fileBrowser.fileBrowserData.length == 0) {
                            DBG_INFO("setFilterType, list mode no data, type:" + type);
                            UI.focusTo(filterLableContainer);
                        }
                        break;
                    case hiMedia.fileType.video:
                        fileBrowser.enableColorButton(true, false, false);
                        fileBrowser.setColorButton(false, false, 2);
                        fileBrowser.currClassify = hiMedia.fileType.video;
                        UI.setImage(fileBrowserBG, "hiMedia/bg_video.png");
                        for (var i = 0; i < hiMedia.fileBrowserVideoData.length; i++) {
                            hiMedia.fileBrowserVideoData[i].fileSelect = 1;
                        }
                        createjs.Tween.removeTweens(fileBrowserList);
                        fileBrowserList.removeAllChildren(true);
                        fileBrowser.fileStack[hiMedia.curFilePath]
                            = hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserVideoData);
                        //fileBrowser.selectedVideoStack[hiMedia.curFilePath] = [].concat(hiMedia.fileBrowserVideoData);
                        fileBrowser.createFileList(fileBrowser.allVideo
                            .concat(hiMedia.fileBrowserFileData)
                            .concat(hiMedia.fileBrowserVideoData), true);
                        if (fileBrowser.fileBrowserData.length == 0) {
                            DBG_INFO("setFilterType, list mode no data, type:" + type);
                            UI.focusTo(filterLableContainer);
                        }
                        break;

                    default :
                        break;
                }
            } catch (ex) {
                DBG_ERROR("list mode, setFilterType error:" + ex.message);
            }
        } else {
            if (!fileBrowser.searchMode) {
                try {
                    switch (type) {
                        case hiMedia.fileType.all:
                            fileBrowser.currClassify = hiMedia.fileType.all;
                            fileBrowser.setColorButton(true, false, 1);
                            UI.setImage(fileBrowserBG, "hiMedia/bg_all.png");
                            createjs.Tween.removeTweens(fileBrowserList);
                            fileBrowserList.removeAllChildren(true);
                            fileBrowser.fileStack[hiMedia.curFilePath] = fileBrowser.fileBrowserData = hiMedia.fileBrowserAllData;
                            fileBrowser.createFileList(fileBrowser.fileBrowserData, true);
                            if (hiMedia.fileBrowserAllData.length == 0) {
                                DBG_INFO("setFilterType, no data, type:" + type);
                                UI.focusTo(filterLableContainer);
                            }
                            break;
                        case hiMedia.fileType.pic:
                            fileBrowser.currClassify = hiMedia.fileType.pic;
                            fileBrowser.setColorButton(true, false, 1);
                            UI.setImage(fileBrowserBG, "hiMedia/bg_photo.png");
                            createjs.Tween.removeTweens(fileBrowserList);
                            fileBrowserList.removeAllChildren(true);
                            fileBrowser.fileStack[hiMedia.curFilePath] = fileBrowser.fileBrowserData
                                = hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserPicData);
                            fileBrowser.createFileList(fileBrowser.fileBrowserData, true);
                            if (fileBrowser.fileBrowserData.length == 0) {
                                DBG_INFO("setFilterType, no data, type:" + type);
                                UI.focusTo(filterLableContainer);
                            }
                            break;
                        case hiMedia.fileType.music:
                            fileBrowser.currClassify = hiMedia.fileType.music;
                            fileBrowser.setColorButton(true, false, 1);
                            UI.setImage(fileBrowserBG, "hiMedia/bg_music.png");
                            createjs.Tween.removeTweens(fileBrowserList);
                            fileBrowserList.removeAllChildren(true);
                            fileBrowser.fileStack[hiMedia.curFilePath] = fileBrowser.fileBrowserData
                                = hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserMusicData);
                            fileBrowser.createFileList(fileBrowser.fileBrowserData, true);
                            if (fileBrowser.fileBrowserData.length == 0) {
                                DBG_INFO("setFilterType, no data, type:" + type);
                                UI.focusTo(filterLableContainer);
                            }
                            break;
                        case hiMedia.fileType.video:
                            fileBrowser.currClassify = hiMedia.fileType.video;
                            fileBrowser.setColorButton(true, false, 1);
                            UI.setImage(fileBrowserBG, "hiMedia/bg_video.png");
                            createjs.Tween.removeTweens(fileBrowserList);
                            fileBrowserList.removeAllChildren(true);
                            fileBrowser.fileStack[hiMedia.curFilePath] = fileBrowser.fileBrowserData
                                = hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserVideoData);
                            fileBrowser.createFileList(fileBrowser.fileBrowserData, true);
                            if (fileBrowser.fileBrowserData.length == 0) {
                                DBG_INFO("setFilterType, no data, type:" + type);
                                UI.focusTo(filterLableContainer);
                            }
                            break;

                        default :
                            break;
                    }
                } catch (ex) {
                    DBG_ERROR("setFilterType:" + ex.message);
                }
            } else {
                // search mode
                try {
                    switch (type) {
                        case hiMedia.fileType.all:
                            fileBrowser.currClassify = hiMedia.fileType.all;
                            UI.setImage(fileBrowserBG, "hiMedia/bg_all.png");
                            createjs.Tween.removeTweens(fileBrowserList);
                            fileBrowserList.removeAllChildren(true);
                            fileBrowser.createFileList(hiMedia.fileBrowserSearchedAllData, true);
                            if (hiMedia.fileBrowserSearchedAllData.length == 0) {
                                DBG_INFO("search mode, setFilterType, no data, type:" + type);
                                FBSearchInputTip.alpha = 1;
                                UI.focusTo(filterLableContainer);
                            } else {
                                FBSearchInputTip.alpha = 0;
                            }
                            break;
                        case hiMedia.fileType.pic:
                            fileBrowser.currClassify = hiMedia.fileType.pic;
                            UI.setImage(fileBrowserBG, "hiMedia/bg_photo.png");
                            createjs.Tween.removeTweens(fileBrowserList);
                            fileBrowserList.removeAllChildren(true);
                            fileBrowser.createFileList(hiMedia.fileBrowserSearchedPicData, true);
                            if (hiMedia.fileBrowserSearchedPicData.length == 0) {
                                DBG_INFO("search mode, setFilterType, no data, type:" + type);
                                FBSearchInputTip.alpha = 1;
                                UI.focusTo(filterLableContainer);
                            } else {
                                FBSearchInputTip.alpha = 0;
                            }
                            break;
                        case hiMedia.fileType.music:
                            fileBrowser.currClassify = hiMedia.fileType.music;
                            UI.setImage(fileBrowserBG, "hiMedia/bg_music.png");
                            createjs.Tween.removeTweens(fileBrowserList);
                            fileBrowserList.removeAllChildren(true);
                            fileBrowser.createFileList(hiMedia.fileBrowserSearchedMusicData, true);
                            if (hiMedia.fileBrowserSearchedMusicData.length == 0) {
                                DBG_INFO("search mode, setFilterType, no data, type:" + type);
                                FBSearchInputTip.alpha = 1;
                                UI.focusTo(filterLableContainer);
                            } else {
                                FBSearchInputTip.alpha = 0;
                            }
                            break;
                        case hiMedia.fileType.video:
                            fileBrowser.currClassify = hiMedia.fileType.video;
                            UI.setImage(fileBrowserBG, "hiMedia/bg_video.png");
                            createjs.Tween.removeTweens(fileBrowserList);
                            fileBrowserList.removeAllChildren(true);
                            fileBrowser.createFileList(hiMedia.fileBrowserSearchedVideoData, true);
                            if (hiMedia.fileBrowserSearchedVideoData.length == 0) {
                                DBG_INFO("search mode, setFilterType, no data, type:" + type);
                                FBSearchInputTip.alpha = 1;
                                UI.focusTo(filterLableContainer);
                            } else {
                                FBSearchInputTip.alpha = 0;
                            }
                            break;

                        default :
                            break;
                    }
                } catch (ex) {
                    DBG_ERROR("search mode, setFilterType:" + ex.message);
                }
            }
        }
        UI.updateStage();
    };

    filterList.onkey_UP = function () {
        DBG_ALWAYS("filterList.onkey_UP");
        var idx = filterList.initSequence.indexOf(UI.getCurrFocus());
        if (idx == 0) {
            UI.focusTo(filterLableContainer);
        } else {
            return true;
        }
    };

    filterList.onkey_BACKSPACE = function () {
        DBG_ALWAYS("filterList.onkey_BACKSPACE");
        UI.focusTo(filterLableContainer);
        filterList.visible = false;
        filterLableContainerBg.visible = false;
    };

    /*
     * handle event of the sort type.
     * include: onFocus, onkey_DOWN, onkey_RIGHT,
     * onkey_BACKSPACE, onkey_ENTER
     */
    var sortTypeArray = ["[SE1836]", "[OT0398]", "[SE0753]"];

    sortLableContainer.onFocus = function () {
        DBG_ALWAYS("sortLableContainer.onFocus");
        UI.setImage(sortLableBg, "hiMedia/filter_list_bg.png");
        UI.base.cursor.alpha = 0;
        UI.base.runText(fileBrowser.currFocus);
    };

    sortLableContainer.onNormal = function () {
        DBG_ALWAYS("sortLableContainer.onNormal");
        UI.setImage(sortLableBg, "hiMedia/fileList_bak.png");
        UI.base.stopText(fileBrowser.currFocus);
    };

    sortLableContainer.onkey_DOWN = function () {
        DBG_ALWAYS("sortLableContainer.onkey_DOWN, visible = " + filterList.visible);
        if (sortTypeList.visible) {
            UI.focusTo(sortTypeList.initSequence[0]);
        } else {
            if (fileBrowserList.children.length > 0) {
                UI.focusTo(fileBrowserList.initSequence[0]);
                UI.moveCursor(UI.adjustView());
                UI.base.cursor.alpha = 1;
                UI.base.cursor.visible = true;
            }
        }
    };

    sortLableContainer.onkey_RIGHT = function () {
        DBG_ALWAYS("sortLableContainer.onkey_RIGHT, sortTypeList.visible: " + sortTypeList.visible);
        UI.focusTo(filterLableContainer);
        if (sortTypeList.visible) {
            sortTypeList.visible = false;
            fileSortContainerBg.visible = false;
        }
    };

    sortLableContainer.onkey_LEFT = function () {
        DBG_ALWAYS("sortLableContainer.onkey_LEFT, sortTypeList.visible:" + sortTypeList.visible);
        if (sortTypeList.visible) {
            sortTypeList.visible = false;
            fileSortContainerBg.visible = false;
        }
        // focus to search widge.
        if (hiMedia.currentDevice == hiMedia.device.usb) {
            UI.focusTo(FBSearchInput);
            //UI.base.cursor.visible = false;
            UI.base.cursor.alpha = 0;
        } else {
            return false;
        }
    };

    sortLableContainer.onkey_BACKSPACE = function () {
        DBG_ALWAYS("sortLableContainer.onkey_BACKSPACE");
        if (sortTypeList.visible) {
            sortTypeList.visible = false;
            fileSortContainerBg.visible = false;
        }
        return true;
    };
    var sortListCreated = false;
    sortLableContainer.onkey_ENTER = function () {
        DBG_ALWAYS("sortLableContainer.onkey_ENTER, visible = " + sortTypeList.visible
            + ", sortListCreated = " + sortListCreated);
        if (sortTypeList.visible) {
            sortTypeList.visible = false;
            fileSortContainerBg.visible = false;
        } else {
            sortTypeList.visible = true;
            fileSortContainerBg.visible = true;
            if (!sortListCreated) {
                sortListCreated = fileBrowser.createSortList(sortTypeArray, sortTypeList);
            }
        }
        UI.updateStage();
    };

    fileBrowser.createSortList = function (menuData, sortTypeList) {
        DBG_INFO("createSortList: " + sortTypeList.name);
        var array = [];
        if (menuData.length > 0) {
            for (var i = 0; i < menuData.length; i++) {
                var data = {
                    //itemBg: UI.item_bg,
                    itemBg: "hiMedia/fileList_bak.png",
                    itemText: menuData[i],
                    name: sortTypeList.name + i
                };
                array.push(data);
            }
            var info = {
                template: "hiMedia_fileBrowser_FilterItem",
                direction: CONST.GIRD_DIRECTION.H,
                breakNum: 1,
                distanceX: 0,
                distanceY: 0,
                container: sortTypeList
            };
            Gird.create(array, info);
            return true;
        }
        return false;
    };

    sortTypeList.onFocus = function (focus) {
        var idx = sortTypeList.initSequence.indexOf(UI.getCurrFocus());
        DBG_ALWAYS("sortTypeList.onFocus, idx: " + idx);
        if (idx == -1) {
            idx = 0;
        }
        var itemBg = UI.getItem(sortTypeList.initSequence[idx], "itemBg");
        if (GLOBAL.HICONTRAST) {
            UI.setImage(itemBg, "hiMedia/filter_list_bg_black.png");
        }
        else {
            UI.setImage(itemBg, "hiMedia/filter_list_bg.png");
        }
        UI.base.runText(fileBrowser.currFocus);
        return true;
    };

    sortTypeList.onNormal = function (focus) {
        DBG_ALWAYS("filterList.onNormal");
        //reset last item background.
        for (var i = 0; i < sortTypeList.initSequence.length; i++) {
            var itemBg = UI.getItem(sortTypeList.initSequence[i], "itemBg");
            UI.setImage(itemBg, "hiMedia/fileList_bak.png");
            UI.base.stopText(fileBrowser.currFocus);
        }
        return true;
    };

    sortTypeList.onkey_ENTER = function () {
        var idx = sortTypeList.initSequence.indexOf(UI.getCurrFocus());
        DBG_ALWAYS("filterList.onkey_ENTER, idx: " + idx);
        if (idx == -1) {
            idx = 0;
        }
        sortTypeList.onNormal();
        sortTypeList.visible = false;
        fileSortContainerBg.visible = false;
        if ((hiMedia.currentSortType == "name" && idx == 0)
            || (hiMedia.currentSortType == "time" && idx == 1)
            || (hiMedia.currentSortType == "size" && idx == 2)) {
            DBG_INFO("sortTypeList.onkey_ENTER, sort type no change");
            UI.focusTo(sortLableContainer);
            return false;
        }
        fileBrowser.setSortType(idx);
        UI.setText(sortLable, sortTypeArray[idx]);
    };

    fileBrowser.setSortType = function (type) {
        DBG_INFO("setSortType, listMode: " + fileBrowser.listMode + ", type:" + type);
        DBG_ALWAYS("fileBrowser.setSortType, hiMedia.currentSortType : " + hiMedia.currentSortType);
        if (fileBrowser.listMode) {
            switch (type) {
                case 0:
                    if (!!hiMedia.fileBrowserFileData) {
                        hiMedia.fileBrowserFileData = sortContent(hiMedia.fileBrowserFileData, "name");
                    }
                    if (!!hiMedia.fileBrowserPicData) {
                        hiMedia.fileBrowserPicData = sortContent(hiMedia.fileBrowserPicData, "name");
                    }
                    if (!!hiMedia.fileBrowserMusicData) {
                        hiMedia.fileBrowserMusicData = sortContent(hiMedia.fileBrowserMusicData, "name");
                    }
                    if (!!hiMedia.fileBrowserVideoData) {
                        hiMedia.fileBrowserVideoData = sortContent(hiMedia.fileBrowserVideoData, "name");
                    }
                    hiMedia.currentSortType = "name";
                    break;
                case 1:
                    if (!!hiMedia.fileBrowserFileData) {
                        hiMedia.fileBrowserFileData = sortContent(hiMedia.fileBrowserFileData, "time");
                    }
                    if (!!hiMedia.fileBrowserPicData) {
                        hiMedia.fileBrowserPicData = sortContent(hiMedia.fileBrowserPicData, "time");
                    }
                    if (!!hiMedia.fileBrowserMusicData) {
                        hiMedia.fileBrowserMusicData = sortContent(hiMedia.fileBrowserMusicData, "time");
                    }
                    if (!!hiMedia.fileBrowserVideoData) {
                        hiMedia.fileBrowserVideoData = sortContent(hiMedia.fileBrowserVideoData, "time");
                    }
                    hiMedia.currentSortType = "time";
                    break;
                case 2:
                    if (!!hiMedia.fileBrowserFileData) {
                        //file类型的size 大小无法获取，所以返回时默认按照name排序。
                        hiMedia.fileBrowserFileData = sortContent(hiMedia.fileBrowserFileData, "name");
                    }
                    if (!!hiMedia.fileBrowserPicData) {
                        hiMedia.fileBrowserPicData = sortContent(hiMedia.fileBrowserPicData, "size");
                    }
                    if (!!hiMedia.fileBrowserMusicData) {
                        hiMedia.fileBrowserMusicData = sortContent(hiMedia.fileBrowserMusicData, "size");
                    }
                    if (!!hiMedia.fileBrowserVideoData) {
                        hiMedia.fileBrowserVideoData = sortContent(hiMedia.fileBrowserVideoData, "size");
                    }
                    hiMedia.currentSortType = "size";
                    break;
                default :
                    break;
            }
            hiMedia.fileBrowserAllData = [];
            hiMedia.fileBrowserAllData =
                hiMedia.fileBrowserAllData.concat(hiMedia.fileBrowserFileData).
                    concat(hiMedia.fileBrowserVideoData).concat(hiMedia.fileBrowserMusicData).
                    concat(hiMedia.fileBrowserPicData);
            switch (fileBrowser.currClassify) {
                case hiMedia.fileType.all:
                    // not support in all type
                    fileBrowserList.removeAllChildren(true);
                    fileBrowser.createFileList(hiMedia.fileBrowserAllData, true);
                    if (fileBrowser.fileBrowserData.length == 0) {
                        DBG_INFO("setSortType, list mode no data, currClassify:" + fileBrowser.currClassify);
                        UI.focusTo(sortLableContainer);
                    }
                    break;
                case hiMedia.fileType.pic:
                    fileBrowserList.removeAllChildren(true);
                    fileBrowser.createFileList(fileBrowser.allPic
                        .concat(hiMedia.fileBrowserFileData)
                        .concat(hiMedia.fileBrowserPicData), true);
                    // there is a "all Pic" item in list mode.
                    if (fileBrowser.fileBrowserData.length == 1) {
                        DBG_INFO("setSortType, list mode no data, currClassify:" + fileBrowser.currClassify);
                        UI.focusTo(sortLableContainer);
                    }
                    break;
                case hiMedia.fileType.music:
                    fileBrowserList.removeAllChildren(true);
                    fileBrowser.createFileList(fileBrowser.allMusic
                        .concat(hiMedia.fileBrowserFileData)
                        .concat(hiMedia.fileBrowserMusicData), true);
                    // there is a "all music" item in list mode.
                    if (fileBrowser.fileBrowserData.length == 1) {
                        DBG_INFO("setSortType, list mode no data, currClassify:" + fileBrowser.currClassify);
                        UI.focusTo(sortLableContainer);
                    }
                    break;
                case hiMedia.fileType.video:
                    fileBrowserList.removeAllChildren(true);
                    fileBrowser.createFileList(fileBrowser.allVideo
                        .concat(hiMedia.fileBrowserFileData)
                        .concat(hiMedia.fileBrowserVideoData), true);
                    // there is a "all video" item in list mode.
                    if (fileBrowser.fileBrowserData.length == 1) {
                        DBG_INFO("setSortType, list mode no data, currClassify:" + fileBrowser.currClassify);
                        UI.focusTo(sortLableContainer);
                    }
                    break;
                default :
                    break;
            }
        } else {
            if (!fileBrowser.searchMode) {
                switch (type) {
                    case 0:
                        if (!!hiMedia.fileBrowserFileData) {
                            hiMedia.fileBrowserFileData = sortContent(hiMedia.fileBrowserFileData, "name");
                        }
                        if (!!hiMedia.fileBrowserPicData) {
                            hiMedia.fileBrowserPicData = sortContent(hiMedia.fileBrowserPicData, "name");
                        }
                        if (!!hiMedia.fileBrowserMusicData) {
                            hiMedia.fileBrowserMusicData = sortContent(hiMedia.fileBrowserMusicData, "name");
                        }
                        if (!!hiMedia.fileBrowserVideoData) {
                            hiMedia.fileBrowserVideoData = sortContent(hiMedia.fileBrowserVideoData, "name");
                        }
                        hiMedia.currentSortType = "name";
                        break;
                    case 1:
                        if (!!hiMedia.fileBrowserFileData) {
                            hiMedia.fileBrowserFileData = sortContent(hiMedia.fileBrowserFileData, "time");
                        }
                        if (!!hiMedia.fileBrowserPicData) {
                            hiMedia.fileBrowserPicData = sortContent(hiMedia.fileBrowserPicData, "time");
                        }
                        if (!!hiMedia.fileBrowserMusicData) {
                            hiMedia.fileBrowserMusicData = sortContent(hiMedia.fileBrowserMusicData, "time");
                        }
                        if (!!hiMedia.fileBrowserVideoData) {
                            hiMedia.fileBrowserVideoData = sortContent(hiMedia.fileBrowserVideoData, "time");
                        }
                        hiMedia.currentSortType = "time";
                        break;
                    case 2:
                        if (!!hiMedia.fileBrowserFileData) {
                            //file类型的size 大小无法获取，所以返回时默认按照name排序。
                            hiMedia.fileBrowserFileData = sortContent(hiMedia.fileBrowserFileData, "name");
                        }
                        if (!!hiMedia.fileBrowserPicData) {
                            hiMedia.fileBrowserPicData = sortContent(hiMedia.fileBrowserPicData, "size");
                        }
                        if (!!hiMedia.fileBrowserMusicData) {
                            hiMedia.fileBrowserMusicData = sortContent(hiMedia.fileBrowserMusicData, "size");
                        }
                        if (!!hiMedia.fileBrowserVideoData) {
                            hiMedia.fileBrowserVideoData = sortContent(hiMedia.fileBrowserVideoData, "size");
                        }
                        hiMedia.currentSortType = "size";
                        break;
                    default :
                        break;
                }
                hiMedia.fileBrowserAllData = [];
                hiMedia.fileBrowserAllData =
                    hiMedia.fileBrowserAllData.concat(hiMedia.fileBrowserFileData).
                        concat(hiMedia.fileBrowserVideoData).concat(hiMedia.fileBrowserMusicData).
                        concat(hiMedia.fileBrowserPicData);
                switch (fileBrowser.currClassify) {
                    case hiMedia.fileType.all:
                        fileBrowserList.removeAllChildren(true);
                        fileBrowser.createFileList(hiMedia.fileBrowserAllData, true);
                        if (fileBrowser.fileBrowserData.length == 0) {
                            DBG_INFO("setSortType, no data, currClassify:" + fileBrowser.currClassify);
                            UI.focusTo(sortLableContainer);
                        }
                        break;
                    case hiMedia.fileType.pic:
                        fileBrowserList.removeAllChildren(true);
                        fileBrowser.createFileList(hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserPicData), true);
                        if (fileBrowser.fileBrowserData.length == 0) {
                            DBG_INFO("setSortType, no data, currClassify:" + fileBrowser.currClassify);
                            UI.focusTo(sortLableContainer);
                        }
                        break;
                    case hiMedia.fileType.music:
                        fileBrowserList.removeAllChildren(true);
                        fileBrowser.createFileList(hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserMusicData), true);
                        if (fileBrowser.fileBrowserData.length == 0) {
                            DBG_INFO("setSortType, no data, currClassify:" + fileBrowser.currClassify);
                            UI.focusTo(sortLableContainer);
                        }
                        break;
                    case hiMedia.fileType.video:
                        fileBrowserList.removeAllChildren(true);
                        fileBrowser.createFileList(hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserVideoData), true);
                        if (fileBrowser.fileBrowserData.length == 0) {
                            DBG_INFO("setSortType, no data, currClassify:" + fileBrowser.currClassify);
                            UI.focusTo(sortLableContainer);
                        }
                        break;
                    default :
                        break;
                }
            } else {
                // search mode.
                switch (type) {
                    case 0:
                        if (!!hiMedia.fileBrowserSearchedPicData) {
                            hiMedia.fileBrowserSearchedPicData = sortContent(hiMedia.fileBrowserSearchedPicData, "name");
                        }
                        if (!!hiMedia.fileBrowserSearchedMusicData) {
                            hiMedia.fileBrowserSearchedMusicData = sortContent(hiMedia.fileBrowserSearchedMusicData, "name");
                        }
                        if (!!hiMedia.fileBrowserSearchedVideoData) {
                            hiMedia.fileBrowserSearchedVideoData = sortContent(hiMedia.fileBrowserSearchedVideoData, "name");
                        }
                        hiMedia.currentSortType = "name";
                        break;
                    case 1:
                        if (!!hiMedia.fileBrowserSearchedPicData) {
                            hiMedia.fileBrowserSearchedPicData = sortContent(hiMedia.fileBrowserSearchedPicData, "time");
                        }
                        if (!!hiMedia.fileBrowserSearchedMusicData) {
                            hiMedia.fileBrowserSearchedMusicData = sortContent(hiMedia.fileBrowserSearchedMusicData, "time");
                        }
                        if (!!hiMedia.fileBrowserSearchedVideoData) {
                            hiMedia.fileBrowserSearchedVideoData = sortContent(hiMedia.fileBrowserSearchedVideoData, "time");
                        }
                        hiMedia.currentSortType = "time";
                        break;
                    case 2:
                        if (!!hiMedia.fileBrowserSearchedPicData) {
                            hiMedia.fileBrowserSearchedPicData = sortContent(hiMedia.fileBrowserSearchedPicData, "size");
                        }
                        if (!!hiMedia.fileBrowserSearchedMusicData) {
                            hiMedia.fileBrowserSearchedMusicData = sortContent(hiMedia.fileBrowserSearchedMusicData, "size");
                        }
                        if (!!hiMedia.fileBrowserSearchedVideoData) {
                            hiMedia.fileBrowserSearchedVideoData = sortContent(hiMedia.fileBrowserSearchedVideoData, "size");
                        }
                        hiMedia.currentSortType = "size";
                        break;
                    default :
                        break;
                }
                hiMedia.fileBrowserSearchedAllData = [];
                hiMedia.fileBrowserSearchedAllData =
                    hiMedia.fileBrowserSearchedVideoData.concat(hiMedia.fileBrowserSearchedMusicData).
                        concat(hiMedia.fileBrowserSearchedPicData);
                switch (fileBrowser.currClassify) {
                    case hiMedia.fileType.all:
                        fileBrowserList.removeAllChildren(true);
                        fileBrowser.createFileList(hiMedia.fileBrowserSearchedAllData, true);
                        if (fileBrowser.fileBrowserData.length == 0) {
                            DBG_INFO("search mode, setSortType, no data, currClassify:" + fileBrowser.currClassify);
                            UI.focusTo(sortLableContainer);
                        }
                        break;
                    case hiMedia.fileType.pic:
                        fileBrowserList.removeAllChildren(true);
                        fileBrowser.createFileList(hiMedia.fileBrowserSearchedPicData, true);
                        if (fileBrowser.fileBrowserData.length == 0) {
                            DBG_INFO("search mode, setSortType, no data, currClassify:" + fileBrowser.currClassify);
                            UI.focusTo(sortLableContainer);
                        }
                        break;
                    case hiMedia.fileType.music:
                        fileBrowserList.removeAllChildren(true);
                        fileBrowser.createFileList(hiMedia.fileBrowserSearchedMusicData, true);
                        if (fileBrowser.fileBrowserData.length == 0) {
                            DBG_INFO("search mode, setSortType, no data, currClassify:" + fileBrowser.currClassify);
                            UI.focusTo(sortLableContainer);
                        }
                        break;
                    case hiMedia.fileType.video:
                        fileBrowserList.removeAllChildren(true);
                        fileBrowser.createFileList(hiMedia.fileBrowserSearchedVideoData, true);
                        if (fileBrowser.fileBrowserData.length == 0) {
                            DBG_INFO("search mode, setSortType, no data, currClassify:" + fileBrowser.currClassify);
                            UI.focusTo(sortLableContainer);
                        }
                        break;
                    default :
                        break;
                }
            }
        }
    };

    sortTypeList.onkey_UP = function () {
        DBG_ALWAYS("sortTypeList.onkey_UP");
        var idx = sortTypeList.initSequence.indexOf(UI.getCurrFocus());
        if (idx == 0) {
            UI.focusTo(sortLableContainer);
        } else {
            return true;
        }
    };

    sortTypeList.onkey_BACKSPACE = function () {
        DBG_ALWAYS("sortTypeList.onkey_BACKSPACE");
        UI.focusTo(sortLableContainer);
        sortTypeList.visible = false;
        fileSortContainerBg.visible = false;
    };
    function beginThumb() {
        DBG_INFO("beginThumb");
        thumbNailCount = 0;
        thumbNailArray = [];
//        var tmpObj = {};
//        for (var i = 0; i < (array.length <= count ? array.length : count); i++) {
//            if (array[i].fileType != "file") {
//                tmpObj = {
//                    "container": container.initSequence[i],
//                    "content": array[i]
//                };
//                thumbNailCount++;
//                thumbNailArray.push(tmpObj);
//            }
//        }
//        if (thumbNailCount > 0) {
//            getThumbNail(thumbNailArray[0].content);
//        }
    }

    function continueThumbNail(focus, array, container, count) {
        DBG_INFO("continueThumbNail  " + thumbNailCount);
        if (thumbNailCount == 0) {
            var currThumbIndex = container.initSequence.indexOf(focus);
            //if (!hasThumbNail(array[currThumbIndex].filePath)) {//当前页中有可能有没有获取的缩略图，不能只判断当前焦点,放开这个条件让获取时判断。
            beginThumb();
            var tmpObj = {};
            for (var i = (currThumbIndex - count > 0 ? currThumbIndex - count : 0); i < (array.length <= (currThumbIndex + count + count) ? array.length : (currThumbIndex + count + count)); i++) {
                if (array[i].fileType == "video" || array[i].fileType == "pic" || array[i].fileType == "music") {
                    tmpObj = {
                        "container": container.initSequence[i],
                        "content": array[i]
                    };
                    thumbNailCount++;
                    thumbNailArray.push(tmpObj);
                }
            }
            if (thumbNailCount > 0) {
                getThumbNail(thumbNailArray[0].content);
            }
            //}
        }
    }

    function setThumbNail(path) {
        if (!getThumbnailFlag()) {
            DBG_INFO("thumbNailCount is 0,just return;");//应对异步获取时突然返回上一页时清空thumbNailArray的情况。
            return;
        }
        DBG_INFO("setThumbNail:" + path + "count:" + thumbNailCount + "deleteThumbNailCount :" + deleteThumbNailCount);
        deleteThumbNailCount++;
        totalThumbNailArray.push({"filePath": thumbNailArray[thumbNailArray.length - thumbNailCount].content.filePath, "imgPath": path});
        if (path != "fail") {
            try {
                hiMedia.setThumbImage(thumbNailArray[thumbNailArray.length - thumbNailCount].container.children[1], path, true, 240, 180);
            }
            catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        thumbNailCount--;
        if (thumbNailCount > 0) {
            getThumbNail(thumbNailArray[thumbNailArray.length - thumbNailCount].content);
        } else {
            UI.updateStageDelay();
        }
    }

    var tmpUrl = "";

    function getThumbNail(obj) {
        if (!getThumbnailFlag()) {
            DBG_INFO("thumbNailCount is 0,just return;");//应对异步获取时突然返回上一页时清空thumbNailArray的情况。
            return;
        }
        //DBG_INFO("obj:" + obj.filePath);
        if (hasThumbNail(obj.filePath)) {
            thumbNailCount--;
            if (thumbNailCount > 0) {
                getThumbNail(thumbNailArray[thumbNailArray.length - thumbNailCount].content);
            }
            return;
        }
        deleteThumbNail();//放在get时删除可以避免设置图片时正好被删除的情况
        fileBrowser.startPicThumbnail = false;
        fileBrowser.startMusicThumbnail = false;
        fileBrowser.startVideoThumbnail = false;
        //var currentType = fileBrowser.fileBrowserData[currentIndex].fileType;
        switch (obj.fileType) {
            case "video":
                try {
                    fileBrowser.startVideoThumbnail = true;
                    var vUrl = obj.filePath + "?type=thumbnail&width=120&height=90&pos=15s";
                    tmpUrl = vUrl;
                    DBG_ALWAYS("setThumbnailUrl  :" + vUrl);
                    model.mpctrl.PlayMedia(vUrl, null, null, null, null, null, 4, null, null, null);
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
                break;
            case "music":
                try {
                    fileBrowser.startMusicThumbnail = true;
                    var mUrl = obj.filePath + "?type=thumbnail&width=240&height=180";
                    tmpUrl = mUrl;
                    DBG_ALWAYS("setThumbnailUrl  :" + mUrl);
                    model.mpctrl.PlayMedia(mUrl, null, null, null, null, null, 8, null, null, null);
//                    setThumbnailTimer = null;
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
                break;
            case "pic":
                try {
                    fileBrowser.startPicThumbnail = true;
                    var pUrl = obj.filePath + "?type=thumbnail&width=120&height=90";
                    tmpUrl = pUrl;
                    DBG_ALWAYS("setThumbnailUrl  :" + pUrl);
                    model.mpctrl.PlayMedia(pUrl, null, null, null, null, null, 16, null, null, null);
//                    setThumbnailTimer = null;
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
                break;
            case "file":
                break;
            default :
                break;
        }
    }

    //每超过100张时清tmp
    function deleteThumbNail(force) {
        if (deleteThumbNailCount > 72 || (!!force)) {

            try {
                model.mpctrl.DeleteThumbnail("all");
                // model.mpctrl.RemoveThumbFile("/tmp/VideoThumbNail/");
                // model.mpctrl.RemoveThumbFile("/tmp/ImageThumbNail/");
            }
            catch (ex) {
                DBG_ERROR(ex.message);
            }
            if(deleteThumbNailCount>72){
                try {
                    fileBrowserList.initSequence.forEach(
                        function(v,i,a){
                            if(!!v.children[1].originPic){
                                v.children[1].originPic ="hiMedia/file_type_icon_" + fileBrowser.fileBrowserData[i].fileType + ".png";
                            }
                        }
                    );
                    if(!!window.gc){
                        window.gc();
                    }else{
                        DBG_ERROR("window.gc unsupport!");
                    }
                }
                catch (ex) {
                    DBG_ERROR(ex.message);
                }
            }

            deleteThumbNailCount = 0;
            totalThumbNailArray = [];
        }
        else {
        }
    }

    function hasThumbNail(filePath) {
        if (totalThumbNailArray.length > 0) {
            for (var i = 0; i < totalThumbNailArray.length; i++) {
                if (totalThumbNailArray[i].filePath == filePath) {
                    return totalThumbNailArray[i].imgPath;
                }
            }
            return false;
        }
        return false;
    }

    fileBrowser.runtext = function (focus) {
        UI.base.runText(focus);
    }
    fileBrowserList.onFocus = function (focus) {
        DBG_INFO("fileBrowserList.onFocus");
        if (!!setThumbnailTimer) {
            clearTimeout(setThumbnailTimer);
        }
        setThumbnailTimer = setTimeout(function () {
            clearTimeout(setThumbnailTimer);
            setThumbnailTimer = null;
            continueThumbNail(focus, fileBrowser.fileBrowserData, fileBrowserList, 12);
        }, 1500);
        return true;
    }
    fileBrowser.resumeFileBrowser = function () {
        beginThumb();//提供一个reusmeFileBrowser的接口。
    }
    function getThumbnailFlag() {
        if (thumbNailCount > 0 && ((UI.getCurrSubModule() ? UI.getCurrSubModule().name : "") == "fileBrowser")) {
            return true;
        } else {
            return false;
        }
    }
};

