
UI.moduleBuilder['dlna']['dlnaToast'] = function(){

    var initData = {
        "dlnaToastBgImg": "toast/Toast_bg.png",
        "dlnaToastImg": "setting/Toast_ic_not_connected120x120.png",
        "dlnaToastText": ""
    };

    var template = Util.readJson("module/dlna/dlnaToast.json");
    var dlnaToast = SubModule.create(initData, template);
    var dlnaToastText = UI.getItem(dlnaToast, "dlnaToastText");

    var dlnaToastTimer = null;
    dlnaToast.onPush = function () {
        if (!!Dlna.toastText) {
            UI.setText(dlnaToastText, Dlna.toastText);
            UI.updateStage();
            if (!dlnaToastTimer) {
                dlnaToastTimer = setTimeout(function () {
                    UI.popGhostModule("dlnaToast");
                    dlnaToastTimer = null;
                }, 2000);
            }
        } else {
            DBG_ERROR("Nothing to toast!!!!");
            UI.popGhostModule("dlnaToast");
        }
    }
    dlnaToast.onPop = function () {
        //退出是清空TOAST
        Dlna.toastText = "";
    }
};