// Global Module Var
var dlna = window["dlna"];

// Init
(function () {
//    UI.pushSubModule("dlna","dlnaBlankPage",true);
})();

// Actions
(function () {
    //Dlna.deviceUuid = null;
    dlna.onPush = function () {
        try {
            UI.pushSubModule("dlna", "dlnaBlankPage", true);
            pauseDTV();
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.USB_DEVICE_CHANGED, dlna.onDlnaDeviceChanged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_DLNA_HTML5_PLAY_CHANGED, Dlna.onVstrHTML5PlayChanged);
            //UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_DLNA_METADATA_CHANGED, Dlna.onMetadataChanged);
            //model.cec.setIsMiracastExist(1);
        } catch (e) {
            DBG_ERROR("dlna.onPush " + e.message);
        }
    };
    dlna.onDlnaDeviceChanged = function (value) {
        var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
        DBG_INFO("[onDlnaDeviceChanged]value is :  " + value + "| currentSubModel= " + currentSubModel + "|Dlna.deviceUuid = " + Dlna.deviceUuid);
        var deviceType = value[0];
        var diviceId = value[1];
        var eventType = value[4];
        if (!!Dlna.deviceUuid && (!!diviceId)
            && eventType == VolumeModelDefines.SL2_TVAPI_VOLUME_FSAL2_MEDIA_TYPE_UPNP
            && deviceType == VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_REMOVED) {
            DBG_INFO("[onDlnaDeviceChanged]: step 1 .");
            if ((diviceId.indexOf(Dlna.deviceUuid) != -1 || Dlna.deviceUuid == "unknown") && (
                currentSubModel == "dlnaMusicPlayer" ||
                    currentSubModel == "dlnaPicPlayer" ||
                    currentSubModel == "dlnaVideoPlayer"
                )) {
                //UUID REMOVED
                DBG_INFO("[onDlnaDeviceChanged]: step 2 .");
//                UI.popAllModule();//MSD6586US-5874
//                try {
//                    openLiveTVModule([Msg.INFO, 0]);
//                } catch (e) {
//                    DBG_ERROR(e.message);
//                }
            }

        }
    }
    dlna.onShow = function () {
        UI.base.cursor.alpha = 0;
    };
    dlna.onExit = function () {
        Dlna.endLoading("popModule dlna");
    }

    dlna.onPop = function () {
        try {
            //model.cec.setIsMiracastExist(0);
            resumeDTV(500);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.USB_DEVICE_CHANGED, dlna.onDlnaDeviceChanged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_DLNA_HTML5_PLAY_CHANGED, Dlna.onVstrHTML5PlayChanged);
            Dlna.deviceUuid = null;
            Dlna.renderLock = false;
            UI.unlockAllKeys("dlnaExit");
            //UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_DLNA_METADATA_CHANGED, Dlna.onMetadataChanged);
        } catch (e) {
            DBG_ERROR("dlna.onExit" + e.message);
        }
    }
})();