/**
 * Created by jiangbo1 on 2016/3/4.
 */


UI.moduleBuilder['common']['standbyControl'] = function(){
    /*default data*/
    var template = Util.readJson("module/common/standbyControl.json");
    var standbyControlData = {
        standby_bg: UI.window_bg,
        standbyImg: GLOBAL.IMAGE_LIST.ALERT,
        cancel_bg: UI.item_bg,
        standbyCancelText: "[SE3073]",
        cancel_text: "[GE0008]"
    };
    var standbyControl = SubModule.create(standbyControlData, template);
    standbyControl.protected = true;
    var standbyTip = UI.getItem(standbyControl, "standbyTip");
    var cancel_text = UI.getItem(standbyControl, "cancel_text");
    var CALLMODE;
    var cancelBtn = UI.getItem(standbyControl, "cancelBtn");
    cancelBtn.alpha = 0;
    standbyControl.currFocus = cancelBtn;
    var standby = UI.setString("[SE2510] [SE3073]");
    UI.setText(standbyTip,"[SE2510]");
    var powerOffTimer = 0;

    standbyControl.onShow = function () {
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.alpha = 0;
        CALLMODE = true;
    };


    standbyControl.onFocus = function (focus) {
       // onFocusLiveTVTarget(focus, 1, 05, 500);
        if(GLOBAL.TTS){
            if(CALLMODE){
                UI.callTTS(standby);
                CALLMODE = false;
            }
            else{
                if (focus.voiceStr) {
                    UI.callTTS(focus.voiceStr);
                } else {
                    UI.callTTS(UI.base.getVoiceStr(focus))
                }
            }
        }
//        return true;
    }
    standbyControl.onNormal = function (focus) {
        //onNormalLiveTVTarget(focus, 1, 500);
        return true;
    }




    standbyControl.onkey = function () {
        DBG_ALWAYS("cancel switch off");
        switch (GLOBAL.STANDBY_FLAG) {
            case StandbyFlag.NO_SIGNAL:
            case StandbyFlag.AUTO_SLEEP:
               // liveTV.showLiveTVUI();
                break;
            case StandbyFlag.HOTELMODE_SLEEP:
                model.timerfunc.setHotelmodeSleepTimer(0);
                break;
            case StandbyFlag.STANDBY_TIME:
                if( 1==model.timerfunc.getStandbyMode()){
                    model.timerfunc.setStandbyMode(0);
                }
                break;
            default :
                break;

        }
        closeMsgBox();
        GLOBAL.STANDBY_FLAG = StandbyFlag.NONE;
    }

    function startPowerOffTimer(remainTime) {
        powerOffTimer = setInterval(function () {

            setReplacedText(--remainTime);
            if (0 == remainTime) {
                clearInterval(powerOffTimer);
                DBG_INFO("time is over, power off. standby flag[" + GLOBAL.STANDBY_FLAG + "]");
                closeMsgBox();
                var type=0;
                switch (GLOBAL.STANDBY_FLAG) {
                    case StandbyFlag.NO_SIGNAL:
                    case StandbyFlag.AUTO_SLEEP:
                        type=3;
                        break;
                    case StandbyFlag.HOTELMODE_SLEEP:
                        type=2;
                        break;
                    case StandbyFlag.STANDBY_TIME:
                        if( 1==model.timerfunc.getStandbyMode()){
                            model.timerfunc.setStandbyMode(0);
                        }
                        type=2;
                        break;
                    default :
                        break;
                }
               if(Config.tv)switchOffTV(type);
                GLOBAL.STANDBY_FLAG = StandbyFlag.NONE;
            }
        }, 950);
    }

    function setReplacedText(x){
        try{
            UI.setText(standbyTip, Config.language[standbyTip.TIP].replace("X", x));
        }
        catch (ex){
            UI.setText(standbyTip, "[" + standbyTip.TIP + "]");
            DBG_ERROR(ex.message);
        }
    }

    standbyControl.onPush = function () {
        standbyTip.TIP = "SE2510";
        setReplacedText(60);
        startPowerOffTimer(60);
        registerKeyCodesForUI();
    }

    standbyControl.onPop = function () {
        clearInterval(powerOffTimer);
        var cancelBtn = UI.getItem(standbyControl, "cancelBtn");
        cancelBtn.scale.x = 1;
        cancelBtn.scale.y = 1;
        UI.base.cursor.scale.x = 1;
        UI.base.cursor.scale.y = 1;
        UI.base.cursor.alpha = 0;
        if(!!GLOBAL.MEDIA_STARTUP_FLAG){
            hiMedia.changeByLauncher("resume");
        }
    }

};
