/**
 * Created by Brad on 2016/5/11.
 */

UI.moduleBuilder['common']['networkTip'] = function(){
    /*default data*/
    var template = Util.readJson("module/common/networkTip.json");
    var networkTipData = {
        network_bg: UI.window_bg,
        btn_left_bg: UI.item_bg,
        btn_right_bg: UI.item_bg,
        btn_right_text: "[GE0008]",
        btn_left_text: "[LA0082]",
        networkTipContent: Config.language["LA0080"] + " " + Config.language["LA0081"]
    };

    var networkTip = SubModule.create(networkTipData, template);
    networkTip.protected = true;
    var BtnRight = UI.getItem(networkTip, "BtnRight");
    var BtnLeft = UI.getItem(networkTip, "BtnLeft");
    networkTip.currFocus = BtnLeft;
//    BtnRight.alpha = BtnLeft.alpha = 0.6;
//    UI.getItem(networkTip, "networkTipContent").alpha = 0.6;

    networkTip.onFocus = function (focus) {
        if (focus.voiceStr) {
            UI.callTTS(focus.voiceStr);
        } else {
            UI.callTTS(UI.base.getVoiceStr(focus))
        }
        return true;
    }
    //
    //networkTip.onNormal = function (focus) {
    //    DBG_INFO("network_onNormal");
    //    onNormalLiveTVTarget(focus, 0.6, 500);
    //}

    BtnLeft.onkey_ENTER = function () {
        UI.popSubModule();
        //open DMP module
        //UI.pushSubModule("hiMedia", "deviceBrowser", true);
        UI.popAllModule();
        UI.pushSubModule("setting", "networkMainPanel", true, {caller: "networkTip"});
    }
    //问题：交流应用一键开机，无网络，这种状态下opera4x不会被初始化
    networkTip.onPush = function () {
        if (GLOBAL.NEED_START_OPERA4X) {
            DBG_ERROR("NEED_START_OPERA4X");
            sendAM(":am,am,:start=opera4x","opera4x","start","");
            GLOBAL.NEED_START_OPERA4X = false;
        }
        clearOpenFromStandbyFlag();
    }

    networkTip.afterPush = function() {
        UI.base.cursor.alpha = 0;
        setTimeout(function(){
            UI.focusTo(BtnLeft)
        }, 100);
    };

    networkTip.onPop = function () {
        //UI.getTween(BtnRight, true).set({scaleX: 1, scaleY: 1});
        //UI.getTween(BtnLeft, true).set({scaleX: 1, scaleY: 1});
        //UI.getTween(UI.base.cursor, true).set({scaleX: 1, scaleY: 1, alpha: 0});

        BtnRight.scale.x = 1;
        BtnRight.scale.y = 1;
        BtnLeft.scale.x = 1;
        BtnLeft.scale.y = 1;
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.scale.x = 1;
        UI.base.cursor.scale.y = 1;
        UI.base.cursor.alpha = 0;

        try {
            //在提示框消失时调用一下如下接口唤醒浏览器

            if (!!GLOBAL.IS_APP_STR) {
                //DBG_INFO("Need to send cmd : dtv_app_mtk,am,:wakeup=hotkey ");
                //根据纪工要求注释掉如下AM命令MT5658SHARPU2-2535
                //sendAM(":dtv_app_mtk,am,:wakeup=hotkey");
                GLOBAL.IS_APP_STR = false;
            }
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function closeNetworkTip() {
        if(!!networkTip.param && networkTip.param.caller.toString()){
            DBG_ERROR("closeNetworkTip:"+networkTip.param.caller.toString());
            switch(networkTip.param.caller.toString()){
                case "mainTiles":
                    var lastfocus = launcher.lastfocus;
                    //if(lastfocus.data.storeType == StoreType.HBBTV){
                    //    closeMsgBox();
                    //    resumeDTV();
                    //    openLiveTVModule();
                    //}
                    //else{
                    if(!!launcher.lastfocus.data.obj.locked && GLOBAL.PARENTAL_LOCK_SWITCH){
                        UI.popSubModule();
                        GLOBAL.LAUNCHER_INFO_EVENT = "OPENFROMMAIN";
                        UI.pushSubModule("launcher", "launcherPassword",true, {caller: "mainTiles"});
                    }
                    else{
                        UI.popAllModule();
                        GLOBAL.LAUNCHER_INFO_EVENT = "OPENFROMMAIN";
                        var appName = null;
                        if(lastfocus.data.obj.url == "search-hisense"){
                            appName = APPNAME.SEARCH;
                        }else if(lastfocus.data.obj.url == "4know-hisense"){
                            appName = APPNAME.NEW4KNOW ;
                        }else if(lastfocus.data.obj.url == "appstore-hisense"){
                            appName = APPNAME.HISENSESTORE;
                        }
                        startThirdPartyApp(appName, lastfocus.data.obj.url, lastfocus.data.obj.urlType, CMDMethod.MENU, false, "#FFFFFF");
                    }

                  //  }
                    break;
                case "allApps":
                    var lastfocus2 = launcher.lastfocus;
                    if(!!lastfocus2.data.locked && GLOBAL.PARENTAL_LOCK_SWITCH){
                        UI.popSubModule();
                        GLOBAL.LAUNCHER_INFO_EVENT = "OPENFROMAPP";
                        UI.pushSubModule("launcher", "launcherPassword",true, {caller: "allApps"});
                    }
                    else{
                        UI.popAllModule();
                        GLOBAL.LAUNCHER_INFO_EVENT = "OPENFROMAPP";
                        var appName = null;
                        if(lastfocus2.data.url == "search-hisense"){
                            appName = APPNAME.SEARCH;
                        }else if(lastfocus2.data.url == "4know-hisense"){
                            appName = APPNAME.NEW4KNOW ;
                        }else if(lastfocus2.data.url == "appstore-hisense"){
                            appName = APPNAME.HISENSESTORE;
                        }
                        startThirdPartyApp(appName, lastfocus2.data.url, lastfocus2.data.urlType, CMDMethod.MENU, false, "#FFFFFF",lastfocus2.data.name);
                    }
                    break;
                case "NETFLIX":
                    UI.popAllModule();
                    startThirdPartyApp(APPNAME.NETFLIX, APPNAME.NETFLIX, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                    break;
                case "YOUTUBE":
                    UI.popAllModule();
                    startThirdPartyApp(APPNAME.YOUTUBE, APPNAME.YOUTUBE, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                    break;
                case "VUDU":
                    UI.popAllModule();
                    startThirdPartyApp(APPNAME.VUDU, APPNAME.VUDU, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                    break;
                case "AMAZONRUBY":
                    UI.popAllModule();
                    startThirdPartyApp(APPNAME.AMAZONRUBY, APPNAME.AMAZONRUBY, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                    break;
                case "AMAZON":
                    UI.popAllModule();
                    startThirdPartyApp(APPNAME.AMAZON, APPNAME.AMAZON, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                    break;
                case "WUAKI":
                    UI.popAllModule();
                    startThirdPartyApp(APPNAME.WUAKI, APPNAME.WUAKI, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                    break;
                case APPNAME.TVBROWSER:
                    UI.popAllModule();
                    startThirdPartyApp(APPNAME.TVBROWSER, APPNAME.TVBROWSER, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                    break;
                case APPNAME.DAILYMOTION:
                    UI.popAllModule();
                    startThirdPartyApp(APPNAME.DAILYMOTION, APPNAME.DAILYMOTION, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                    break;
                case APPNAME.CLAROVIDEO:
                    UI.popAllModule();
                    startThirdPartyApp(APPNAME.CLAROVIDEO, APPNAME.CLAROVIDEO, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                    break;
                case APPNAME.FANDANGONOW:
                    UI.popAllModule();
                    startThirdPartyApp(APPNAME.FANDANGONOW, APPNAME.FANDANGONOW, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                    break;
                case APPNAME.APP4KNOW:
                    UI.popAllModule();
                    startThirdPartyApp(null, APPNAME.APP4KNOW, CMDType.NATIVEAPP, CMDMethod.MENU, false);
                    break;
                case APPNAME.TVSTORE:
                    UI.popAllModule();
                    startThirdPartyApp(APPNAME.TVSTORE, APPNAME.TVSTORE, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                    break;
                case APPNAME.OTT:
                    var ott = readFileFromNative("launcher/ott.txt", 1);
                    if(ott!=null && ott.name != 0 ){
                        DBG_ERROR("start ott!!!!!!!!!!!!!!! ");
                        UI.popAllModule();
                        startThirdPartyApp(APPNAME.OTT,ott.url,37, CMDMethod.REMOTECONTROL, false, "#FFFFFF",ott.name,98);
                    }else{
                        closeMsgBox();
                        resumeDTV();
                        openLiveTVModule();
                    }
                    break;
                default :
                    closeMsgBox();
                    resumeDTV();
                    openLiveTVModule();
                    break;
            }

        }
        else{
            closeMsgBox();
            resumeDTV();
            openLiveTVModule();
        }
        //if(!!networkTip.param && networkTip.param.caller.toString()=="mainTiles"){
        //    UI.popAllModule();
        //    var lastfocus = launcher.lastfocus;
        //    startThirdPartyApp(null, lastfocus.data.obj.url, lastfocus.data.obj.urlType, CMDMethod.MENU, false, 0xFFFFFF);
        //}
        //else if(!!networkTip.param && networkTip.param.caller.toString()=="allApps"){
        //    UI.popAllModule();
        //    var lastfocus2 = launcher.lastfocus;
        //    startThirdPartyApp(null, lastfocus2.data.url, lastfocus2.data.urlType, CMDMethod.MENU, false, 0xFFFFFF,lastfocus2.data.name);
        //}
        //else{
        //    closeMsgBox();
        //    resumeDTV();
        //    openLiveTVModule();
        //}
    }
    BtnRight.onkey_ENTER = networkTip.onkey_EXIT = networkTip.onkey_BACKSPACE = closeNetworkTip;
};