// Init
UI.moduleBuilder['common']['AcrTip'] =function(){
    var acrData = {
        acrTitle: "[SE3624]",//"Enhanced Viewing",
        line1:{color : "0xffffff"},
        line2:{color : "0xffffff"},
        bg1:UI.back_bg,
        bgtop:UI.btn_normal_bg,
        acrTitlelittle:"[SE3625]",//"Enabled by Automatic Content Recognition (ACR)",
        acrText1:"[SE3626]",//"Activating the ACR service on this TV allows us to provide you with:",
        item1Img:"setting/" + GLOBAL.LAUNCHER_BRAND + "/acr_like.png",
        item2Img:"setting/" + GLOBAL.LAUNCHER_BRAND + "/acr_up.png",
        item3Img:"setting/" + GLOBAL.LAUNCHER_BRAND + "/acr_hot.png",
        item1Text1:"[SE3627]",//"Recommendations based on content viewed on this TV",
        item2Text1:"[SE3629]",//"Trending content",
        item3Text1:"[SE3628]",//"Information about popular TV content",
        text2:"In order to provide these features (and to help us improve our products and services), after you provide your consent below, the ACR service will collect broadcast TV and other onscreen audio data.  This will be combined with a unique identifier (which may be reset by you at any time) & the IP address of this TV, and then shared with authorized partners who may use additional information to help us deliver the above features on this TV, and advertising on other devices that share the IP address of this TV.\nFor further information about the ACR service and how we collect, use and share your information, please visit our Privacy Policy at https://www.hisense-usa.com/tv/privacy, and our Terms and Conditions at https://www.hisense-usa.com/tv/terms\nYou may withdraw your consent and disable the ACR service at any time in the Settings menu in this TV.",
        btnRightText: "[SE3635]",//"I DO NOT CONSENT TO ACTIVATE THE ACR SERVICE IN THIS TV",//,
        btnLeftText:"[SE3634]",// "I CONSENT TO ACTIVATE THE ACR SERVICE IN THIS TV",//,
        btnLeftImg: UI.btn_normal_bg,
        btnRightImg: UI.btn_normal_bg,
        "Dialogtitle":"[SE3624]",//"Setup Wizard",
        "Dialogcontent":"[SE3651]",//"Confirm your activation of enhanced Viewing and ACR service in this TV",//
        "btn2text":"[SE3652]",//"Activate",
        "btn1text":"[GE0008]",//"Cancel",
        "sheetImg1":UI['bg_overlay'],
        "DialogbgImg1":UI.window_bg,
        "btn1bgImg":UI.item_bg,
        "btn2bgImg":UI.item_bg

    };
    var template = Util.readJson("module/common/AcrTip.json");
    var acr = SubModule.create(acrData, template);

    acr.pageData = {
        "DisInfoPageTitle":{Data:"ACR"},
    };
    
    var newGroup1 = UI.getItem(acr, "newGroup1");
    var newGroup2 = UI.getItem(acr, "newGroup2");
    var btnLeft = UI.getItem(acr, "btnLeft");
    var btnRight = UI.getItem(acr, "btnRight");
    var Dialogbtn1 = UI.getItem(acr, "Dialogbtn1");
    var Dialogbtn2 = UI.getItem(acr, "Dialogbtn2");
    var noteText = UI.getItem(acr, "noteText");
    var acrTitle = UI.getItem(acr, "acrTitle");
    var text2 = UI.getItem(acr, "text2");
    var acrTitlelittle = UI.getItem(acr, "acrTitlelittle");
    acr.noAutoClose = true;
    acr.protected=true;
    acr.onPush=function(){
        var textContent="";
        newGroup1.alpha=1.0;
        newGroup2.alpha=0;
        acr.currFocus = btnLeft;
        if(GLOBAL.LAUNCHER_BRAND=="shp"){
            if (GLOBAL.CURRENT_COUNTRY == "CAN") {
                textContent = '[SE4155]\n[SE4241]\n[SE3633]'
            }
            else {
                textContent = '[SE3630]\n\n[SE3632]\n\n[SE3633]';
            }
        }
        else {
            if (GLOBAL.CURRENT_COUNTRY == "CAN") {
                textContent = '[SE4155]\n[SE4183]\n[SE3633]'
            }
            else{
                textContent = '[SE3630]\n\n[SE3631]\n\n[SE3633]';
            }
        }
        UI.setText(text2,textContent);
        UI.updateStage();
    }
    acr.onShow = function() {
        var bound=acrTitle.children[0].getBounds();
        acrTitlelittle.x=acrTitle.x+bound.width/2+acrTitlelittle.children[0].getBounds().width/2+10;
        UI.updateStage();
    };
    btnRight.onkey_ENTER = function() {
        acr.agreeflag = 0;
        stopAcrServer("Setting");
        try{
            Hisense.File.write("hisenseUI/hasPopUpAcrDialog","true" ,1);
        }catch(e){
            DBG_ERROR(e.message);
        }
        closeMsgBox();

    };
    btnLeft.onkey_ENTER = function() {
        acr.agreeflag = 1;
        newGroup1.alpha=0;
        newGroup2.alpha=1.0;
        UI.focusTo(Dialogbtn2);
        UI.updateStage();

    };
    Dialogbtn2.onkey_ENTER = function() {
        if (!!acr.agreeflag) {
            startAcrServer("Setting");
            var SettingSysAdv = UI.getSubModule("SettingSysAdv");
            if (!!SettingSysAdv) {
                SettingSysAdv.operateData.freshAcrSwitch.call(this,true);
            }
            try{
                Hisense.File.write("hisenseUI/hasPopUpAcrDialog","true" ,1);

            if(model.datetime.getSysTimeValidity()>0){
                DBG_INFO("getCurNTPTimeValid>0");
                var utctime=model.datetime.getCurLocalTime();
                Hisense.File.write("acrTimeFile",utctime+'' ,1);
            }
            else {
               if( !Hisense.File.exists("acrTimeFile", 1)){
                   Hisense.File.write("acrTimeFile",Date.UTC(2017,0,1,0,0,0)/1000+'' ,1);//s
                   DBG_INFO("no acrTimeFile" );
               }
                isNeedtoUpdateNtpTime=true;
                DBG_INFO("isNeedtoUpdateNtpTime"+isNeedtoUpdateNtpTime);
            }
            }catch(e){
                DBG_ERROR(e.message);
            }
        }
        closeMsgBox();

    };
    Dialogbtn1.onkey_BACKSPACE=
    Dialogbtn1.onkey_ENTER=function(){
        newGroup1.alpha=1.0;
        newGroup2.alpha=0;
        UI.focusTo(btnLeft);
        UI.updateStage();
    }

    acr.onkey_ESCAPE = acr.onkey_BACKSPACE =function() {
       return false;

    };



}
