UI.moduleBuilder['FTE']['fte_storeDialog'] = function() {
    var storeDialogData = {
        blackBgImg: "setting/dialog_bg.png",
        bgImg: "FTE/fte_timer_dialog_glint.png",
        timerImg: "FTE/fte_ic_timer.png",
        //mainText: "[SE3072]",//We haven't received any input from you. You are about to enter Store Mode within 30 seconds.
        cancelText: "[SE3073]",//Press any button to cancel.
        barBgImg: "FTE/fte_timer_bar_bg.png"
    };
    var template = Util.readJson("module/FTE/fte_storeDialog.json");
    var storeDialog = SubModule.create(storeDialogData, template);

    storeDialog.pageData = {
        "storeModeTimer": 0,
        "barTimer": 0
    };

    var cancelText = UI.getItem(storeDialog, "cancelText");
    var progressBar = UI.getItem(storeDialog, "progressBar");
    var barBgImg = UI.getItem(storeDialog, "barBgImg");
    var barImg = UI.getItem(storeDialog, "barImg");
    var mainText = UI.getItem(storeDialog, "mainText");
    var mainText1 = "[SE3072]";////We haven't received any input from you. You are about to enter Store Mode within 30 seconds.
    var mainText2 = "[SE3242]";//We haven’t received any input from you. The TV will shut down within 30 seconds. Press any button to cancel.

    UI.addMask(progressBar, 612, 10, 0, 0);
    UI.setView(progressBar, 612, 10);

    storeDialog.currFocus = cancelText;

//})();

    /*--------------------------------Actions----------------------------------------*/
//(function(){

    storeDialog.onPush = function () {
        /*如果软键盘打开，将软键盘关闭*/
        if (UI.isSoftKeyBoard) {
            host.keyboard.onKeyDown({which: 27});
            UI.isSoftKeyBoard = false;
        }

        if (!!storeDialog.param && storeDialog.param.caller  == "store") {
            UI.setText(mainText, mainText1);
        } else {
            UI.setText(mainText, mainText2);
        }
        UI.clearEnterEulaTimeout();
        UI.clearEnterStoreTimeout();
        UI.registerKeyCodes(null);
        UI.setKeyGroup(7);
    };
    storeDialog.onPop = function () {
        UI.registerKeyCodes(FTE.enableKeyGroup);
        UI.setKeyGroup(7);
    };
    storeDialog.onShow = function () {
        progressBar.x = 912;    //重置位置
        UI.getTween(progressBar).to({x: progressBar.x + 612}, 30000, UI.ease.quadIn);//30000
        storeDialog.pageData.storeModeTimer = setTimeout(function () {
            if (!!storeDialog.param && storeDialog.param.caller  == "store") {
                setCurrSignalInput();   //切到有信号的通道
                setTimeout(function () {
                    FTE.isOpenLiveTV = false;
                    FTE.isResumeDtv = true;
                    FTE.fteExit(null, true);
                    //进入商场模式 4K demo
                    try {
                        model.system.setUserMode(1);
                    } catch (e) {
                        DBG_ERROR(e.message);
                    }
                    writeFileToNative('hisenseUI/eposmode.txt', "videosignal", 1);
                    UI.setEposMenuTimeout(startRetailmodeTimer,retailmodeTimeout);
                    startePos(true);
                }, 100);
            } else {
                if (tv) {
                    try {
                        setTimeout(function () {
                            switchOffTV(1);
                        }, 200);
                    }
                    catch (ex) {
                        DBG_ERROR("after fte_userMode TV power off" + ex.message);
                    }
                }
            }
        }, 1000 * 30);// 1000 * 30
    };
    storeDialog.onExit = function () {
        clearTimeout(storeDialog.pageData.storeModeTimer);
        clearInterval(storeDialog.pageData.barTimer);
    };

    storeDialog.onFocus = function () {
        UI.base.cursor.alpha = 0;
        UI.updateStage();
    };
    storeDialog.onNormal = function () {
        UI.base.cursor.alpha = 1;
    };


    //任意键退出dialog
    /*storeDialog.onkey = function() {
     UI.popSubModule();
     };*/
    storeDialog.onkey = function () {
        UI.popSubModule();
    };

    function setCurrSignalInput() {
        var defSource = 'HDMI1';
        var SignalInputId = 0;
        var SignalInputItem = [];
        var SignalInputIditem = [];
        var InputSeq = ["HDMI1", "HDMI2", "HDMI3", "HDMI4", "ANT/Cable", "AV", "COMPONENT"];
        var j = 0;
        var sourceItem = [
            //id, name, signal, lock, rename
            "0", "ANT/Cable", "0", "1", "", "",
            "1", "AV", "1", "1", "", "",
            "2", "COMPONENT", "0", "0", "ComponentComponent", "",
            "3", "HDMI1", "1", "0", "", "",
            "4", "HDMI2", "0", "0", "", "",
            "5", "HDMI3", "1", "0", "", "",
            "6", "HDMI4", "1", "0", "", ""
        ];
        if (tv) {
            sourceItem = model.source.getInputName();
            DBG_ERROR("sourceItem is " + objToString(sourceItem));
        }
        for (var id = 0; id < sourceItem.length / 6; id++) {
            if (defSource == sourceItem[id * 6 + 1].replace(" ", "")) {
                SignalInputId = id;
                break;
            }
        }
        for (var i = 0; i < sourceItem.length / 6; i++) {
            if (sourceItem[i * 6 + 2] == 0) {
                if (i == 0) {   //TV时的判断
                    var ret = typeof (liveTV) != "undefined" && liveTV.getHasChannelFlag();
                    var TVSignal = tv ? ret : true;
                    if (TVSignal) {
                        SignalInputItem[j] = sourceItem[i * 6 + 1].replace(" ", "");
                        SignalInputIditem[j] = i;
                        j++;
                    }
                }
                else {
                    SignalInputItem[j] = sourceItem[i * 6 + 1].replace(" ", "");
                    SignalInputIditem[j] = i;
                    j++;
                }
            }
        }
        if (SignalInputItem.length > 0) {
            for (var k = 0; k < InputSeq.length; k++) {
                for (var n = 0; n < SignalInputItem.length; n++) {
                    if (SignalInputItem[n].toLowerCase() == InputSeq[k].toLowerCase()) {
                        SignalInputId = SignalInputIditem[n];
                        k = InputSeq.length;
                        break;
                    }
                }

            }
        }

        DBG_ERROR("setCurrSignalInput(): current signal input is " + SignalInputId);
        changeSourceTo(SignalInputId);
    }
}
