// Init
UI.moduleBuilder['FTE']['fte_storeDemo'] = function(){
    var storeDemoData = {
        titleImg: "FTE/fte_hd_ic_store_demo.png",
        title: "[SE3069]",//Store Demo
        helpText: "[FTE0101]",//Home Mode uses less energy. Select Store Mode if the TV will be on display in a retail setting.
        tilesBgImg: UI.list_bg
    };
    var template = Util.readJson("module/FTE/fte_storeDemo.json");
    var storeDemo = SubModule.create(storeDemoData, template);
    storeDemo.storeModeActBySingalNumTimer = null;
    var tiles = UI.getItem(storeDemo, "tiles");

    var array = [];
    for (var i=0; i < 3; i++) {
        array.push({});
        array[i].name = "fteStoreDemo" + i;
        array[i].bgImg = UI.item_bg;
        array[i].selectImg = "FTE/fte_checkmark.png";
    }
    array[0].text = "[SE3187]"; //"Store Mode with 4K Video"
    array[1].text = "[SE0809]";     //"Store Mode"
    array[2].text = "[SE0244]";     //"Home Mode";
    var info = {
        template: "fte_userMode_item",
        direction: CONST.GIRD_DIRECTION.H,
        breakNum: 1,
        distanceX: 0,
        distanceY: 6,
        container: tiles
    };
    Gird.create(array, info);

    //隐藏所有选项前面代表选中的对勾
    for (var i=0; i < 3; i++) {
        tiles.children[i].children[1].alpha = 0;
    }

    /*tiles.DataSelected = tiles.DataSelected || tiles.children[0];  // todo 这儿应该从底层拿数据
    fteDefaultSelect(tiles);
    storeDemo.currFocus = tiles.DataSelected;*/
    storeDemo.currFocus = tiles.children[0];



//    var storeDemo = UI.getSubModule("fte_storeDemo");
    var background = UI.getSubModule("fte_background");
//    var tiles = UI.getItem(storeDemo, "tiles");
    var btn1 = tiles.children[0];     //4K UHD video demo
    var btn2 = tiles.children[1];     //e-POS demo only
    var btn3 = tiles.children[2];     //Exit Store Mode

    storeDemo.onPush = function(){
        var curModeIndex = tv? model.system.getUserMode(): 0;//0: home mode; 1: store mode ;2: 4k store mode
        DBG_INFO("FTE user mode is " + curModeIndex);
        if(curModeIndex == 2){
            tiles.DataSelected = tiles.initSequence[0];
        }else if(curModeIndex == 1){
            tiles.DataSelected = tiles.initSequence[1];
        }else{
            tiles.DataSelected = tiles.initSequence[2];
        }
        // tiles.DataSelected = tiles.initSequence[selectIndex];
        fteDefaultSelect(tiles);
        storeDemo.currFocus = tiles.DataSelected;
    }

    storeDemo.onShow = function() {
        storeDemo.alpha = 1;
//        fteDefaultSelect(tiles);
    };

    storeDemo.onPop = function(){
        clearStoreModeActBySingalNumTimer();
    }


    btn1.onkey_ENTER = function() {
        DBG_INFO("FTE storeDemo select 4K UHD video demo");
        fteGirdSelect(tiles, function(){});
        clearStoreModeActBySingalNumTimer();
        storeDemo.storeModeActBySingalNumTimer = setTimeout(function () {
            writeFileToNative('hisenseUI/eposmode.txt', "video", 1);
            storeModeActBySingalNum(2);
        }, 200);
    };

    btn2.onkey_ENTER = function() {
        DBG_INFO("FTE storeDemo select e-Pos demo only");
        fteGirdSelect(tiles, function(){});
        clearStoreModeActBySingalNumTimer();
        storeDemo.storeModeActBySingalNumTimer = setTimeout(function () {
            writeFileToNative('hisenseUI/eposmode.txt', "videosignal", 1);
            storeModeActBySingalNum(1);
        }, 200);
    };

    btn3.onkey_ENTER = function() {
        DBG_INFO("FTE storeDemo select Home Mode");
        fteGirdSelect(tiles, function(){});
        UI.inactiveKey();
        setTimeout(function() {
            try{
                model.system.setUserMode(0);
            }catch(e){
                DBG_ERROR(e.message);
            }
            UI.clearEposMenuTimeout();
            fteUpdate(1);
            UI.activeKey();
        }, 200);
    };

    tiles.onkey_BACKSPACE = function() {
        DBG_INFO("FTE storeDemo go back to fte_userMode");
        UI.popSubModule();
        UI.pushSubModule("FTE", "fte_userMode", true);

    };

    tiles.onkey_LEFT = function() {
        DBG_INFO("FTE storeDemo go back to fte_userMode");
        UI.popSubModule();
        UI.pushSubModule("FTE", "fte_userMode", true);
    };

    function storeModeActBySingalNum(modeIndex) {
        background.alpha = 0;
        storeDemo.alpha = 0;
        FTE.isOpenLiveTV = false;
        FTE.isResumeDtv = false;
        var inputsData = initAllInputsData();
        DBG_ERROR("inputsData is " + objToString(inputsData));
        var signalNum = inputsData.signalSourceList.length;
        DBG_ERROR("signalNum is " + signalNum);
        if (signalNum == 0) {
            DBG_INFO(" signalNum == 0 ");
            storeModePlayEpos(modeIndex);
        } else if (signalNum == 1) {
            changeSourceTo(parseInt(inputsData.signalSourceList));
            DBG_INFO(" signalNum == 1, id is " + parseInt(inputsData.signalSourceList));
            storeModePlayEpos(modeIndex);
        } else {
            DBG_INFO(" signalNum > 2,  so push fte_source");
            UI.popSubModule();
            UI.pushSubModule("FTE", "fte_source", true, {modeIndex: modeIndex});
        }
    }
    function storeModePlayEpos(modeIndex) {
        FTE.play4kVideo(function() {
            //调用相应接口,启动e-Pos
            try{
                model.system.setUserMode(modeIndex);
            }catch(e){
                DBG_ERROR(e.message);
            }
//                Epos_play4kVideo(true, "fte_storeDemo");
            UI.setEposMenuTimeout(startRetailmodeTimer,retailmodeTimeout);
            startePos(true);
        });
    }

    function clearStoreModeActBySingalNumTimer(){
        if(!!storeDemo.storeModeActBySingalNumTimer){
            clearTimeout(storeDemo.storeModeActBySingalNumTimer);
        }
        storeDemo.storeModeActBySingalNumTimer = null;
    }

};