UI.moduleBuilder['FTE']['fte_disclaimer'] = function() {
    var disclaimerData = {
        eulaImg: "FTE/fte_hd_ic_eula.png",
        OKBtnImg: UI.item_bg,
        contentBtnImg: UI.item_bg,
        notAgreeItemText: "[SE3065]",//Decline
        agreeItemText: "[SE1205]",  //"Agree",
        OKText: "[SE2642]",//Continue
        cancelText:"[SE3067]"
    };
    var template = Util.readJson("module/FTE/fte_disclaimer.json");
    var disclaimer = SubModule.create(disclaimerData, template);

    disclaimer.pageData = {
        "DisInfoPageTitle": {Data: "EULA"},
        "DisInfoBox": {Data: '<p class="setting_dis_title1">END USER TERMS AND CONDITIONS FOR HISMART@ SERVICES</p><p class="setting_dis_title2">1. General</p><p class="setting_dis_content">1.1 Welcome to Hisense Smart TV. These End User Terms and Conditions for HISMART@ Services (these "Terms and Conditions") are a legal agreement between you and Hisense Germany GmbH ("Hisense"). By installing and/or using the embeddable and executable software application ("Application"), and/or accessing or using the Content and Services through Hisense Smart TV or any other features of functionality made available on your Hisense device, you are legally bound to these Terms and Conditions.</p><p class="setting_dis_content">1.3 All content and services accessible through this device belong to Hisense or third parties and are protected by copyright, patent, trademark and/or other intellectual property laws.</p><p class="setting_dis_content">1.4 Such content and services are provided solely for your personal non-commercial use. You may not use any content or services in a manner that has not been authorized by the content owner or service provider in particular by contractual provisions.</p><p class="setting_dis_title2">2. DEFINITION</p><p class="setting_dis_content">2.1 "Content" means all audio and visual elements and ideas offered by Hisense or third parties including but not limited to data, movies, videos, photographs, software, games, designs, likenesses, artwork, images, music, sound, information and other materials, tangible and intangible, including derivative works, on all media and formats, existing or future. "Service" means all types of services or functions typically available from the internet, offered by Hisense or third parties including but not limited to provisions of music, movie, video, messaging, blogging, chatting, social networking, information, procurement, disposal, sale, purchase, rental and consultation through your Hisense device. The service includes in particular the web browser and the App Store, which are available on the device.The "use of the device" means the basic technical use of the device, which is assured through the purchase of the device.</p><p class="setting_dis_content">2.2 The Applications, Content and Services collectively shall mean "HISMART@ Services". From time to time, Hisense may directly offer and make available to you certain Applications, Services and/or Contents, and in such events, your use of such Applications, Services and Contents shall be subject to these Terms and Conditions.</p><p class="setting_dis_content">2.3 Applications, Content and Services may be provided locally subject to local laws and regulations, and depending on your residence and location, you may be limited to types and levels of Applications, Content and Services. Terms and conditions for the use of such Applications, Services or Content may differ for each different country, region or market subject to relevant local, country and regional laws.</p><p class="setting_dis_title2">3. USE OF HISMART@ SERVICES/p><p class="setting_dis_content">3.1 HISMART@ Services are intended for use by persons 13 years of age or older. If you are not at least 13 years of age or older or are legally, or otherwise, restricted form using HISMART@ Services, please discontinue using HISMART@ Services. If you are not 18 years of age or older, you must have a parent of guardian\'s approval prior to using HISMART@ Services.</p><p class="setting_dis_content">3.2 The use of any portion of HISMART@ Services (including the Application, Content and Services) are restricted to only personal, non-commercial purposes. No other used are permitted.</p><p class="setting_dis_content">3.3 Access to certain Applications Content and/or Services, online or otherwise, may require registration, the creation of a user account with Hisense or a third party, and/or a fee. Registration may require providing personal information and choosing a unique, secret password that may not be shared with others. Any personal information provided by you to Hisense will be handled in accordance with our Privacy Policy. Your personal information must be complete, accurate, and must be YOURS. You shall not use any third party personal information to create an account in connection with the use of HISMART@ Services, and you are not allowed to access others\' accounts.</p><p class="setting_dis_content">3.4 HISENSE RESERVES THE RIGHT TO BLOCK ANY USER ACCOUNT IN THE EVENT HISENSE REASONABLY DETERMINES THAT THE USE OF HISMART@ SERVICES IS IN SIGNIFICANTLY VIOLATIONS OF THESE TERMS AND CONDITIONS, INCLUDING CREATING ACCOUNTS WITH FALSE INFORMATION. Hisense will give the client the opportunity to discontinue the violations before blocking. Content and Service offered through HISMART@ Services that require a fee may not be accessed by persons who have not paid the appropriate fee. In the event that registration, creation of a user account, and/or a fee is required for the Service or Content offered or provided by a third party provider, such registration, creation of a user account, and/or a fee shall be subject to privacy policies, terms and condition of the Services and/or Contents of such third party.</p><p class="setting_dis_title2">4. SPECIFIC USE OF HISMART@ SERVICES THROUGH HISENSE APPS</p><p class="setting_dis_content">4.1 Access to certain portions of HISMART@ Services at Hisense Apps may require registration and creation of a user account and/or a fee. Such registration, creation of a user account and payment of a fee may be completed on a webpage run by us or a third party (including a payment gateway provider).</p><p class="setting_dis_content">4.2 Such registration may require providing personal information to such us or third party and choosing a unique, secret password that may not be shared with others. In the event that registration, creation of a user account, and/or a fee on such third party or Hisense website is required for the Service or Content offered or provided through Hisense Apps, such registration, creation of a user account, and/or a fee shall be subject to privacy policies, terms and condition of the Services and/or Contents of such website.</p><p class="setting_dis_content">4.3 In the event that the Apps are offered by Hisense, the contract of using the Apps shall be subject to the additional Terms and Conditions for using Hisense Apps.</p><p class="setting_dis_title2">5. RIGHT OF REVOCATION OF THE CONTRACT OF USE OF HISMART@SERVICES/p> <p class="setting_dis_content">You may withdraw your contractual agreement in writing (eg by letter, fax, e-mail) within 14 days without giving reasons. The period begins upon receipt of these instructions in writing, but not before the conclusion oft the contract, and also not before the fulfillment of our informational duties as per Article 246 § 2 in connection with § 1 Abs. 1 and 2 of the Introductory Statue to the Civil Code (EGBGB) as well as our duties as per § 312g Abs. 1 sentence 1 Civil Code (BGB) in conjunction with Article 246 § 3 of the Introductory Statue to the Civil Code (EGBGB). It is sufficient to send the revocation or the merchandise on time in order to keep the deadline.</p><p class="setting_dis_content">The revocation is to be addressed to</p><p class="setting_dis_content">Hisense Germany GmbH<br>Am Seestern 8, 40547 Düsseldorf, Germany<br>Fax: +49 211 91374445</p><p class="setting_dis_content">Revocation Consequences</p><p class="setting_dis_content">In the event of an effective revocation, services and fees provided by both parties have to be returned and any economic advantages gained (e.g., interest) have to be paid. If you are not able to return the services and utilization (exercised benefits) rendered fully or in part, or only in a lesser form, you are obligated to reimburse us for the value lost. This can mean that you are required to fulfill the contractual payment obligations for the time period until revocation. Obligations to reimburse costs must be fulfilled within 30 days. This period begins for you when you send your declaration of revocation, for us when we receive it.</p><p class="setting_dis_content">Special Notes</p> <p class="setting_dis_content">The rules on distance contracts, including rules on the right of revocation shall not apply to contracts for the provision of services concerning accommodation, transport, food and beverages, as well as recreational activities if the contractor agrees to deliver the services at a given time or within a specific period. Your right of revocation expires prematurely if the contract is completely fulfilled by both parties at your explicit request before you have exercised your right of revocation.End of right of revocation.</p><p class="setting_dis_title2">6. CONTENT OF THIRD PARTIES ACCESSIBLE THROUGH THIS DEVICE</p><p class="setting_dis_content">6.1 The country location you have identified during the set-up process may grant your access to certain content, advertising and services of third parties or Hisense.</p><p class="setting_dis_content">6.2 The third party content and linked sites are not under our control, and we have neither reviewed the contents of these third-party web sites, nor do we claim any responsibility for the access to, maintenance, content or suitability of, these third-party web sites or applications. You expressly acknowledge and agree that the identification of your country location and your linking to any third party site or application is entirely at your own risk, and it is your responsibility to view and abide by the terms of use and privacy policies applicable to any third party site. </p><p class="setting_dis_content">6.3 Content and services are transmitted by means of networks and transmission facilities over which Hisense has no control. In particular, Hisense tries to fix any technical malfunctions, but cannot guarantee continual option of use.</p><p class="setting_dis_content">6.4 Hisense is neither responsible nor liable for customer service related to the third party content and services. </p><p class="setting_dis_content">6.5 All the apps in the Television are propelling by the apps owner. Any question or request for service relating to such content or services should be made directly to the respective third party content and service providers.</p><p class="setting_dis_title2"> 7. GRANT OF LICENSE</p><p class="setting_dis_content">7.1 Subject to your full compliance with these Terms and Conditions, Hisense grants you a non-exclusive, limited and personal license to download and use the Application (other than the Application which is governed by separate license terms) to display, receive or otherwise use (only to the extent permitted) the Content and Service from your Hisense device only. No other rights to the Application are granted. </p><p class="setting_dis_content">7.2 The scope of rights for Content and Service shall be subject to the terms and conditions of the respective Content and Service and other licensing requirement and restrictions otherwise imposed or required by the relevant Content and Service providers. All rights including intellectual property rights in the Application, Content and Service remain the property of Hisense or the relevant licensors or owners of the Application, Content and Service. </p><p class="setting_dis_content">7.3 Any significantly breach of these Terms and Conditions will revoke all of the rights granted herein and Hisense may conduct further legal action if necessary.</p><p class="setting_dis_title2">8. RESTRICTIONS AND PROHIBITIONS</p><p class="setting_dis_content">8.1 You or any third party (directed by You) may not display, copy, store, modify, sell, publish, broadcast or redistribute any Application, Content and/or Service (a portion or in its entirety), and such displaying, copying, storing, modification, sale, publishing, broadcasting or redistribution shall be prohibited unless you have obtained all necessary rights and permissions from Hisense or relevant owners or right holders of such Application, Content and/or Service or as permitted by applicable law (in particular §§69e and 69 d German Copyright Act). </p><p class="setting_dis_content">8.2 Unauthorized use of the Content or Service is prohibited and may result in criminal prosecution and/or civil liability.</p><p class="setting_dis_content">8.3 You may not use any portion of the device for any other purposes, including, but not limited to, illegal activity, to make unsolicited offers or advertisements, to impersonate or falsely claim affiliation with any person or entity, to misrepresent, harass, defraud or defame others, to post, upload, transmit or disseminate any obscene, unreasonably offensive or any other unlawful material, to negatively present the HISMART@ Services, nor for any commercial purposes. Except as expressly permitted by these Terms and Conditions, and except to the extent that applicable laws prevent Hisense from restraining you from doing so, you are not allowed to disassemble, reverse engineer, tamper with the HISMART@ Services, or transmit hidden or malicious code or to collect information of other users through the HISMART@ Services. You may not take any action to interrupt the functionality of or tamper with the Application, Content or Service contained in or provided through HISMART@ Services or its servers or to unreasonably affect others\' enjoyment of HISMART@ Services in any way. </p><p class="setting_dis_title2">9. MATERIALS PROVIDED BY YOU</p><p class="setting_dis_content">9.1 Any Content submitted, uploaded or posted by you or on behalf of you on or through your Hisense device or HISMART@ Services ("Submitted Content") will be considered non-confidential and non-proprietary. We also have the right to disclose your information as necessary due to any third party who is claiming with evidence that any of your Submitted Content constitutes a violation of their intellectual property rights, or of their right to privacy.</p><p class="setting_dis_content">9.2 By posting, submitting, uploading or otherwise transmitting Submitted Content in any way via your Hisense device, you grant us a perpetual, unrestricted, non-exclusive, worldwide, fully paid-up, royalty free, sub-licensable license to change, copy, disclose, license, perform, display, post, publish, distribute, transmit or use such Submitted Content in any manner and create derivative works thereof or incorporate the Submitted Consent into other work anywhere in the world.</p><p class="setting_dis_content">9.3 We have the right to remove any Submitted Content on HISMART@ Services for any reason including if, in our sole opinion, such Submitted Content is unnecessary, offensive, indecent or objectionable.</p><p class="setting_dis_content">9.4 We do not control the Submitted Content and do not warrant the nature, accuracy, integrity, appropriateness or quality of the Submitted Content. You warrant that any of your Submitted Content does not and will not infringe any third party intellectual property rights. You are solely responsible for all Submitted Content that you upload, post, email, transmit or otherwise make available in any portion of HISMART@ Services. We assume no liability for such Submitted Content and you are solely responsible for any liability arising from or related to any Submitted Content posted, uploaded or transmitted by you or on behalf of you on or through your Hisense device or HISMART@ Services.</p><p class="setting_dis_title2">10. ADVERTISEMENTS AND CUSTOMER SERVICE COMMUNICATIONS</p><p class="setting_dis_content">10.1 You understand and agree that HISMART@ Services may include advertisements, certain communications from Hisense or third parties such as update announcements, administrative messages, newsletters and other materials ("Communications"). As those advertisements or communications are part of HISMART@ Services, you may not opt out of receiving these advertisements or communications.</p><p class="setting_dis_content">10.2 Certain Services and Content may not be suitable for minors or other users. Such Services and Content may not be rated or identified as having violent or explicit images or language. Therefore, you understand and agree that you are using the Services and Content at your own risk and Hisense shall have no liability to you for any offensive Services or Content. For purposes of clarity none of your behavioral or personal information provided for the HISMART@ Services is used in any Communications.</p><p class="setting_dis_title2">11. WARRANTIES AND LIABILITIES</p><p class="setting_dis_content">11.1 Liability of Hisense toward the client is excluded for damage to legal assets other than life, limb or health, unless the damage is caused by intentional or grossly negligent behavior of Hisense, one of his legal representatives or one of his agents and the behavior does not concern one of his contractual obligations. Essential contractual obligations are those imperative for the proper execution of the contract and which are observed reliably. The exclusions and limitations above do not apply in case of explicit guarantees by Hisense, if lack of assured qualities is claimed or if claims under the Product Liability Act are affected.</p><p class="setting_dis_content">11.2 Hisense is only liable for the recovery of data if the client has taken all necessary and reasonable data security measures and can guarantee that data from data material kept in electronic form can be reconstructed with a reasonable effort. </p><p class="setting_dis_content">11.3 In any case, the client is also required to limit the damage. This includes the timely indication of damage to minimize further damage.</p><p class="setting_dis_content">1.4 To the fullest extent permitted by law, Hisense shall not be held responsible for any third party Content or Service that may be accessed through HISMART@ Services, nor shall Hisense be held responsible for hidden or malicious code contained on or distributed through the HISMART@ Services or Hisense device by third parties. </p><p class="setting_dis_content">11.5 Hisense does not guarantee that there will be no interruptions, delays or inaccuracies in the Content or Service and does not guarantee the continued availability of such Content and Service. Due to the various capabilities of Hisense devices featuring the HISMART@ Services, as well as limitations in the available Content and Services offered via HISMART@ Services, certain features, Applications, Content and Services may not be available on all devices or in all territories. </p><p class="setting_dis_content">11.6 Some features on the HISMART@ Services may also require additional peripheral devices that are sold separately. Hisense does not endorse any of the ideas, products, persons, or opinions expressed in the Content or Service. </p><p class="setting_dis_content">11.7 Parties shall not be held to fulfil any obligation if they are hindered to do as a result of circumstance that is no fault of their own and that cannot be attributed to them by virtue of law, a legal action or generally accepted practice. </p><p class="setting_dis_title2">12. ACTIONS REQUIRED BY LAW</p><p class="setting_dis_content">Hisense may need to comply with the lawful interception and/or data retention requirements of local law enforcement agencies from time to time. Hisense may restrict access to any part of HISMART@ Services and the Hisense device or terminate your access to the HISMART@ Services, at any time in its sole discretion if required by law or by the relevant authorities or regulatory agencies to do so.</p><p class="setting_dis_title2">13. FINAL PROVISIONS</p><p class="setting_dis_content">13.1 This contract is subject to the rules and laws of the Federal Republic of Germany, excluding the CISG. If translations of the present agreement exist, the English version shall prevail in the event of contradictions.</p><p class="setting_dis_content">13.2 If the client is a merchant, a legal entity under public law or public special assets, the exclusive place of jurisdiction for all disputes arising from this contract is the domicile of Hisense. The same is true if the client has no general place of jurisdiction in Germany or his domicile or habitual residence at the time of action is not known.</p><p class="setting_dis_content">13.3 If any provisions of this agency contract are invalid, the remaining provisions shall remain in effect.</p><p class="setting_dis_title2">Privacy Policy</p><p class="setting_dis_content">The privacy policy set forth below (the "Privacy Policy") applies to the use of the device. Hisense is committed to protecting the privacy of all users of the device. The purpose of this Privacy Policy is to inform you about the types of information we gather about you when you visit or submit information to the device, how we may use that information, and if and how we disclose it to third parties</p><p class="setting_dis_content">This Privacy Policy applies to information about you that is collected by Hisense Germany GmbH ("Hisense"), by any company within the Hisense Group of companies, or by any other company under the Hisense brand ("the Hisense Group Companies"). A full list of Hisense Group Companies is available upon request.</p><p class="setting_dis_content">this Privacy Policy does not apply to personal information that you provide directly to third parties whose services or content you access via the device. You should check the applicable privacy policy of any third party service providers whose service or content you access.</p><p class="setting_dis_content">All users of the device are required to provide true, current, complete and accurate personal information when prompted and we will reject and delete any entry that we believe in good faith to be incorrect, false, falsified, or fraudulent, or inconsistent with or in violation of the Privacy Policy.We will provide you with an opportunity to give your consent to the terms of this Privacy Policy as part of the device registration process.</p><p class="setting_dis_content">Separate from such consent, your use or participation in the HISMART@ Services will be construed as your acceptance of the Privacy Policy and of our collection, use, disclosure, transfer, management and storage of your personal information as described below. We may, from time to time, transfer or merge any personal information collected off-line to our online databases or store off-line information in an electronic format. We may also combine personal information we collect online with information available from other sources, including information received from our affiliates, marketing companies, or advertisers. This Privacy Policy covers all such personal information and will remain in full force and effect as long as you are a user of the HISMART@ Services, even if your use of or participation in any particular service, feature, function or promotional activity terminates, expires, ceases, is suspended or deactivated for any reason.</p><p class="setting_dis_title2">1. INFORMATION THAT WE COLLECT</p><p class="setting_dis_content">1.1 Personal Information - At various locations on the device, such as ID creation, in registration forms, surveys, and polls, we may request that you supply us with "personal" information which relates to you and identifies you, such as your name, e-mail address, mailing address, home or work telephone number. The personal information you provide through the device, will be collected and retained in accordance with this Privacy Policy. In this Privacy Policy, we use the terms \'personal information,\' \'information about you\' or \'your information\' interchangeably.</p><p class="setting_dis_content">1.2 Non-Personal Information - When you use the device, we may also collect "non-personal" information. We consider "non-personal information" to be information that, by itself or in combination with other information, cannot be used to identify or contact you personally, such as demographic information (your age, gender, education level, profession, zip code, etc.). Non-personal information may also include technical information, such as log information, device information and other anonymous data involving your use of the device. Non-personal information may also include information that you provide us through your use of the device, such as query terms you enter into the search functions of the device, page request, or data about specific services or applications accessed by you (but not the data related to your specific activity or usage within a third-party application or service), the date and time of your request. We use this information, among other things, to understand usage patterns, to administer the device. We reserve the right to use or disclose non-personal information in any way we see fit, including for our marketing and advertising purposes. <br>If we combine personal information with non-personal information, the combined information will be treated as personal information for as long as it remains combined.</p><p class="setting_dis_content">1.3 Cookies and Other Technologies - At times, the device may use "cookies" or other technologies such as web beacons. These technologies help us better understand user behavior, tell us web devices, services and applications that you have devised or accessed and make your experience with the device more convenient and customized. We treat information collected by cookies and other technologies as non-personal information. However, to the extent that IP addresses or similar identifiers are considered personal information by local law, we treat such identifiers as personal information. If you want to disable cookies or such other technologies, you can clear data stored on the device you are using to access the device.</p><p class="setting_dis_title2">2. USE OF INFORMATION WE COLLECT</p><p class="setting_dis_content">2.1 Our Services - We use your personal information for any of the following purposes:<br>- to register you on the device;<br>- to administer the device (including processing any searches or requests for certain content, recommending content, providing blogs, open forums, discussion pages or personalized features);<br>- to communicate with you;<br>- for internal record keeping.</p><p class="setting_dis_content">2.2 All of the above apply equally to the use of your personal information for such purposes by a Hisense Group Company, if the use serves the purpose of the contract or in so far as this is necessary to safeguard justified interests of Hisense and there is no reason to assume that you have an overriding legitimate interest in your data being excluded from processing or use or if there is another  legitimation through German Data Protection Act.</p><p class="setting_dis_content">2.3 E-mail Communications - If you send us an e-mail with questions or comments, we may use your personal information to respond to your questions or comments, and we may save your questions or comments for future reference. However, aside from our reply to such an e-mail, it is not our standard practice to send you e-mail unless you request a particular service that involves e-mail communications, you otherwise consent to being contacted by e-mail, or to receiving from us (either from ourselves or a related company) information about products and services which we believe may be of interest to you.</p><p class="setting_dis_title2">3. DISCLOSURE OF INFORMATION TO THIRD PARTIES</p><p class="setting_dis_content">3.1 Except as specifically set forth in this Privacy Policy, we do not disclose your personal information to a third party without your permission, except:<br>- to a Hisense Group Company in accordance with number 2.2;<br>- where is it necessary to enable any of our staff, employees, agents, contractors, suppliers or commercial partners to provide a service to us or to perform a function on our behalf;<br>- to our professional advisors;<br>- to the purchaser or potential purchaser of our rights and obligations relating to the device; or<br>- where it is necessary in order to pursue our legitimate interests or if we are required to or are permitted to do so by law.</p><p class="setting_dis_content">3.2 For any disclosure of your personal information by us to a carefully selected third party or to any third party referred to in this Privacy Policy, we will comply with data protection law by ensuring that there are arrangements in place to ensure that the third party does not use your personal information for any purposes other than the purposes we specify according to the purchase your data was collected for and in accordance with the purposes outlined in this Privacy Policy and keep it secure.</p><p class="setting_dis_title2">4. SECURITY OF THE INFORMATION WE COLLECT</p><p class="setting_dis_content">The security of your personal information is important to us. We maintain physical, electronic and procedural safeguards to secure your personal information. However, please remember that there is always some risk in transmitting information electronically prior to our collection. The personal information we collect is stored within databases that we control. As we deem appropriate, we use security measures consistent with industry standards, such as firewalls and encryption technology, to protect your information. We restrict access to personal information to employees, contractors and agents who need to know that information in order to operate, develop or improve the device. These individuals are bound by confidentiality obligations and may be subject to discipline, including termination and criminal prosecution, if they fail to meet these obligations. </p><p class="setting_dis_title2">5. BULLETIN BOARDS AND OTHER PUBLIC AREAS</p><p class="setting_dis_content">We may offer bulletin boards or other public functions and any posting by you is considered public information available to other users. We do not control, and are not responsible for, the actions of other users of the device with respect to any information you post in Public Areas. In addition, information that you submit to Public Areas may be collected and used by others to send you unsolicited messages and for other purposes. Any posting is governed by End User Terms and Conditions for the device. You should take care to not use personal information in your screen name or other information that might be publicly available to other users.</p><p class="setting_dis_title2">6. ACCURACY OF THE INFORMATION WE COLLECT</p><p class="setting_dis_content">6.1 Any questions you may have regarding this Privacy Policy, the accuracy of your personal information, the use of your personal information, or any requests to access your information or that we correct, update or remove your information in our databases, should be directed via e-mail to the Privacy Officer / Customer Service Director at Hisense [info@hisense.de], or via regular mail to:<br>HISENSE Deutschland GmbH <br>ATTN: Customer Service Director / Privacy Officer<br>Am Seestern 8, 40547 Düsseldorf<br>Phone: +49 211 41654770<br>Fax: +49 211 91374445</p><p class="setting_dis_content">6.2 If we receive a request to change your information, we will make reasonable efforts to ensure that all of your personal information stored in databases we actively use to operate the device will be updated, corrected, changed or deleted, as appropriate, as soon as reasonably practicable.</p><p class="setting_dis_content">6.3 We will not retain personal information for longer than is necessary for the purposes for which it was intended, or as required under any contract or by law. However, we reserve the right to retain in our archival files any information removed from, or changed in, our active databases. We may retain such information to resolve disputes, troubleshoot problems and enforce our End User Terms and Conditions for the device. In addition, it is not technologically possible to remove each and every record of the information you have provided to us. A copy of your personal information may exist in a non-erasable form that will be difficult or impossible for us to locate.</p><p class="setting_dis_content">This Privacy Policy is effective as of October 25, 2011, and complies with Hisense\'s Corporate Privacy Policy. We reserve the right to change this Privacy Policy at any time, and will post any material changes to this Privacy Policy as soon as they go into effect.</p>'},
        "operateData": {
            "currenheight":0,
            "step":220,
            "curbrand":"his",
            "contentBtnFlag": 0,     //0: 条款页面没开； 1：已打开条款页面
            //"currItem":"0"
            "disStr":""
        }
    };
    
    var notAgreeItem = UI.getItem(disclaimer, "notAgreeItem");
    var agreeItem = UI.getItem(disclaimer, "agreeItem");
    var checkBox1 = UI.getItem(disclaimer, "checkBox1");
    var checkBox2 = UI.getItem(disclaimer, "checkBox2");
    var background = UI.getSubModule("fte_background");
    var cancelText = UI.getItem(disclaimer, "cancelText");
    var newGroup88 = UI.getItem(disclaimer, "newGroup88");
    var OKBtn = UI.getItem(disclaimer, "OKBtn");
    var contentBtn = UI.getItem(disclaimer, "contentBtn");
    var text1 = UI.getItem(disclaimer, "text1");
    var contentBtnText = UI.getItem(disclaimer, "contentBtnText");
    notAgreeItem.isBg=true;
    agreeItem.isBg=true;
    var eulaTitle = UI.getItem(disclaimer, 'eulaTitle');
    eulaTitle.children[0].style.padding = 20;
    eulaTitle.children[0].updateText();
    disclaimer.agreeflag = tv? model.basicSetting.getDisclaimer(): 0;
    DBG_ERROR("agreeflag is " + disclaimer.agreeflag);

    disclaimer.onShow = function() {
        background.open();
        DBG_ERROR("CURRENT_COUNTRY && acrflag" + GLOBAL.CURRENT_COUNTRY + acrflag  );
        if(_getIndex(hasACRCountryList,GLOBAL.CURRENT_COUNTRY)>-1 && acrflag){
            UI.setText(eulaTitle,"[SE3619]");
            UI.setText(contentBtnText,"[SE3619]");
            UI.setText(text1, "[SE3621]\n\n[SE3622]");
        }else{
            UI.setText(eulaTitle,"[SE3064]");
            UI.setText(contentBtnText,"[SE3809]");
            UI.setText(text1, "[SE3221]\n\n[SE3222]");
        }
        hideNavbarOrNot(1);
        var data = disclaimer.pageData;
        if (data.operateData.contentBtnFlag) {
            $("#divLayer").css("visibility", "visible");
        }
        else {
            newGroup88.alpha = 1;
            cancelText.alpha = 0;
            $("#divLayer").css("visibility", "hidden");
        }
        if (disclaimer.agreeflag == 0) {
            setOkBtnDisable(true);
            UI.setImage(checkBox1, "FTE/"+GLOBAL.LAUNCHER_BRAND +"/fte_rdio_bttn_active.png");
            UI.setImage(checkBox2, "FTE/fte_rdio_bttn_inactive.png");
        } else {
            setOkBtnDisable(false);
            UI.setImage(checkBox1, "FTE/fte_rdio_bttn_inactive.png");
            UI.setImage(checkBox2, "FTE/"+GLOBAL.LAUNCHER_BRAND +"/fte_rdio_bttn_active.png");
        }
        disclaimer.currFocus = agreeItem;
        UI.updateStage();

    };
    function setOkBtnDisable(disable){
        OKBtn.disable = disable;
        if(disable){
            OKBtn.alpha = 0.3;
        }else{
            OKBtn.alpha = 1;
        }
        UI.updateStage();
    }
    disclaimer.onPop = function () {
        var data = disclaimer.pageData;
        if (data.operateData.contentBtnFlag) {
            contentBtn.onkey_BACKSPACE();
        }
    };
    disclaimer.onExit = function () {
        $("#divLayer").css("visibility", "hidden");
    }

    contentBtn.onkey_LEFT = function () {
        fteUpdate(-1);
    };
    agreeItem.onkey_LEFT = function () {
        fteUpdate(-1);
    };
    notAgreeItem.onkey_ENTER = function () {
        disclaimer.agreeflag = 0;
        setOkBtnDisable(true);
        UI.setImage(checkBox1, "FTE/"+GLOBAL.LAUNCHER_BRAND +"/fte_rdio_bttn_active.png");
        UI.setImage(checkBox2, "FTE/fte_rdio_bttn_inactive.png");
    };
    agreeItem.onkey_ENTER = function () {
        disclaimer.agreeflag = 1;
        UI.setImage(checkBox1, "FTE/fte_rdio_bttn_inactive.png");
        UI.setImage(checkBox2, "FTE/"+GLOBAL.LAUNCHER_BRAND +"/fte_rdio_bttn_active.png");
        setOkBtnDisable(false);
        UI.focusTo(OKBtn);
    };

    agreeItem.onkey_DOWN = function(){
        if(!OKBtn.disable){
            UI.focusTo(OKBtn);
        }
    }

    notAgreeItem.onkey_DOWN = function(){
        if(!OKBtn.disable){
            UI.focusTo(OKBtn);
        }
    }


    OKBtn.onkey_ENTER = function () {
        if(disclaimer.agreeflag == 1 && !OKBtn.disable){
            if (tv) {
                DBG_INFO("model.basicSetting.setDisclaimer(" + disclaimer.agreeflag + ")");
                model.basicSetting.setDisclaimer(disclaimer.agreeflag);
            }
            fteUpdate(1);
        }
    };
    OKBtn.onkey_RIGHT = function () {
        //需要判断是否允许跳到下一页面
        //暂时不允许向右键到下一页面
//        fteUpdate(1);
    };

    contentBtn.onkey_ENTER = function () {
        var disclaimerFileAdd;
        newGroup88.alpha = 0;
        cancelText.alpha = 0.5;
        UI.updateStage();

        DBG_INFO("contentBtn.onkey_ENTER: open EULA content page");
        try {
            contentBtn.onkey_LEFT = function () {
                //置空，不允许左键
            };
//        newGroup88.alpha = 0;
            //打开具体条款
            var disLayer = $("#divLayer");
            disLayer.html("");
            var data = disclaimer.pageData;
            data.operateData.contentBtnFlag = 1;

            disLayer.html(getFile("module/FTE/fte_dis_info.html"));

            disclaimerFileAdd = getCurDisclaimerfile();

            $("#DisInfoBox").html(getFile("module/setting/" + disclaimerFileAdd));
            disLayer.css("visibility", "visible");
            fteDisContentOpen();
        } catch (ex) {
            DBG_ERROR("fte_disclaimer contentBtn.onkey_ENTER: " + ex.message);
        }

    };
    contentBtn.onkey_BACKSPACE = function () {
        newGroup88.alpha = 1;
        cancelText.alpha = 0;

        var data = disclaimer.pageData;
        if (data.operateData.contentBtnFlag) {
            contentBtn.onkey_LEFT = function () {
                fteUpdate(-1);
            };
            data.operateData.contentBtnFlag = 0;
            $("#divLayer").css("visibility", "hidden");
            UI.updateStage();
            if(GLOBAL.TTS){
                Hisense.System.stopSpeaking();
            }
        }
        else {
            fteUpdate(-1);
        }

    };

    contentBtn.onkey_RIGHT = function () {
        //需要判断是否允许跳到下一页面
//        fteUpdate(1);
    };

    contentBtn.onkey_UP = function () {
        var data = disclaimer.pageData;
        if (data.operateData.contentBtnFlag) {
            fteDisContentUp();
        }
    };
    contentBtn.onkey_DOWN = function () {
        var data = disclaimer.pageData;
        if (data.operateData.contentBtnFlag) {
            fteDisContentDown();
        }else{
            UI.focusTo(agreeItem);
        }
    };

    function fteDisContentOpen() {
        var data = disclaimer.pageData;
        var contenthigh = $("#DisInfoBox").height();
        var boxheigh = $("#DisInfoCon").height();
        if (contenthigh > boxheigh) {
            var temp = parseInt(840 / contenthigh * boxheigh);
            $("#DisInfoScrollBar").css("height", temp);
        }
        else {
            $("#DisInfoScrollBar").css("visibility", "hidden");
        }
        data.operateData.currenheight = 0;
        $("#DisInfoBox").css("top", "-" + data.operateData.currenheight + "px");
        if(GLOBAL.TTS)
        {
            data.operateData.disStr= $("#DisInfoBox").text().replace(/\n/g, " ").replace(/ +/g, " ");
            var subStr='';
            var index;
            speakDisclaimer(data.operateData.disStr);
        }

    }

    function speakDisclaimer(disStr) {
        var data = disclaimer.pageData;
        if (GLOBAL.TTS && data.operateData.contentBtnFlag) {
            var txt = '';
            var index;
            var subStr;
            subStr = disStr.substr(0, 200);
            index = subStr.lastIndexOf(' ');
            subStr = disStr.substr(0, index);
            // DBG_INFO("UI.callTTS: " + subStr);
            var str = "";
            for (var i = 0; i < subStr.length; i++) {
                str = str + subStr.substr(i, 1).replace(UI.ttsReg, ' ').replace('-', ' dash ');
            }
            UI.ttsUtterance.text = str;
            try{
                Hisense.System.speak(UI.ttsUtterance.text);
            }catch (e){
                DBG_ERROR(e.message)
            }
            data.operateData.disStr = disStr.replace(subStr, "");


        }
    }
    function fteTTSSpeakEvent(eventType) {
        var data = disclaimer.pageData;
        DBG_ERROR("fteTTSSpeakEvent");
        var index;
        var subStr;
        if (data.operateData.disStr.length > 0&& data.operateData.contentBtnFlag) {
            if (data.operateData.disStr.length > 200) {
                subStr = data.operateData.disStr.substr(0, 200);
                index = subStr.lastIndexOf(' ');
                subStr = data.operateData.disStr.substr(0, index);
            }
            else {
                subStr = data.operateData.disStr.substr(0, data.operateData.disStr.length);
            }

            //DBG_INFO("UI.callTTS: " + subStr);
            var str = "";
            for (var i = 0; i < subStr.length; i++) {
                str = str + subStr.substr(i, 1).replace(UI.ttsReg, ' ').replace('-', ' dash ');
            }
            UI.ttsUtterance.text = str;
            try{
                Hisense.System.speak(UI.ttsUtterance.text);
            }catch (e){
                DBG_ERROR(e.message)
            }
            data.operateData.disStr = data.operateData.disStr.replace(subStr, "")
        }
    }
    if(tv && GLOBAL.TTS){
        Hisense.System.setTTSListener(fteTTSSpeakEvent);
    }

    function fteDisContentUp() {
        var data = disclaimer.pageData;
        var contenthigh = $("#DisInfoBox").height();
        var boxheigh = $("#DisInfoCon").height();
        if (data.operateData.currenheight > 0) {
            if (data.operateData.currenheight > data.operateData.step) {
                data.operateData.currenheight -= data.operateData.step;
            }
            else {
                data.operateData.currenheight = 0;
            }
            $("#DisInfoBox").css("top", "-" + data.operateData.currenheight + "px");
            var temp = parseInt(840 / contenthigh * data.operateData.currenheight);
            $("#DisInfoScrollBar").css("top", temp);
        }
    }

    function fteDisContentDown() {
        var data = disclaimer.pageData;
        var contenthigh = $("#DisInfoBox").height();
        var boxheigh = $("#DisInfoCon").height();
        if ((contenthigh - data.operateData.currenheight) > boxheigh) {
            data.operateData.currenheight += data.operateData.step;
            $("#DisInfoBox").css("top", "-" + data.operateData.currenheight + "px");
            var temp = parseInt(840 / contenthigh * data.operateData.currenheight);


            if (temp > 840 - $("#DisInfoScrollBar").height()) {
                temp = 840 - $("#DisInfoScrollBar").height()
            }
            $("#DisInfoScrollBar").css("top", temp);
        }
    }

    function getFile(address) {
        var xmlhttp = new XMLHttpRequest();
        xmlhttp.open("GET", address, false);
        xmlhttp.send();
        var xmlDoc = xmlhttp.responseText;

        return xmlDoc;
    }
}