UI.moduleBuilder['FTE']['fte_background'] = function() {
    var backgroundData = {
        tempImg1: "FTE/fte_bg_default.png",
//        leftArrow: "FTE/fte_arrow_left.png",
//        rightArrow: "FTE/fte_arrow_right.png",
        backImg: "FTE/fte_back.png"
    };
    var template = Util.readJson("module/FTE/fte_background.json");
    var background = SubModule.create(backgroundData, template);
    var navbarTiles = UI.getItem(background, "navbarTiles");
    var backImg = UI.getItem(background, "backImg");
//    var leftArrow = UI.getItem(background, "leftArrow");
//    var rightArrow = UI.getItem(background, "rightArrow");

    background.currFocus = UI.getItem(background, "backImg");

    function rewriteNavbar() {

        navbarTiles.removeAllChildren();
        navbarTiles.initSequence = [];
        var navbar = [];
        for (var i = 0; i < FTE.fteNavbarContent.length; i++) {
            navbar.push({});
            navbar[i].navName = FTE.fteNavbarContent[i];
            navbar[i].name = "fteNav" + i;
            navbar[i].selectImg = "FTE/fte_step_check.png";
        }
        var navinfo = {
            template: "fte_background_item",
            direction: CONST.GIRD_DIRECTION.v,
            breakNum: 1,
            distanceX: 8,
            distanceY: 0,
            container: navbarTiles,
            x: 0,
            y: 0
        };
        Gird.create(navbar, navinfo);
    }

    rewriteNavbar();



    background.onPush = function () {
        background.close();
        rewriteNavbar();
        DBG_INFO("FTE start from step: " + FTE.fteStepIndex);
        if (getWizardSetFlag() != 0 && !!FTE.fteStepIndex) {
            startFteFormStep(FTE.fteStepIndex); //从当前步开始FTE
        }
        else {
            startFteFormStep(0);
        }
        UI.updateStage();
    };


    background.onFocus = function () {
    };
    background.onNormal = function () {
    };

//    background.leftArrowDisplay = function (flag) {
//        leftArrow.alpha = flag;
//        UI.updateStage();
//    };
//    background.rightArrowDisplay = function (flag) {
//        rightArrow.alpha = flag;
//        UI.updateStage();
//    };

    var openFlag = false;
    background.close = function(){
        background.alpha = 0;
        openFlag = false;
        UI.updateStage();
    };

    background.open = function(){
        if(openFlag == false){
            background.alpha = 1;
            openFlag = true;
        }
        UI.updateStage();
    };

    //确定从哪个页面启动
    function startFteFormStep(step) {
        try{
            if(step >=  FTE.fteSequence.length){
                DBG_ERROR("FTE.fteSequence.length is " + FTE.fteSequence.length);
                step = 0;
            }
            fteSetStep(step);
            UI.pushSubModule("FTE", FTE.fteSequence[step], true);
            DBG_INFO("[fteStart] current page is " + FTE.fteTitle[step]);
        }catch(ex){
            fteSetStep(0);
            UI.pushSubModule("FTE", FTE.fteSequence[0], true);
            DBG_ERROR(ex.message);
        }
    }
}


function fteSetStep(step) {
    FTE.fteStepIndex = step;
    var background = UI.getSubModule("fte_background");
    var navbarTiles = UI.getItem(background, "navbarTiles");

    for(var i = 0; i < FTE.fteSequence.length; i++){
        if(!!FTE.fteStepIndex && i <= FTE.fteStepIndex -1){
            navbarTiles.children[i].children[0].alpha = 0;
            navbarTiles.children[i].children[1].alpha = 1;
        }
        else{
            navbarTiles.children[i].children[0].alpha = 1;
            navbarTiles.children[i].children[1].alpha = 0;
        }
    }
    hideLastSteps();
    UI.updateStage();
}

function hideLastSteps(){
    var background = UI.getSubModule("fte_background");
    var navbarTiles = UI.getItem(background, "navbarTiles");
    var navbarLength = FTE.fteSequence.length;
    if(GLOBAL.UI_BRAND != "tos"){
        navbarTiles.children[navbarLength -2].children[0].alpha = 0;
        navbarTiles.children[navbarLength -2].children[1].alpha = 0;
    }

    navbarTiles.children[navbarLength -1].children[0].alpha = 0;
    navbarTiles.children[navbarLength -1].children[1].alpha = 0;
    UI.updateStage();

}

function fteUpdate(dir) {   //0: 前进; 1:后退;
    var fteIndex = FTE.fteStepIndex;
    var background = UI.getSubModule("fte_background");
    var navbarTiles = UI.getItem(background, "navbarTiles");

    if(dir > 0) {
        if (fteIndex == FTE.fteSequence.length-1) {
            return;
        }
        for(var i = 0; i < FTE.fteSequence.length; i++){
            if(i <= fteIndex ){
                navbarTiles.children[i].children[0].alpha = 0;
                navbarTiles.children[i].children[1].alpha = 1;
            }
            else{
                navbarTiles.children[i].children[0].alpha = 1;
                navbarTiles.children[i].children[1].alpha = 0;
            }
        }
        fteIndex = fteIndex < FTE.fteSequence.length-1? fteIndex+dir: FTE.fteSequence.length-1;
        FTE.fteStepIndex = fteIndex;    //update FTE.fteStepIndex
        UI.popSubModule();
        UI.pushSubModule("FTE", FTE.fteSequence[fteIndex], true);
    }
    else {
        if (fteIndex == 0) {
            return;
        }
        for(var i = 0; i < FTE.fteSequence.length; i++){
            if(i <= fteIndex + dir -1){
                navbarTiles.children[i].children[0].alpha = 0;
                navbarTiles.children[i].children[1].alpha = 1;
            }
            else{
                navbarTiles.children[i].children[0].alpha = 1;
                navbarTiles.children[i].children[1].alpha = 0;
            }
        }
        fteIndex = fteIndex > 0? fteIndex+ dir: 0;
        FTE.fteStepIndex = fteIndex;    //update FTE.fteStepIndex
        UI.popSubModule();
        UI.pushSubModule("FTE", FTE.fteSequence[fteIndex], true);
    }
    DBG_INFO("[fteUpdate] current page is " + FTE.fteTitle[FTE.fteStepIndex]);
    hideLastSteps();
    setWizardStep(FTE.fteStepIndex);

    UI.updateStage();
}

function hideNavbarOrNot(flag){

    var background = UI.getSubModule("fte_background");
    var navbarTiles = UI.getItem(background, "navbarTiles");
    var backImg = UI.getItem(background, "backImg");

    navbarTiles.alpha = flag;
    backImg.alpha = flag;
    UI.updateStage();

}