UI.moduleBuilder['Alexa']['weatherTemplate'] = function(){
    var weatherTemplateData = {
        bodyTemplate1Bg:"Alexa/card_bg.png",
        skillIcon:"",
        logoIcon:"Alexa/avs_logo_template.png"
    };
    var template = Util.readJson("module/Alexa/weatherTemplate.json");
    var weatherTemplate =  SubModule.create(weatherTemplateData, template);

    weatherTemplate.num = 3;

    var mainTitle = UI.getItem(weatherTemplate, "mainTitle");
    var subTitle = UI.getItem(weatherTemplate, "subTitle");
    var skillIcon = UI.getItem(weatherTemplate, "skillIcon");

    var currentWeather = UI.getItem(weatherTemplate, "currentWeather");
    var currentWeatherIcon = UI.getItem(weatherTemplate, "currentWeatherIcon");
    var currentWeatherData = UI.getItem(weatherTemplate, "currentWeatherData");
    var currHighTemperature = UI.getItem(weatherTemplate, "currHighTemperature");
    var currLowTemperature = UI.getItem(weatherTemplate, "currLowTemperature");
    var backgroundImg = UI.getItem(weatherTemplate, "backgroundImg");
    var tiles = UI.getItem(weatherTemplate, "tiles");

    weatherTemplate.weatherForecastImg = [];//["Alexa/avs_logo.png","Alexa/avs_logo.png","Alexa/avs_logo.png","Alexa/avs_logo.png","Alexa/avs_logo.png"/*,"rrr","ttt","hhh"*/];
    weatherTemplate.weatherForecastData = [];//["aaa","ccc","ccc","fff","eee"/*,"rrr","ttt","hhh"*/];
    weatherTemplate.highTemperature = [];//["aaa","ccc","ccc","fff","eee"/*"6、","7、","8","9","10","11","12","13","14"*/];
    weatherTemplate.lowTemperature = [];//["aaa","ccc","ccc","fff","eee"/*,"rrr","ttt","hhh"*/];

    creatWeatherList(weatherTemplate.weatherForecastImg, weatherTemplate.weatherForecastData,weatherTemplate.highTemperature,weatherTemplate.lowTemperature);
    function creatWeatherList(weatherForecastImg,weatherForecastData,highTemperature,lowTemperature){
        tiles.removeAllChildren();
        var listTemp = [];
        for (var i=0; i < weatherTemplate.num; i++) {
            listTemp.push({});
            listTemp[i].name = "weatherListTemp" + i;
            listTemp[i].weatherForecastImg =  weatherForecastImg[i];
            listTemp[i].weatherForecastData = weatherForecastData[i];
            listTemp[i].highTemperature = highTemperature[i];
            listTemp[i].lowTemperature = lowTemperature[i];
        }
        var info = {
            template: "alexa_weather_item",
            direction: CONST.GIRD_DIRECTION.H,
            breakNum: 3,
            distanceX: 40,
            distanceY: 30,
            container: tiles
        };
        Gird.create(listTemp, info);
        UI.addMask(tiles, 544, 210, 50, 3);
        UI.setView(tiles, 544, 210);
        UI.addScrollbar(tiles,-50);
    }


    weatherTemplate.currFocus = tiles.children[0];

    weatherTemplate.onPush = function(){
        var graphics = new PIXI.Graphics()
            .beginFill(0x000000, 0.85)
            .drawRect(0, 0, 1920, 1080)
            .endFill();
        UI.setImage(backgroundImg,graphics);
    }
    weatherTemplate.onShow = function(){
        if(!tv){
            UI.setImageforMedia(currentWeatherIcon,"Alexa/musicTest.png",null,true,null);
            UI.setText(currentWeatherData, "54°");
            UI.setText(currHighTemperature, "76°");
            UI.setText(currLowTemperature, "45°");
            weatherTemplate.weatherForecastImg = ["Alexa/musicTest.png","Alexa/musicTest.png","Alexa/musicTest.png","Alexa/musicTest.png","Alexa/avs_logo.png","Alexa/avs_logo.png","Alexa/avs_logo.png","Alexa/avs_logo.png"/*,"rrr","ttt","hhh"*/];
            weatherTemplate.weatherForecastData = ["Wed","Thu","Fri","20°","20°","20°","20°","20°"];
            weatherTemplate.highTemperature = ["71°","68°","69°","50°","60°","66°","44°","24°"];
            weatherTemplate.lowTemperature = ["55°","54°","53°","20°","20°","20°","20°","20°"];
            creatWeatherList(weatherTemplate.weatherForecastImg, weatherTemplate.weatherForecastData,weatherTemplate.highTemperature,weatherTemplate.lowTemperature);
            return;
        }
        if (!weatherTemplate.param) {
            DBG_ERROR("template is null");
            return;
        }
        if(weatherTemplate.param.skillIcon != null && weatherTemplate.param.skillIcon.length != 0){
            mainTitle.originWidth = 380;
            subTitle.originWidth = 380
        }else{
            mainTitle.originWidth = 600;
            subTitle.originWidth = 600
        }
        UI.setText(mainTitle,weatherTemplate.param.mainTitle);
        UI.setText(subTitle,weatherTemplate.param.subTitle);
        UI.setImage(skillIcon, weatherTemplate.param.skillIcon,null,true,null);

        UI.setText(currentWeatherData, weatherTemplate.param.currentWeather);
        UI.setText(currHighTemperature, weatherTemplate.param.highTemperature.value);
        UI.setText(currLowTemperature, weatherTemplate.param.lowTemperature.value);
        UI.setImage(currentWeatherIcon, weatherTemplate.param.currentWeatherIcon,null,true,null);

        if (!!weatherTemplate.param.weatherForecast) {
            var weatherForecastImg = [];
            var weatherForecastData = [];
            var highTemperature = [];
            var lowTemperature = [];
            for (var i = 0; i < weatherTemplate.param.weatherForecast.length; i++) {
                weatherForecastImg.push(weatherTemplate.param.weatherForecast[i].image);
                weatherForecastData.push(weatherTemplate.param.weatherForecast[i].day);
                highTemperature.push(weatherTemplate.param.weatherForecast[i].highTemperature);
                lowTemperature.push(weatherTemplate.param.weatherForecast[i].lowTemperature);
            }
            creatWeatherList(weatherForecastImg, weatherForecastData, highTemperature, lowTemperature);
        }

    }

   weatherTemplate.afterPush = function(){
       weatherTemplate.currFocus = tiles.children[0];
   }

    weatherTemplate.onFocus = function(focus){
        UI.moveCursor(UI.adjustView());
        UI.getTween(focus.scale).wait(100).to({x:1, y:1}, 500, UI.ease.quartOut);
        UI.getTween(UI.base.cursor).wait(100).to({alpha:0}, 500, UI.ease.quartOut);
        UI.moveTop(focus);
        UI.base.runText(focus);
        return false;
    }

    weatherTemplate.onNormal = function(focus){
        UI.getTween(focus.scale).to({x:1, y:1}, 200);
        UI.base.stopText(focus);
        return false;
    }

    weatherTemplate.onPop = function(){
    }

    weatherTemplate.onkey = function(focus,evt){
        DBG_INFO("weatherTemplate evt.keyCode=" + evt.keyCode);
        if (evt.value == "DOWN") {
            if(tiles.children.length <= 3 ){
                UI.popSubModule();
                return;
            }
            return true;
        } else if (evt.value == "UP") {
            if(tiles.children.length <= 3 ){
                UI.popSubModule();
                return;
            }
            return true;
        } else if (evt.value == "VOICE" || evt.value == "VOICE_DOWN" || evt.value == "VOICE_UP") {
            return true;
        } else {
            UI.popSubModule();
            return (Alexa_globalKeys.indexOf(evt.keyCode) >= 0);
        }
    }
}