UI.moduleBuilder['Alexa']['register_hisense'] = function() {
    var hisenseAccountData = {
        loadingImg:"Alexa/register/loading.png",
        title: "[SE3681]",//Hisense Account
        helpText:"[SE3948]",
        refreshBtnImg:UI.item_bg,
        refreshBtnText:"[SS0020]"//Refresh
    };
    var template = Util.readJson("module/Alexa/register_hisense.json");
    var register_hisense = SubModule.create(hisenseAccountData, template);

    var title = UI.getItem(register_hisense, "title");
    var refreshBtn = UI.getItem(register_hisense, "refreshBtn");
    var loadingImg = UI.getItem(register_hisense, "loadingImg");
    var codeMainFrame = UI.getItem(register_hisense, "codeMainFrame");
    var errorMainFrame = UI.getItem(register_hisense, "errorMainFrame");
    var codeMainFrameText1 = UI.getItem(register_hisense, "codeMainFrameText1");
    var codeMainFrameText2 = UI.getItem(register_hisense, "codeMainFrameText2");
    var codeMainFrameText3 = UI.getItem(register_hisense, "codeMainFrameText3");
    var errorMainFrameText = UI.getItem(register_hisense, "errorMainFrameText");
    var hide = 0;
    var show = 1;

    register_hisense.web = "";
    register_hisense.code = "xxxxxxxxx";
    register_hisense.hisenseTime = 0;
    register_hisense.errorMsg = "";
    register_hisense.currfocus = title;
    register_hisense.expireTimer = null;
    register_hisense.protected = true;

    register_hisense.onPush = function(){
        register_hisense.currFocus = title;
        displayPageMsg(show,hide,hide);
        AVSClient.register.getRegisterInfo("hisense");
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_ONHISMESSAGECHANGED, onHiMsgChanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_ONHISENSEREGISTERRESULT, hiCloudCallback);
    };

    register_hisense.onFocus = function(){
        if(UI.getCurrFocus().name != "refreshBtn"){
            UI.base.cursor.alpha = 0;
            UI.getTween(UI.base.cursor).set({alpha: 0});
            return false;
        }else{
            return true;
        }
    }

    function displayPageMsg(a,b,c){
        registerLoading(a);
        codeMainFrame.alpha = b;
        errorMainFrame.alpha = c;
        UI.updateStage();
    }

    function hiCloudCallback(cloudState){
        clearTimeout(register_hisense.expireTimer);
        DBG_ERROR("cloudState is " + cloudState);
        switch (cloudState){
            case 1: //success
                registerUpdate(1);
                break;
            case 0: //fail
                displayPageMsg(hide,hide,show);
                register_hisense.errorMsg = "[SE3949]";
                UI.setText(errorMainFrameText,register_hisense.errorMsg);
                UI.focusTo(refreshBtn);
                UI.updateStage();
                break;
            default:
                break;
        }
    }

    function onHiMsgChanged(url, code, time){
        if(url == undefined){
            return;
        }
        DBG_ERROR("onHiMsgChanged : url is " + url + ", code is " + code + ", expire time is " + time);
        registerLoading(0);
        displayPageMsg(hide,show,hide);
        register_hisense.web =  url ;
        register_hisense.code = code;
        register_hisense.hisenseTime = parseInt(time/60) ;
        UI.setText(codeMainFrameText1,"[SE3950]", null, null, null, null, [register_hisense.web]);
        UI.setText(codeMainFrameText2,register_hisense.code);
        UI.setText(codeMainFrameText3,"[SE3951]", null, null, null, null,[register_hisense.hisenseTime]);
        UI.focusTo(codeMainFrameText1);
        clearTimeout(register_hisense.expireTimer);
        register_hisense.expireTimer = setTimeout(function(){
            DBG_ERROR("register_hisense expireTimer");
            displayPageMsg(hide,hide,show);
            register_hisense.errorMsg = "[SE3952]";
            UI.setText(errorMainFrameText,register_hisense.errorMsg);
            UI.focusTo(refreshBtn);
            UI.updateStage();
        },time * 1000);
        //notify remote app
        if(tv){
            try{
                pubAvsRegisterCode(url,code);
            }catch(ex){
                DBG_ERROR(ex.message);
            }
        }
    }

    register_hisense.afterPush = function(){
        if(!tv){
            setTimeout(function(){
                onHiMsgChanged("www.baidu.com","ABD" ,600);
                setTimeout(function(){
                 hiCloudCallback(1);
                 },1000);
            },3000);
        }
        UI.updateStage();
    }

    register_hisense.onPop = function(){
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AVS_ONHISMESSAGECHANGED, onHiMsgChanged);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AVS_ONHISENSEREGISTERRESULT, hiCloudCallback);
        clearTimeout(register_hisense.expireTimer);
    }

    refreshBtn.onkey_ENTER = function(){
        //todo
        displayPageMsg(show,hide,hide);
        AVSClient.register.getRegisterInfo("hisense");

    }


    function registerLoading(flag) {
        if (flag) {
            loadingImg.alpha = 1;
            UI.getTween(loadingImg, true, true).to({rotation: loadingImg.rotation + Math.PI*2}, 1000);
        }
        else {
            loadingImg.alpha = 0;
            createjs.Tween.removeTweens(loadingImg);
        }

    }
}
