UI.moduleBuilder['Alexa']['helpInfo'] = function(){
    var template = Util.readJson("module/Alexa/helpInfo.json");
    var helpInfoData = {
        helpInfo_bg: UI.window_bg,
        btn_left_bg: UI.item_bg,
        btn_right_bg: UI.item_bg,
        btn_right_text: "",
        btn_left_text: "",
        helpInfoContent: ""//Config.language["LA0080"] + " " + Config.language["LA0081"]
    };

    var helpInfoTip = SubModule.create(helpInfoData, template);
    helpInfoTip.protected = true;
    var BtnRight = UI.getItem(helpInfoTip, "BtnRight");
    var BtnLeft = UI.getItem(helpInfoTip, "BtnLeft");

    var helpInfoContent = UI.getItem(helpInfoTip, "helpInfoContent");
    var btn_left_text = UI.getItem(helpInfoTip, "btn_left_text");
    var btn_right_text = UI.getItem(helpInfoTip, "btn_right_text");
    helpInfoTip.currFocus = BtnRight;
    BtnRight.alpha = BtnLeft.alpha = 0.6;

    UI.getItem(helpInfoTip, "helpInfoContent").alpha = 0.6;
    helpInfoTip.onFocus = function (focus) {
      return true;
    }
    helpInfoTip.onNormal = function (focus) {
        return true;
    }

    BtnRight.onkey_ENTER = function () {
        UI.popSubModule();
        if(helpInfoTip.param.destination == "BluetoothSetting"){
            UI.pushSubModule("setting", "BluetoothSetting", true);
            return;
        }

        if(helpInfoTip.param.destination == "SettingSysAlexa"){
            UI.pushSubModule("setting", "SettingSysAlexa", true);
        }
    }

    helpInfoTip.onShow = function () {
        helpInfoTip.currFocus = BtnRight;
        UI.setText(helpInfoContent,helpInfoTip.param.helpInfoContent);//"Voice Service has been disabled.Please go to System Setting to enabled it."
        UI.setText(btn_left_text,"[GE0008]");
        UI.setText(btn_right_text,helpInfoTip.param.btn_right_text);
    }

    helpInfoTip.onPop = function () {
        BtnRight.scale.x = 1;
        BtnRight.scale.y = 1;
        BtnLeft.scale.x = 1;
        BtnLeft.scale.y = 1;
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.scale.x = 1;
        UI.base.cursor.scale.y = 1;
        UI.base.cursor.alpha = 0;
    }

    function closeNetworkTip() {
        UI.popSubModule();
        /*if(networkTip.param.caller.toString()=="mainTiles"){
            UI.popAllModule();
            //var lastfocus = launcher.lastfocus;
            if(!!launcher.lastfocus.data.obj.locked && GLOBAL.PARENTAL_LOCK_SWITCH){
                UI.pushSubModule("launcher", "launcherPassword",true, null, {caller: "mainTiles"});
            }
            else{
                if(launcher.lastfocus.data.obj.url == "search-hisense"){
                    UI.pushSubModule("searchUSO", "search", true, null, {caller: "networkTip"});
                }else if(launcher.lastfocus.data.obj.url == "4know-hisense"){
                    UI.pushSubModule("fourknow", "fourknowMain", true, null, {caller: "networkTip"});
                }else if(launcher.lastfocus.data.obj.url == "appstore-hisense"){
                    UI.pushSubModule("AppStore", "appStore", true, null, {caller: "networkTip"});
                }else{
                    startThirdPartyApp(null, launcher.lastfocus.data.obj.url, launcher.lastfocus.data.obj.urlType, CMDMethod.MENU, false, "#FFFFFF");
                }
            }
        }
        else if(networkTip.param.caller.toString()=="allApps"){
            UI.popAllModule();
            //var lastfocus2 = launcher.lastfocus;
            if(!!launcher.lastfocus.data.locked && GLOBAL.PARENTAL_LOCK_SWITCH){
                UI.pushSubModule("launcher", "launcherPassword",true, null, {caller: "allApps"});
            }
            else{
                if(launcher.lastfocus.data.url == "search-hisense"){
                    UI.pushSubModule("searchUSO", "search", true);
                }else if(launcher.lastfocus.data.url == "4know-hisense"){
                    UI.pushSubModule("fourknow", "fourknowMain", true);
                }else if(launcher.lastfocus.data.url == "appstore-hisense"){
                    UI.pushSubModule("AppStore", "appStore", true);
                }else{
                    startThirdPartyApp(null, launcher.lastfocus.data.url, launcher.lastfocus.data.urlType, CMDMethod.MENU, false, "#FFFFFF",launcher.lastfocus.data.name);
                }

            }
        }
        else{*/
          /*  closeMsgBox();
            resumeDTV();
            openLiveTVModule();*/
//        }
    }
    BtnLeft.onkey_ENTER = helpInfoTip.onkey_ESCAPE = helpInfoTip.onkey_BACKSPACE = closeNetworkTip;
};