
UI.templateManager["module/AcrNotificationToast/AcrNotificationToast.json"] = {
    "AcrNotificationToast": {
        "type": 0,
        "position": {
            "x": 550,
            "y": 836
        },
        "items": {
            "mainToastAcr":{
                "type" : 0,
                "position" : {"x" :0, "y" :0},
                "navigation" : {"leftTo" : "", "rightTo" : "", "upTo" : "", "downTo" : ""},
                "items" : {
                    "mainToastBgImgAcr" : {
                        "type" : 7,
                        "bound" : {"w" :820, "h" :280},
                        "position" : {"x" :0, "y" :0}
                    },
                    "mainToastImgAcr" : {
                        "type" : 7,
                        "bound" : {"w" :180, "h" :180},
                        "position" : {"x" :50, "y" :50}
                    },
                    "mainToastImgAcrNetwork" : {
                        "type" : 7,
                        "bound" : {"w" :48, "h" :48},
                        "position" : {"x" :706, "y" :62}
                    },
                    "mainToastTitleAcr" : {
                        "type" : 6,
                        "bound" : {"w":450, "h":36},
                        "innerPos" : {"x" :0, "y" :0},
                        "value" :"Title Title Title Title  Title Title Title Title Title  Title",
                        "font" :"36px SourceSansPro-Bold",
                        "color" :"#363E4D",
                        "align" :"left",
                        "position" : {"x" :246, "y" :58}
                    },
                    "mainToastTextAcr" : {
                        "type" : 6,
                        "bound" : {"w":510, "h":304},
                        "innerPos" : {"x" :0, "y" :0},
                        "value" :"HDMI1 Lost Signal HDMI1 Lost Signal HDMI1 Lost Signal HDMI1 Lost Signal HDMI1 Lost Signal HDMI1 Lost Signal",
                        "font" :"30px SourceSansPro-Light",
                        "color" :"#363E4D",
                        "lineHeight":2,
                        "align" :"left",
                        "maxLines":3,
                        "warp":true,
                        "position" : {"x" :246, "y" :112}
                    }
                }
            }
        }
    }
};
UI.moduleBuilder['AcrNotificationToast']['AcrNotificationToast'] = function(){
    /*default data*/
    var template = Util.readJson("module/AcrNotificationToast/AcrNotificationToast.json");
    var mainPanelData = {
        mainToastBgImgAcr : "toast/acr_bg_toast.png",
        mainToastImgAcrNetwork : "toast/default.png",
        mainToastImgAcr:"toast/default.png"
    };
    var AcrNotificationToast = SubModule.create(mainPanelData, template);
    var mainToastAcr = UI.getItem(AcrNotificationToast, "mainToastAcr");
    var mainToastImgAcr = UI.getItem(mainToastAcr, "mainToastImgAcr");
    var mainToastImgAcrNetwork = UI.getItem(mainToastAcr, "mainToastImgAcrNetwork");
    var mainToastTitleAcr = UI.getItem(mainToastAcr, "mainToastTitleAcr");
    var mainToastTextAcr = UI.getItem(mainToastAcr, "mainToastTextAcr");

    mainToastAcr.alpha = 0;
    UI.updateStage();
    var timeOut = 0;
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.ACR_MSG, processAcrMsg);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CURRENT_SOURCE_CHANGED, processSourceChangedAcr);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CURRENT_CHANNEL_CHANGED, processChannelChangedAcr);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CURRENT_COUNTRY_CHANGED, processCountryChangedAcr);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CURRENT_LANGUAGE_CHANGED, processLanguageChangedAcr);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.TIME_ZONE_CHANGED, processTimezoneChangedAcr);
//    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AM_STATE_CHANGED, processTimezoneChangedAcr);
    try{
        if(acrflag){
            DBG_ERROR("!!!!!!!!!!!!!start Acr setListener!!!!!!!!!!");
            AcrJSI.setListener(function (msg, len) {
                processAcrMsg(msg, len);
            });
            AcrJSI.init();
        }
    }catch(e){
        DBG_ERROR("AcrJSI.setListener:"+ e.message);
    }

    // model.system.onUserModeChaged = processUserModeChagedAcr;
    // model.tts.onI32SwitchStatusChaged = processTtsSwitchStatusChangedAcr;

    function hideAcrNotificationToast(){
        mainToastAcr.alpha = 0;
        UI.updateStage();
    }

    function processAcrMsg(msg,len) {
        if (msg === undefined || msg === null) {
            return;
        }
        var msgObj = {};
        try {
            msgObj = JSON.parse(msg);
            DBG_ERROR("processAcrMsg:::::"+ JSON.stringify(msgObj));
            DBG_ERROR("g_acrSwitch.acrNotification:"+ g_acrSwitch.acrNotification);
            if(msgObj.type == "transient"){
                if(msgObj.show == "1"){
                    if (checkIsAppOn(APPNAME.NETFLIX) || g_acrSwitch.acrNotification==0){
                        mainToastAcr.alpha = 0;
                        UI.updateStage();
                        return;
                    }
                    AcrNotificationToast.alpha = 1;
                    mainToastAcr.alpha = 1;
                    var icon = msgObj.content[0].iconURL;
                    var networkIcon = msgObj.content[0].networkURL;
                    var title = msgObj.content[0].title;
                    var detail = msgObj.content[0].body;
                    detail = detail.replace(/['\n']/g,' ');
                    UI.setImage(mainToastImgAcr,icon);
                    UI.setImage(mainToastImgAcrNetwork,networkIcon);
                    UI.setText(mainToastTitleAcr,title);
                    UI.setText(mainToastTextAcr,detail);
                    clearTimeout(timeOut);
                    var maxSeconds = parseInt(msgObj.maxSeconds);
                    timeOut = setTimeout(hideAcrNotificationToast,maxSeconds*1000);
                }
            }else if(msgObj.type == "quiet"){
                if(msgObj.show == "1"){
                    var item = {
                        "date": getSystemLongTimeForNotification(),
                        "data": msgObj,
                        "endTime":0,
                        "cmd": LauncherCMD.ACRMSG
                    };
                    g_acrNotification.push(item);
                    g_notificationCrtTimeStamp = item.date;
                }else {
                    if(g_acrNotification.length>0){
                        for(var i=0;i<g_acrNotification.length;i++){
                            if(g_acrNotification[i].data.id == msgObj.id){
                                g_acrNotification.splice(i,1);
                                break;
                            }
                        }
                    }
                }
            }
        } catch (e) {
            DBG_ERROR("processAcrMsg:::::"+ e.message);
        }

    }



    function processSourceChangedAcr(val){
        if(!acrflag || !isCurCountryhasACR()){
            return;
        }
        var sourceMap = {
            0: "TV",
            1: "AV",
            2: "COMPONENT",
            3: "VGA",
            4: "HDMI 1",
            5: "HDMI 2",
            6: "HDMI 3",
            7: "HDMI 4",
            8: "SCART"
        };
        try {
            var id = mapInputsDataByPlayId(val);
            AcrJSI.inputSource("inputName",sourceMap[id]);
            AcrJSI.inputSource("appName",sourceMap[id]);
        }catch (e) {
            DBG_ERROR("processSourceChangedAcr:"+ e.message);
        }
    }


    function processChannelChangedAcr(val){
        if(!acrflag || !isCurCountryhasACR()){
            return;
        }
        try {
            if (GLOBAL.CURRENT_SOURCE != SourceList.TV || checkIsAppOn()) return ;
            if (ECode.REJECTARR.indexOf(val[MPChannel.ECODE]) > -1 && 0 != val[MPChannel.UID]) return;
            var name = val.name;
            DBG_ERROR("processChannelChangedAcr Channel Name:"+ val.name);
            if(!!name){
                AcrJSI.inputSource("channelName",name);
            }else{
                AcrJSI.inputSource("channelName","analog");
            }
        }catch (e) {
            DBG_ERROR("processChannelChangedAcr:"+ e.message);
        }
    }

    function processCountryChangedAcr(val){
        if(!acrflag || !isCurCountryhasACR()){
            if(g_acrSwitch.acrStatus == AcrStatus.ACR_START){
                stopAcrServer("Setting");
                clearAcrNotification();
            }
            return;
        }
        if(g_acrSwitch.GlobalSwitch == AcrSwitch.ON){
            if(g_acrSwitch.lastSettingSwitch == AcrSwitch.ON){
                if(g_acrSwitch.acrStatus == AcrStatus.ACR_STOP){
                    startAcrServer("Setting");
                }
            }
        }

        try {
            var info = GLOBAL.CURRENT_LANGUAGE + '_'+ val;
            var acrInfo = info.toLowerCase();
            DBG_ERROR("processCountryChangedAcr:::::"+ acrInfo);
            AcrJSI.inputSource("localeName",acrInfo);
        }catch (e) {
            DBG_ERROR("processCountryChangedAcr:"+ e.message);
        }
    }

    function processLanguageChangedAcr(val){
        if(!acrflag || !isCurCountryhasACR()){
            return;
        }
        try {
            var info = ChangeLangNumToCode(val)  + '_'+ GLOBAL.CURRENT_COUNTRY;
            var acrInfo = info.toLowerCase();
            DBG_ERROR("processLanguageChangedAcr:::::"+ acrInfo);
            AcrJSI.inputSource("localeName",acrInfo);
        }catch (e) {
            DBG_ERROR("processLanguageChangedAcr:"+ e.message);
        }
    }

    function processTimezoneChangedAcr(val){
        if(!acrflag || !isCurCountryhasACR()){
            return;
        }
        var map = {
            0: "Eastern",
            1: "Indiana",
            2: "Central",
            3: "Mountain",
            4: "Arizona",
            5: "Pacific",
            6: "Alaska",
            7: "Hawaii",
//            8: "Alaska",
            9: "Newfoundland",
            10: "Atlantic"
        };
        try {
            AcrJSI.inputSource("deviceLocation",map[val]);
        }catch (e) {
            DBG_ERROR("processTimezoneChangedAcr:"+ e.message);
        }
    }

    function processUserModeChagedAcr(val){
        if(!acrflag || !isCurCountryhasACR()){
            return;
        }
        DBG_ERROR("processUserModeChagedAcr:"+ val);
        try {
            if(val == 0){
                if(g_acrSwitch.GlobalSwitch == AcrSwitch.ON){
                    if(g_acrSwitch.lastSettingSwitch == AcrSwitch.ON){
                        if(g_acrSwitch.acrStatus == AcrStatus.ACR_STOP){
                            startAcrServer("HomeMode");
                        }
                    }
                }
            }else{
                if(g_acrSwitch.acrStatus == AcrStatus.ACR_START){
                    stopAcrServer("StoreMode");
                }
            }
        }catch (e) {
            DBG_ERROR("processUserModeChagedAcr:"+ e.message);
        }
    }

    function processTtsSwitchStatusChangedAcr(val){
        DBG_ERROR("processTtsSwitchStatusChangedAcr:"+ val);
        if(!acrflag || !isCurCountryhasACR()){
            return;
        }
        try {
            if(val == 0){
                if(g_acrSwitch.GlobalSwitch == AcrSwitch.ON){
                    if(g_acrSwitch.lastSettingSwitch == AcrSwitch.ON){
                        if(g_acrSwitch.acrStatus == AcrStatus.ACR_STOP){
                            startAcrServer("TTS Disabled");
                        }
                    }
                }
            }else{
                if(g_acrSwitch.acrStatus == AcrStatus.ACR_START){
                    stopAcrServer("TTS Enabled");
                }
            }
        }catch (e) {
            DBG_ERROR("processTtsSwitchStatusChangedAcr:"+ e.message);
        }
    }

};