/**
 * Created by liutiantian on 2015/1/22.
 */

window.onload = function() {
    try {
        initIQQI();

        host.logger.i("system", "window.onload", "DI1210, enter.");
        host.logger.i("system", "window.onload", "DI1210, show browser: " + host.browser);
        if(host.tv) {
            try {
                if(!!window.Hisense && !!Hisense.loadLibrary) {
                    Hisense.loadLibrary("libvirtualkeyboard.so");
                }
            }
            catch(ex) {
                host.logger.e("system", "window.onload", "show error when load so: " + ex, ex);
            }

            if(!!window.opera_omi) {
                opera_omi.addPlatformEventListener(function(cmdstr) {
                    var space = {};

                    if(host.tv) {
                        host.screen = host.tools.queryScreenFromUrl("type");

                        var info = JSON.parse(cmdstr);
                        if(!!info) {
                            for(var key in info) {
                                if(info.hasOwnProperty(key)) {
                                    host.logger.i("system", "PlatformEventListener", "show info[" + key + "]: " + info[key]);
                                }
                            }

                            switch(info.type) {
                                case "1":
                                    space.viewType = "password";
                                    space.workType = "password";
                                    host.config.curMode = Tools.MODE_PASSWORD;
                                    break;
                                case "2":
                                    space.viewType = "text";
                                    space.workType = "number";
                                    host.config.curMode = Tools.MODE_NUM1;
                                    break;
                                case "3":
                                    space.viewType = "password";
                                    space.workType = "password";
                                    host.config.curMode = Tools.MODE_NUM1;
                                    break;
                                default :
                                    space.viewType = "text";
                                    space.workType = "text";
                                    host.config.curMode = Tools.MODE_LANGUAGE;
                                    break;
                            }

                            space.curLang = info.lang;
                            space.value = info.msg;

                            switch(info.lang) {
                                case "PER":
                                    space.curLang = "FAS";
                                    break;
                                case "MAL":
                                    space.curLang = "MSA";
                                    break;
                                case "HBR":
                                    space.curLang = "HEB";
                                    break;
                                case "CZE":
                                    space.curLang = "CES";
                                    break;
                            }

                            host.logger.i("system", "PlatformEventListener", "show type: " + info.type + "; curLang: " + info.lang + "; oldValue: " + info.msg);
                        }
                        host.config.inputAttr = space.type || "text";
                    }

                    host.logger.i("system", "PlatformEventListener", "show screen: " + host.screen);

                    
                    startIQQI.call(space);
                })
            }
        }

        window.onkeydown = host.keyboard.onKeyDown.bind(host.keyboard);

        if(host.tv == false) {
            host.mode = Tools.MODE_LANGUAGE;
            if(host.mode == Tools.MODE_PASSWORD) {
                host.config.curMode = Tools.MODE_PASSWORD;
                startIQQI.call({"curLang": host.config.curLangArray[0],
                    "curMode": host.config.curMode,
                    "viewType": "password",
                    "workType": "password"
                });
            }
            else {
                host.config.curMode = Tools.MODE_LANGUAGE;
                startIQQI.call({"curLang": host.config.curLangArray[0],
                    "curMode": host.config.curMode,
                    "viewType": "text",
                    "workType": "text"
                });
            }
        }
    }
    catch(ex) {
        host.logger.e("system", "window.onload", "show error when onload: " + ex, ex);
    }
};

window.onfocus = function() {
    host.logger.i("system", "window.onfocus", "enter.");
    if(!!window.opera_omi) {
        host.logger.i("system", "window.onfocus", "its very funny that new opera can have focus event on window object, we do nothing but return.");
        return;
    }

    try {
        if(host.tv == false) {
            return;
        }

        host.logger.i("system", "window.onfocus", "iqqi state: " + (host.iqqi && IQQIMainPage.stateToString(host.iqqi.pageState())));

        if(host.iqqi && host.iqqi.pageState() == IQQIMainPage.STATE_SHOWING) {
            return;
        }

        var space = {};

        if(host.tv) {
            host.screen = host.tools.queryScreenFromUrl("type");

            var info = Hisense.VirtualKeyBoard.getInfo();
            if(!!info) {
                var infos = info.split(";");
                switch(infos[0]) {
                    case "1":
                        space.viewType = "text";
                        space.workType = "password";
                        host.config.curMode = Tools.MODE_PASSWORD;
                        break;
                    case "2":
                        space.viewType = "text";
                        space.workType = "number";
                        host.config.curMode = Tools.MODE_NUM1;
                        break;
                    case "3":
                        space.viewType = "password";
                        space.workType = "password";
                        host.config.curMode = Tools.MODE_NUM1;
                        break;
                    default :
                        space.viewType = "text";
                        space.workType = "text";
                        host.config.curMode = Tools.MODE_LANGUAGE;
                        break;
                }

                space.curLang = infos[3];
                space.value = infos[4];

                switch(space.curLang) {
                    case "PER":
                        space.curLang = "FAS";
                        break;
                    case "MAL":
                        space.curLang = "MSA";
                        break;
                    case "HBR":
                        space.curLang = "HEB";
                        break;
                    case "CZE":
                        space.curLang = "CES";
                        break;
                }

                host.logger.i("system", "window.onfocus", "show type: " + infos[0] + "; curLang: " + infos[3] + "; oldValue: " + infos[4]);
            }
            host.config.inputAttr = space.type || "text";
        }

        host.logger.i("system", "window.onfocus", "show screen: " + host.screen);
        
        startIQQI.call(space);
    }
    catch(ex) {
        host.logger.e("system", "window.onfocus", "show error: " + ex, ex);
    }
};
