/**
 * Created by liutiantian on 2015/2/4.
 */
function IQQINativeInterface() {

    this.nativeInitialized = false;

    if(typeof IQQINativeInterface.initialized == 'undefined') {
        this.TYPE_CANDIDATE_ALL = 0;
        this.TYPE_CANDIDATE_SINGLE_CHARACTOR_WORD_ONLY = 1;
        this.TYPE_CANDIDATE_USER_DICTIONARY_WORD_FIRST_LONGEST_FIRST = 2;
        this.TYPE_CANDIDATE_USER_DICTIONARY_WORD_FIRST_SINGLE_WORD_FIRST = 3;

        IQQINativeInterface.prototype.IQQINativeInitialize = function() {
            if(this.nativeInitialized) {
                host.logger.i("native", "IQQINativeInterface.IQQINativeInitialize", "native has been initialized.");
                return;
            }
            var predicDBPath = '/var/local/IQQIRuntimeDB/PredicDB';//dbtag:20160921
            var userDBPath = '/var/local/IQQIRuntimeDB/UserDB';
            var iqqiResultInitial;
            try {
                iqqiResultInitial = imejs.iqqi.initial(predicDBPath, userDBPath);
            }
            catch(ex) {
                host.logger.e("native", "IQQINativeInterface.IQQINativeInitialize", "show error: " + ex, ex);
                this.nativeInitialized = false;
                return false;
            }

            if (iqqiResultInitial.rc < 0) {
                host.logger.i("native", "IQQINativeInterface.IQQINativeInitialize", "show rc: " + iqqiResultInitial.rc + "; and errMsg: " + iqqiResultInitial.errMsg);
                this.nativeInitialized = false;
                return false;
            }

            host.logger.i("native", "IQQINativeInterface.IQQINativeInitialize", "native has been successfully initialized");
            this.nativeInitialized = true;
            return true;
        };

        IQQINativeInterface.prototype.IQQINativeGetVersion = function(defVersion) {
            if(this.nativeInitialized == false) {
                host.logger.i("native", "IQQINativeInterface.IQQINativeGetVersion", "native has not been successfully initialized, defVersion returned.");
                return defVersion;
            }
            var iqqiResultVersion;
            try {
                iqqiResultVersion = imejs.iqqi.version();
            }
            catch(ex) {
                host.logger.e("native", "IQQINativeInterface.IQQINativeGetVersion", "exception happened, show error: " + ex, ex);
                return defVersion;
            }

            return iqqiResultVersion.version;
        };

        IQQINativeInterface.prototype.IQQINativeGetCandidateCount = function(root, lang, first, type) {
            if(this.nativeInitialized == false) {
                host.logger.i("native", "IQQINativeInterface.IQQINativeGetCandidateCount", "native has not been successfully initialized, -1 returned.");
                return -1;
            }
            if(lang == -1) {
                host.logger.i("native", "IQQINativeInterface.IQQINativeGetCandidateCount", "ime type is illegal, 1 returned.");
                return 1;
            }
            var iqqiResultGetCandidateCount;
            try {
                iqqiResultGetCandidateCount = imejs.iqqi.getCandidateCount(lang, root, first, type);
            }
            catch (ex) {
                host.logger.e("native", "IQQINativeInterface.IQQINativeGetCandidateCount", "iqqiNativeGetCandidateCount, show error: " + ex, ex);
                return -1;
            }

            if(iqqiResultGetCandidateCount.rc < 0) {
                host.logger.i("native", "IQQINativeInterface.IQQINativeGetCandidateCount", "show rc: " + iqqiResultGetCandidateCount.rc + "; and errMsg: " + iqqiResultGetCandidateCount.errMsg);
                return -1;
            }

            return iqqiResultGetCandidateCount.count;
        };

        /**
         * get candidates form native.
         * @param {string} root
         * @param {Number} lang
         * @param {Number} begin
         * @param {Number} count
         * @param {boolean} first
         * @param {Number} type
         * @returns {Array}
         * @constructor
         */
        IQQINativeInterface.prototype.IQQINativeGetCandidates = function(root, lang, begin, count, first, type) {
            var result = [];
            if(this.nativeInitialized == false) {
                host.logger.e("native", "IQQINativeInterface.IQQINativeGetCandidates", "native has not been successfully initialized, root " + root + ", returned as defalut.");
                first && result.push(root);
                return result;
            }
            if(lang == -1) {
                host.logger.e("native", "IQQINativeInterface.IQQINativeGetCandidateCount", "ime type is illegal, root returned.");
                first && result.push(root);
                return result;
            }
            var iqqiResultGetCandidates;
            try {
                iqqiResultGetCandidates = imejs.iqqi.getCandidates(lang, root, first, type, begin, count);
            }
            catch(ex) {
                host.logger.e("native", "IQQINativeInterface.IQQINativeGetCandidates, ", "show error: " + ex, ex);
                first && result.push(root);
                return result;
            }
            if (iqqiResultGetCandidates.rc < 0) {
                host.logger.e("native", "IQQINativeInterface.IQQINativeGetCandidates", "show rc: " + iqqiResultGetCandidates.rc + "; type: " + type + "; root: " + root + "; errMsg: " + iqqiResultGetCandidates.errMsg);
                first && result.push(root);
                return result;
            }

            for (var i = 0; i < iqqiResultGetCandidates.length; i++) {
                result.push(iqqiResultGetCandidates[i]);
            }
            return result;
        };

        IQQINativeInterface.prototype.IQQINativeLearnWord = function(lang, root, con) {
            if(this.nativeInitialized == false) {
                host.logger.i("native", "IQQINativeInterface.IQQINativeLearnWord", "native has not been successfully initialized, returned directly.");
                return;
            }
            var iqqiResultLearnWord;
            try {
                iqqiResultLearnWord = imejs.iqqi.learnWord(lang, root, con);
            }
            catch(ex) {
                host.logger.e("native", "IQQINativeInterface.IQQINativeLearnWord, ", "show error: " + ex, ex);
                return;
            }
            if (iqqiResultLearnWord.rc < 0) {
                host.logger.i("native", "IQQINativeInterface.IQQINativeLearnWord", "show rc: " + iqqiResultLearnWord.rc + "; and errMsg: " + iqqiResultLearnWord.errMsg);
                return;
            }
        };

        IQQINativeInterface.prototype.IQQINativeGetCurLangIQQIType = function(lang) {
            host.logger.i("native", "IQQINativeInterface.IQQINativeGetCurLangIQQIType", "show lang is " + lang);
            switch(lang) {
                case "ENG":
                    return imejs.iqqi.ENGLISH;
                case "CHI":
                    return imejs.iqqi.SIMPLIFIED_CHINESE_PINYIN;
            }
        };
    }
    IQQINativeInterface.initialized = true;
}
