/**
 * Created by liutiantian on 2015/1/22.
 */

function KeyEvent() {
    this.VK_LEFT = 37;
    this.VK_UP = 38;
    this.VK_RIGHT = 39;
    this.VK_DOWN = 40;
    this.VK_ESC = 27;
    this.VK_BACK = 8;
    this.VK_ENTER = 13;
    this.VK_GREEN = 408;
    this.VK_RED = 407;
    this.VK_YELLOW = 409;
    this.VK_BLUE = 410;

    this.STATE_DOWN = "down";

    var keys = {
        "IQQIMainPage": {
            "down": [this.VK_LEFT, this.VK_UP, this.VK_RIGHT, this.VK_DOWN, this.VK_ENTER, this.VK_ESC, this.VK_BACK, this.VK_RED, this.VK_GREEN, this.VK_YELLOW, this.VK_BLUE]
        },
        "IQQIButtonPanel": {
            "down": [this.VK_LEFT, this.VK_UP, this.VK_RIGHT, this.VK_DOWN, this.VK_ENTER]
        },
        "IQQICharPanel": {
            "down": [this.VK_LEFT, this.VK_UP, this.VK_RIGHT, this.VK_DOWN, this.VK_ENTER, this.VK_BACK]
        },
        "IQQIImagineUl": {
            "down": [this.VK_LEFT, this.VK_RIGHT, this.VK_ENTER]
        },
        "IQQILanSwitchDialog": {
            "down": [this.VK_UP, this.VK_DOWN, this.VK_ENTER, this.VK_ESC, this.VK_BACK]
        }
    };

    if(typeof KeyEvent.initialized == "undefined") {
        KeyEvent.prototype.validKeyEvent = function(type, state, keyCode, keyfrom) {
            if(!keys[type]) {
                return false;
            }
            else if(!keys[type][state]) {
                return false;
            }
            else if(keys[type][state].indexOf(keyCode) + 1 > 0) {
                if (keyCode == 37 && keyfrom == "Keyboard") {
                    return false;
                }
                return true;
            }
            return false;
        };
    }
    KeyEvent.initialized = true;
}

function KeyEventManager() {
    if(typeof KeyEventManager.initialized == "undefined") {
        KeyEventManager.prototype.onKeyDown = function(event) {
            host.logger.i("keyboard", "KeyEventManager.onKeyDown", "show event.which: " + event.which);
            if(host.keyevent.validKeyEvent(host.iqqi.type, host.keyevent.STATE_DOWN, event.which, event.keyFrom)) {
                if(host.iqqi.onKeyDown(event)) {
                    if(event.preventDefault) {
                        host.logger.i("keyboard", "KeyEventManager.onKeyDown", "shield event, show event.which: " + event.which);
                        event.preventDefault();
                    }
                }
            }

            if(!!this.isNumberKeyOfRemote(event)) {
                host.iqqi.buttonPanel.dispatchMessage({"what": host.constants.MSG_REMOTE_NUMBER_KEY_EVENT, "which": event.which});
                if(event.preventDefault) {
                    event.preventDefault();
                }
            }

            return true;
        };

        KeyEventManager.prototype.isNumberKeyOfRemote = function(event) {
            if(!!event["char"] && !!event["key"]) {
                return false;
            }
            if (event.keyFrom == "Keyboard") {
                return true;
            }
            if(event.which - 48 >= 0 && event.which - 48 <= 9) {
                return true;
            }
            return false;
        };
    }
    KeyEventManager.initialized = true;
}
